/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.codec;

import cn.fyupeng.enums.PackageType;
import cn.fyupeng.protocol.RpcRequest;
import cn.fyupeng.serializer.CommonSerializer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonEncoder
extends MessageToByteEncoder {
    private static final Logger log = LoggerFactory.getLogger(CommonEncoder.class);
    private static final short MAGIC_NUMBER = -17730;
    private final CommonSerializer serializer;
    private final String delimiter;

    public CommonEncoder(CommonSerializer serializer, String delimiter) {
        this.serializer = serializer;
        this.delimiter = delimiter;
    }

    protected void encode(ChannelHandlerContext ctx, Object msg, ByteBuf out) throws Exception {
        out.writeShort(-17730);
        if (msg instanceof RpcRequest) {
            out.writeByte(PackageType.REQUEST_PACK.getCode());
        } else {
            out.writeByte(PackageType.RESPONSE_PACK.getCode());
        }
        out.writeByte(this.serializer.getCode());
        byte[] bytes = this.serializer.serialize(msg);
        int length = bytes.length;
        out.writeInt(bytes.length);
        log.debug("encode object length [{}] bytes", (Object)length);
        out.writeBytes(bytes);
        out.writeBytes(this.delimiter.getBytes(StandardCharsets.UTF_8));
    }
}

