/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.config;

import cn.fyupeng.config.Configuration;
import cn.fyupeng.config.JRedisConfiguration;
import cn.fyupeng.config.LRedisConfiguration;
import cn.fyupeng.constant.PathConstants;
import cn.fyupeng.factory.SingleFactory;
import com.alibaba.nacos.common.utils.StringUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRedisConfiguration
implements Configuration {
    private static final Logger log = LoggerFactory.getLogger(AbstractRedisConfiguration.class);
    private static String defaultServerAddr = "127.0.0.1:6379";
    private static String defaultServerWay = "lettuce";
    private static String defaultClientWay = "lettuce";
    private static String defaultServerAsync = "false";
    protected static final String workerIds = "worker-ids";
    protected static final String workerIdsSet = "worker-ids-set";
    protected static final String retryReqIds = "retry-req-ids";
    private static String redisServerAddr;
    protected static String redisServerHost;
    protected static Integer redisServerPort;
    protected static String redisServerAuth;
    protected static String redisServerPwd;
    protected static String redisServerWay;
    protected static String redisClientWay;
    protected static String redisServerAsync;
    private static AbstractRedisConfiguration lRedisConfiguration;
    private static AbstractRedisConfiguration jRedisConfiguration;

    public static String getRedisServerAddr() {
        return redisServerAddr;
    }

    public static String getRedisServerHost() {
        return redisServerHost;
    }

    public static Integer getRedisServerPort() {
        return redisServerPort;
    }

    public static String getRedisServerAuth() {
        return redisServerAuth;
    }

    public static String getRedisServerPwd() {
        return redisServerPwd;
    }

    public static String getRedisServerWay() {
        return redisServerWay;
    }

    public static String getRedisClientWay() {
        return redisClientWay;
    }

    public static String getRedisServerAsync() {
        return redisServerAsync;
    }

    public static AbstractRedisConfiguration getServerConfig() {
        switch (redisClientWay) {
            case "jedis": {
                if (jRedisConfiguration == null) {
                    jRedisConfiguration = SingleFactory.getInstance(JRedisConfiguration.class).configure();
                }
                return jRedisConfiguration;
            }
            case "lettuce": {
                if (lRedisConfiguration == null) {
                    lRedisConfiguration = SingleFactory.getInstance(LRedisConfiguration.class).configure();
                }
                return lRedisConfiguration;
            }
        }
        if (jRedisConfiguration == null) {
            jRedisConfiguration = SingleFactory.getInstance(JRedisConfiguration.class).configure();
        }
        return jRedisConfiguration;
    }

    public static AbstractRedisConfiguration getClientConfig() {
        switch (redisClientWay) {
            case "jedis": {
                if (jRedisConfiguration == null) {
                    jRedisConfiguration = SingleFactory.getInstance(JRedisConfiguration.class).configure();
                }
                return jRedisConfiguration;
            }
            case "lettuce": {
                if (lRedisConfiguration == null) {
                    lRedisConfiguration = SingleFactory.getInstance(LRedisConfiguration.class).configure();
                }
                return lRedisConfiguration;
            }
        }
        if (jRedisConfiguration == null) {
            jRedisConfiguration = SingleFactory.getInstance(JRedisConfiguration.class).configure();
        }
        return jRedisConfiguration;
    }

    public abstract AbstractRedisConfiguration configure();

    public abstract boolean exists(String var1);

    public abstract void set(String var1, String var2);

    public abstract String get(String var1);

    public abstract boolean existsWorkerId(String var1);

    public abstract String getWorkerIdForHostName(String var1);

    public abstract void setWorkerId(String var1, long var2);

    public abstract void remWorkerId(String var1);

    public abstract void asyncRemWorkerId(String var1);

    public abstract boolean existsWorkerIdSet(long var1);

    public abstract void setWorkerIdSet(long var1);

    public abstract boolean existsRetryResult(String var1);

    public abstract String getResultForRetryRequestId2String(String var1);

    public abstract byte[] getResultForRetryRequestId2Bytes(String var1);

    public abstract void setRetryRequestResultByString(String var1, String var2);

    public abstract void setRetryRequestResultByBytes(String var1, byte[] var2);

    public abstract void asyncSet(String var1, String var2);

    public abstract void asyncSetWorkerIdSet(long var1);

    public abstract void asyncSetWorkerId(String var1, long var2);

    public abstract void asyncSetRetryRequestResult(String var1, byte[] var2);

    static {
        redisServerPwd = "";
        Object is = null;
        ResourceBundle configResource = null;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(PathConstants.ABSOLUTE_CONFIG_PATH));){
            String[] hostAndPort;
            configResource = new PropertyResourceBundle(bufferedReader);
            redisServerAuth = configResource.getString("cn.fyupeng.redis.server-auth");
            if ("false".equals(redisServerAuth) || "default".equals(redisServerAuth) || StringUtils.isBlank(redisServerAuth)) {
                redisServerAuth = "false";
                log.info("--- no redis auth ---");
                try {
                    redisServerAddr = configResource.getString("cn.fyupeng.redis.server-addr");
                    hostAndPort = redisServerAddr.split(":");
                    redisServerHost = hostAndPort[0];
                    redisServerPort = Integer.parseInt(hostAndPort[1]);
                }
                catch (MissingResourceException redisServerAddressException) {
                    String[] hostAndPort2 = defaultServerAddr.split(":");
                    redisServerHost = hostAndPort2[0];
                    redisServerPort = Integer.parseInt(hostAndPort2[1]);
                    log.warn("redis server address attribute is missing");
                    log.info("use default redis server address : " + defaultServerAddr);
                }
            } else {
                if ("true".equals(redisServerAuth)) {
                    log.info("redis auth attribute is true and start with auth");
                    try {
                        redisServerAddr = configResource.getString("cn.fyupeng.redis.server-addr");
                    }
                    catch (MissingResourceException redisServerAddressException) {
                        log.info("redis server address property attribute is missing: {}", (Object)redisServerAddressException.getMessage());
                        log.info("use default redis server address : " + defaultServerAddr);
                        String[] hostAndPort3 = defaultServerAddr.split(":");
                        redisServerHost = hostAndPort3[0];
                        redisServerPort = Integer.parseInt(hostAndPort3[1]);
                    }
                    try {
                        redisServerPwd = configResource.getString("cn.fyupeng.redis.server-pwd");
                        hostAndPort = redisServerAddr.split(":");
                        redisServerHost = hostAndPort[0];
                        redisServerPort = Integer.parseInt(hostAndPort[1]);
                    }
                    catch (MissingResourceException redisPasswordException) {
                        log.error("redis password attribute is missing: ", redisPasswordException);
                        throw new RuntimeException("redis password attribute is missing!");
                    }
                }
                throw new RuntimeException("redis auth attribute is illegal!");
            }
            try {
                redisServerWay = configResource.getString("cn.fyupeng.redis.server-way");
            }
            catch (MissingResourceException redisServerWayException) {
                redisServerWay = defaultServerWay;
                log.warn("redis server way attribute is missing");
                log.info("use default redis server way : " + defaultServerAddr);
            }
            try {
                redisClientWay = configResource.getString("cn.fyupeng.redis.client-way");
            }
            catch (MissingResourceException redisClientWayException) {
                redisClientWay = defaultClientWay;
                log.warn("redis client way attribute is missing");
                log.info("use default redis client way : " + defaultClientWay);
            }
            try {
                redisServerAsync = configResource.getString("cn.fyupeng.redis.server-async");
            }
            catch (MissingResourceException redisServerAsyncException) {
                redisServerAsync = defaultServerAsync;
                log.warn("redis server async attribute is missing");
                log.info("use default redis server async : " + defaultServerAsync);
            }
            log.info("read resource from resource path: {}", (Object)PathConstants.ABSOLUTE_CONFIG_PATH);
        }
        catch (MissingResourceException redisServerAuthException) {
            redisServerAuth = "false";
            log.warn("redis auth attribute is missing and start with no auth");
            try {
                String redisServerAddress = configResource.getString("cn.fyupeng.redis.server-addr");
                redisServerAddr = StringUtils.isBlank(redisServerAddress) ? defaultServerAddr : redisServerAddress;
                String[] hostAndPort = redisServerAddr.split(":");
                redisServerHost = hostAndPort[0];
                redisServerPort = Integer.parseInt(hostAndPort[1]);
            }
            catch (MissingResourceException redisServerAddressException) {
                String[] hostAndPort = defaultServerAddr.split(":");
                redisServerHost = hostAndPort[0];
                redisServerPort = Integer.parseInt(hostAndPort[1]);
                log.warn("redis server address attribute is missing");
                log.info("use default redis server address : " + defaultServerAddr);
            }
            try {
                redisServerWay = configResource.getString("cn.fyupeng.redis.server-way");
            }
            catch (MissingResourceException redisServerWayException) {
                redisServerWay = defaultServerWay;
                log.warn("redis server way attribute is missing");
                log.info("use default redis server way : " + defaultServerAddr);
            }
            try {
                redisClientWay = configResource.getString("cn.fyupeng.redis.client-way");
            }
            catch (MissingResourceException redisClientWayException) {
                redisClientWay = defaultClientWay;
                log.warn("redis client way attribute is missing");
                log.info("use default redis client way : " + defaultClientWay);
            }
            try {
                redisServerAsync = configResource.getString("cn.fyupeng.redis.server-async");
            }
            catch (MissingResourceException redisServerAsyncException) {
                redisServerAsync = defaultServerAsync;
                log.warn("redis server async attribute is missing");
                log.info("use default redis server async : " + defaultServerAsync);
            }
        }
        catch (IOException ioException) {
            log.info("not found resource from resource path: {}", (Object)PathConstants.ABSOLUTE_CONFIG_PATH);
            try {
                ResourceBundle resource;
                block59: {
                    resource = ResourceBundle.getBundle("resource");
                    try {
                        redisServerAuth = resource.getString("cn.fyupeng.redis.server-auth");
                        if ("false".equals(redisServerAuth) || "default".equals(redisServerAuth) || StringUtils.isBlank(redisServerAuth)) {
                            redisServerAuth = "false";
                            log.info("--- no redis auth ---");
                            try {
                                redisServerAddr = resource.getString("cn.fyupeng.redis.server-addr");
                                String[] hostAndPort = redisServerAddr.split(":");
                                redisServerHost = hostAndPort[0];
                                redisServerPort = Integer.parseInt(hostAndPort[1]);
                            }
                            catch (MissingResourceException redisServerAddressException) {
                                String[] hostAndPort = defaultServerAddr.split(":");
                                redisServerHost = hostAndPort[0];
                                redisServerPort = Integer.parseInt(hostAndPort[1]);
                                log.warn("redis server address attribute is missing");
                                log.info("use default redis server address : " + defaultServerAddr);
                            }
                            break block59;
                        }
                        if ("true".equals(redisServerAuth)) {
                            log.info("redis auth attribute is true and start with auth");
                            try {
                                redisServerAddr = resource.getString("cn.fyupeng.redis.server-addr");
                            }
                            catch (MissingResourceException redisServerAddressException) {
                                log.info("redis server address property attribute is missing: {}", (Object)redisServerAddressException.getMessage());
                                log.info("use default redis server address : " + defaultServerAddr);
                                String[] hostAndPort = defaultServerAddr.split(":");
                                redisServerHost = hostAndPort[0];
                                redisServerPort = Integer.parseInt(hostAndPort[1]);
                            }
                            try {
                                redisServerPwd = resource.getString("cn.fyupeng.redis.server-pwd");
                                String[] hostAndPort = redisServerAddr.split(":");
                                redisServerHost = hostAndPort[0];
                                redisServerPort = Integer.parseInt(hostAndPort[1]);
                                break block59;
                            }
                            catch (MissingResourceException redisPasswordException) {
                                log.error("redis password attribute is missing: ", redisPasswordException);
                                throw new RuntimeException("redis password attribute is missing!");
                            }
                        }
                        throw new RuntimeException("redis auth attribute is illegal!");
                    }
                    catch (MissingResourceException redisServerAuthException) {
                        redisServerAuth = "false";
                        log.warn("redis auth attribute is missing and start with no auth");
                        try {
                            String redisServerAddress = resource.getString("cn.fyupeng.redis.server-addr");
                            redisServerAddr = StringUtils.isBlank(redisServerAddress) ? defaultServerAddr : redisServerAddress;
                            String[] hostAndPort = redisServerAddr.split(":");
                            redisServerHost = hostAndPort[0];
                            redisServerPort = Integer.parseInt(hostAndPort[1]);
                        }
                        catch (MissingResourceException redisServerAddressException) {
                            String[] hostAndPort = defaultServerAddr.split(":");
                            redisServerHost = hostAndPort[0];
                            redisServerPort = Integer.parseInt(hostAndPort[1]);
                            log.warn("redis server address attribute is missing");
                            log.info("use default redis server address : " + defaultServerAddr);
                        }
                    }
                }
                try {
                    redisServerWay = resource.getString("cn.fyupeng.redis.server-way");
                }
                catch (MissingResourceException redisServerWayException) {
                    redisServerWay = defaultServerWay;
                    log.warn("redis server way attribute is missing");
                    log.info("use default redis server way : " + defaultServerAddr);
                }
                try {
                    redisClientWay = resource.getString("cn.fyupeng.redis.client-way");
                }
                catch (MissingResourceException redisClientWayException) {
                    redisClientWay = defaultClientWay;
                    log.warn("redis client way attribute is missing");
                    log.info("use default redis client way : " + defaultClientWay);
                }
                try {
                    redisServerAsync = resource.getString("cn.fyupeng.redis.server-async");
                }
                catch (MissingResourceException redisServerAsyncException) {
                    redisServerAsync = defaultServerAsync;
                    log.warn("redis server async attribute is missing");
                    log.info("use default redis server async : " + defaultServerAsync);
                }
            }
            catch (MissingResourceException resourceException) {
                log.info("not found resource from resource path: {}", (Object)"resource.properties");
                log.info("Connect to default address {}", (Object)defaultServerAddr);
                String[] hostAndPort = defaultServerAddr.split(":");
                redisServerHost = hostAndPort[0];
                redisServerPort = Integer.parseInt(hostAndPort[1]);
                redisServerWay = defaultServerWay;
                log.info("use default redis server way : " + defaultServerAddr);
                redisClientWay = defaultClientWay;
                log.info("use default redis client way : " + defaultClientWay);
                redisServerAsync = defaultServerAsync;
                log.info("use default redis server async : " + defaultServerAsync);
            }
            log.info("read resource from resource path: {}", (Object)"resource.properties");
        }
        log.info("------------ redis Configuration \u3010 begin \u3011 ------------");
        log.info("redisServerHost: [{}]", (Object)redisServerHost);
        log.info("redisServerPort: [{}]", (Object)redisServerPort);
        log.info("redisServerAuth: [{}]", (Object)redisServerAuth);
        log.info("redisServerPwd: [{}]", (Object)redisServerPwd);
        log.info("redisServerWay: [{}]", (Object)redisServerWay);
        log.info("redisClientWay: [{}]", (Object)redisClientWay);
        log.info("redisServerAsync: [{}]", (Object)redisServerAsync);
        log.info("------------ redis Configuration \u3010 end \u3011 ------------");
    }
}

