/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.config;

import cn.fyupeng.config.AbstractRedisConfiguration;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.SetArgs;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DefaultClientResources;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LRedisConfiguration
extends AbstractRedisConfiguration {
    private static final Logger log = LoggerFactory.getLogger(LRedisConfiguration.class);
    private RedisURI.Builder uriBuilder;
    private StatefulRedisConnection<String, byte[]> strToByteConn;
    private StatefulRedisConnection<String, String> strToStrConn;
    private RedisAsyncCommands<String, byte[]> strToByteAsyncCommand;
    private RedisAsyncCommands<String, String> strToStrAsyncCommand;
    private RedisCommands<String, byte[]> strToByteSyncCommand;
    private RedisCommands<String, String> strToStrSyncCommand;

    @Override
    public synchronized AbstractRedisConfiguration configure() {
        if (this.uriBuilder == null) {
            this.uriBuilder = RedisURI.builder();
            if ("false".equals(redisServerAuth)) {
                this.uriBuilder.withHost(redisServerHost).withPort(redisServerPort);
            } else {
                this.uriBuilder.withHost(redisServerHost).withPort(redisServerPort).withAuthentication("default", redisServerPwd);
            }
            RedisURI uri = this.uriBuilder.build();
            DefaultClientResources resources = DefaultClientResources.builder().ioThreadPoolSize(4).computationThreadPoolSize(4).build();
            RedisClient client = RedisClient.create((ClientResources)resources, uri);
            ClientOptions options = ClientOptions.builder().autoReconnect(true).pingBeforeActivateConnection(true).build();
            client.setOptions(options);
            client.setDefaultTimeout(Duration.ofSeconds(5L));
            this.strToByteConn = client.connect(RedisCodec.of(new StringCodec(), new ByteArrayCodec()));
            this.strToStrConn = client.connect();
            this.strToByteAsyncCommand = this.strToByteConn.async();
            this.strToStrAsyncCommand = this.strToStrConn.async();
            this.strToByteSyncCommand = this.strToByteConn.sync();
            this.strToStrSyncCommand = this.strToStrConn.sync();
        }
        return this;
    }

    @Override
    public boolean exists(String key) {
        return this.strToStrSyncCommand.exists((String[])new String[]{key}) != 0L;
    }

    @Override
    public void set(String key, String value) {
        log.debug("syncSet key[{}] - value[{}]", (Object)key, (Object)value);
        this.strToStrSyncCommand.set(key, value);
    }

    @Override
    public void asyncSet(String key, String value) {
        log.debug("asyncSet key[{}] - value[{}]", (Object)key, (Object)value);
        this.strToStrAsyncCommand.set(key, value);
    }

    @Override
    public String get(String key) {
        String value = (String)this.strToStrSyncCommand.get(key);
        log.debug("get key[{}] - value[{}]", (Object)key, (Object)value);
        return value;
    }

    @Override
    public boolean existsWorkerIdSet(long workerId) {
        return this.strToStrSyncCommand.sismember("worker-ids-set", String.valueOf(workerId));
    }

    @Override
    public void setWorkerIdSet(long workerId) {
        log.debug("setWorkerIdSet set[{}] - value[{}]", (Object)"worker-ids-set", (Object)workerId);
        this.strToStrSyncCommand.sadd("worker-ids-set", (String[])new String[]{String.valueOf(workerId)});
    }

    public void setWorkerIdSet(String workerId) {
        this.strToStrSyncCommand.sadd("worker-ids-set", (String[])new String[]{workerId});
    }

    @Override
    public void asyncSetWorkerIdSet(long workerId) {
        log.debug("asyncSetWorkerIdSet set[{}] - value[{}]", (Object)"worker-ids-set", (Object)workerId);
        this.strToStrAsyncCommand.sadd("worker-ids-set", (String[])new String[]{String.valueOf(workerId)});
    }

    @Override
    public boolean existsWorkerId(String hostName) {
        return this.strToStrSyncCommand.exists((String[])new String[]{"worker-ids:" + hostName}) != 0L;
    }

    @Override
    public String getWorkerIdForHostName(String hostName) {
        String value = (String)this.strToStrSyncCommand.get("worker-ids:" + hostName);
        log.debug("getForHostName key[{}] - value[{}]", (Object)hostName, (Object)value);
        return value;
    }

    @Override
    public void asyncSetWorkerId(String hostName, long workerId) {
        log.debug("asyncSetWorkerId key[{}] - value[{}]", (Object)hostName, (Object)workerId);
        this.strToStrAsyncCommand.set("worker-ids:" + hostName, String.valueOf(workerId));
    }

    @Override
    public void setWorkerId(String hostName, long workerId) {
        log.debug("SetWorkerId key[{}] - value[{}]", (Object)hostName, (Object)workerId);
        this.strToStrSyncCommand.set("worker-ids:" + hostName, String.valueOf(workerId));
    }

    @Override
    public void remWorkerId(String hostName) {
        log.debug("remWorkerId key[{}]", (Object)hostName);
        String workerId = this.getWorkerIdForHostName(hostName);
        this.strToStrSyncCommand.del((String[])new String[]{"worker-ids:" + hostName});
        if (workerId != null) {
            this.strToStrSyncCommand.srem("worker-ids-set", (String[])new String[]{workerId});
        }
    }

    @Override
    public void asyncRemWorkerId(String hostName) {
        log.debug("remWorkerId key[{}]", (Object)hostName);
        String workerId = this.getWorkerIdForHostName(hostName);
        this.strToStrAsyncCommand.del((String[])new String[]{"worker-ids:" + hostName});
        if (workerId != null) {
            this.strToStrAsyncCommand.srem("worker-ids-set", (String[])new String[]{workerId});
        }
    }

    @Override
    public boolean existsRetryResult(String retryRequestId) {
        return this.strToStrSyncCommand.exists((String[])new String[]{"retry-req-ids:" + retryRequestId}) != 0L;
    }

    @Override
    public String getResultForRetryRequestId2String(String retryRequestId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getResultForRetryRequestId2Bytes(String retryRequestId) {
        byte[] value = (byte[])this.strToByteSyncCommand.get("retry-req-ids:" + retryRequestId);
        log.debug("getForRetryRequestId key[{}] - value[{}]", (Object)retryRequestId, (Object)value);
        return value;
    }

    @Override
    public void setRetryRequestResultByString(String retryRequestId, String result) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRetryRequestResultByBytes(String retryRequestId, byte[] result) {
        log.debug("syncSetRetryRequestResult key[{}] - value[{}]", (Object)retryRequestId, (Object)result);
        this.strToByteSyncCommand.set("retry-req-ids:" + retryRequestId, result, new SetArgs().nx().ex(60L));
    }

    @Override
    public void asyncSetRetryRequestResult(String retryRequestId, byte[] result) {
        log.debug("SetRetryRequestResult key[{}] - value[{}]", (Object)retryRequestId, (Object)result);
        this.strToByteAsyncCommand.set("retry-req-ids:" + retryRequestId, result, new SetArgs().nx().ex(60L));
    }
}

