/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.net.netty.client;

import cn.fyupeng.protocol.RpcRequest;
import cn.fyupeng.serializer.CommonSerializer;
import cn.hutool.core.bean.BeanUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestParser
extends MessageToMessageEncoder<RpcRequest> {
    private static final Logger log = LoggerFactory.getLogger(RequestParser.class);
    private CommonSerializer serializer;

    public RequestParser(CommonSerializer serializer) {
        this.serializer = serializer;
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, RpcRequest rpcRequest, List<Object> list) throws Exception {
        System.out.println("rpcRequest");
        System.out.println(rpcRequest);
        RpcRequest req = BeanUtil.toBean(rpcRequest, RpcRequest.class);
        req.setParamTypes(this.adaptParamTypes(rpcRequest.getParamTypes()));
        req.setReturnType(this.adaptParamTypes(rpcRequest.getReturnType()));
        req.setMethodName(this.adaptMethodName(rpcRequest.getMethodName()));
        list.add(req);
    }

    private String[] adaptParamTypes(String[] paramTypes) throws ClassNotFoundException {
        String[] adaptParamTypes = new String[paramTypes.length];
        if (CommonSerializer.CJSON_SERIALIZER.intValue() == this.serializer.getCode()) {
            for (int idx = 0; idx < paramTypes.length; ++idx) {
                Class<?> paramTypeClazz = Class.forName(paramTypes[idx]);
                if (String.class.equals(paramTypeClazz)) {
                    adaptParamTypes[idx] = "string";
                    continue;
                }
                if (Float.class.equals(paramTypeClazz) || Float.TYPE.equals(paramTypeClazz)) {
                    adaptParamTypes[idx] = "float32";
                    continue;
                }
                if (Double.class.equals(paramTypeClazz) || Double.TYPE.equals(paramTypeClazz)) {
                    adaptParamTypes[idx] = "float64";
                    continue;
                }
                if (!Integer.class.equals(paramTypeClazz) && !Integer.TYPE.equals(paramTypeClazz)) continue;
                adaptParamTypes[idx] = "int";
            }
            return adaptParamTypes;
        }
        return paramTypes;
    }

    private String adaptParamTypes(String returnType) throws ClassNotFoundException {
        String adaptParamType = "";
        if (CommonSerializer.CJSON_SERIALIZER.intValue() == this.serializer.getCode()) {
            Class<?> returnTypeClazz = Class.forName(returnType);
            if (String.class.equals(returnTypeClazz)) {
                adaptParamType = "string";
            } else if (Float.class.equals(returnTypeClazz) || Float.TYPE.equals(returnTypeClazz)) {
                adaptParamType = "float32";
            } else if (Double.class.equals(returnTypeClazz) || Double.TYPE.equals(returnTypeClazz)) {
                adaptParamType = "float64";
            } else if (Integer.class.equals(returnTypeClazz) || Integer.TYPE.equals(returnTypeClazz)) {
                adaptParamType = "int";
            }
            return adaptParamType;
        }
        return returnType;
    }

    private String adaptMethodName(String methodName) {
        if (CommonSerializer.CJSON_SERIALIZER.intValue() == this.serializer.getCode()) {
            return StringUtils.capitalize(methodName);
        }
        return methodName;
    }
}

