/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.net.netty.client;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnprocessedResults<T> {
    private static final Logger log = LoggerFactory.getLogger(UnprocessedResults.class);
    private ConcurrentMap<String, CompletableFuture<T>> unprocessedResponseFutures = new ConcurrentHashMap<String, CompletableFuture<T>>();
    private static ConcurrentMap<String, Integer> unprocessedResponseReentrantCounts = new ConcurrentHashMap<String, Integer>();

    public void put(String id, CompletableFuture<T> future) {
        Integer reentrantCount = (Integer)unprocessedResponseReentrantCounts.get(id);
        if (this.unprocessedResponseFutures.containsKey(id)) {
            unprocessedResponseReentrantCounts.put(id, reentrantCount + 1);
            return;
        }
        this.unprocessedResponseFutures.put(id, future);
        unprocessedResponseReentrantCounts.put(id, 0);
    }

    public void remove(String id) {
        Integer reentrantCount = (Integer)unprocessedResponseReentrantCounts.get(id);
        if (this.unprocessedResponseFutures.containsKey(id) && reentrantCount > 0) {
            unprocessedResponseReentrantCounts.put(id, reentrantCount - 1);
            return;
        }
        this.unprocessedResponseFutures.remove(id);
    }

    public void complete(String id, T result) {
        Integer reentrantCount = (Integer)unprocessedResponseReentrantCounts.get(id);
        if (this.unprocessedResponseFutures.containsKey(id) && reentrantCount > 0) {
            unprocessedResponseReentrantCounts.put(id, reentrantCount - 1);
            CompletableFuture completableFuture = (CompletableFuture)this.unprocessedResponseFutures.get(id);
            completableFuture.complete(result);
            return;
        }
        CompletableFuture completableFuture = (CompletableFuture)this.unprocessedResponseFutures.remove(id);
        completableFuture.complete(result);
    }
}

