/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.net.socket.server;

import cn.fyupeng.exception.UnSupportBodyException;
import cn.fyupeng.exception.UnrecognizedException;
import cn.fyupeng.handler.JdkRequestHandler;
import cn.fyupeng.protocol.RpcRequest;
import cn.fyupeng.protocol.RpcResponse;
import cn.fyupeng.serializer.CommonSerializer;
import cn.fyupeng.util.AesEncoder;
import cn.fyupeng.util.ObjectReader;
import cn.fyupeng.util.ObjectWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketRequestHandlerThread
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SocketRequestHandlerThread.class);
    private Socket socket;
    private JdkRequestHandler requestHandler;
    private CommonSerializer serializer;
    private static final CommonSerializer jsonSerializer = CommonSerializer.getByCode(CommonSerializer.JSON_SERIALIZER);

    public SocketRequestHandlerThread(Socket socket, JdkRequestHandler requestHandler, CommonSerializer serializer) {
        this.socket = socket;
        this.requestHandler = requestHandler;
        this.serializer = serializer;
    }

    @Override
    public void run() {
        Object response = null;
        try (ObjectInputStream ois = new ObjectInputStream(this.socket.getInputStream());
             ObjectOutputStream oos = new ObjectOutputStream(this.socket.getOutputStream());){
            RpcRequest rpcRequest = (RpcRequest)ObjectReader.readObject(ois);
            Object result = this.requestHandler.handler(rpcRequest);
            byte[] checkData = jsonSerializer.serialize(result);
            String checkCode = AesEncoder.encrypt(new String(checkData));
            if (result instanceof Exception) {
                RpcResponse rpcResponse = RpcResponse.failure(((Exception)result).getMessage(), rpcRequest.getRequestId());
                ObjectWriter.writeObject(oos, rpcResponse, this.serializer);
            } else {
                RpcResponse rpcResponse = RpcResponse.success(result, rpcRequest.getRequestId(), checkCode);
                ObjectWriter.writeObject(oos, rpcResponse, this.serializer);
            }
        }
        catch (UnSupportBodyException | UnrecognizedException | IOException e) {
            log.error("Error occurred while invoking or sent,info:  ", e);
        }
    }
}

