/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.codec;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import java.util.List;

public class PunyCode {
    private static final int TMIN = 1;
    private static final int TMAX = 26;
    private static final int BASE = 36;
    private static final int INITIAL_N = 128;
    private static final int INITIAL_BIAS = 72;
    private static final int DAMP = 700;
    private static final int SKEW = 38;
    private static final char DELIMITER = '-';
    public static final String PUNY_CODE_PREFIX = "xn--";

    public static String encodeDomain(String domain) throws UtilException {
        Assert.notNull(domain, "domain must not be null!", new Object[0]);
        List<String> split2 = StrUtil.split((CharSequence)domain, '.');
        StringBuilder result = new StringBuilder(domain.length() * 4);
        for (String str : split2) {
            if (result.length() != 0) {
                result.append('.');
            }
            result.append(PunyCode.encode(str, true));
        }
        return result.toString();
    }

    public static String encode(CharSequence input) throws UtilException {
        return PunyCode.encode(input, false);
    }

    public static String encode(CharSequence input, boolean withPrefix) throws UtilException {
        Assert.notNull(input, "input must not be null!", new Object[0]);
        int n = 128;
        int delta = 0;
        int bias = 72;
        StringBuilder output = new StringBuilder();
        int length = input.length();
        int b = 0;
        for (int i = 0; i < length; ++i) {
            char c = input.charAt(i);
            if (!PunyCode.isBasic(c)) continue;
            output.append(c);
            ++b;
        }
        if (b > 0) {
            if (b == length) {
                return output.toString();
            }
            output.append('-');
        }
        int h2 = b;
        while (h2 < length) {
            int c;
            int m3 = Integer.MAX_VALUE;
            for (int i = 0; i < length; ++i) {
                c = input.charAt(i);
                if (c < n || c >= m3) continue;
                m3 = c;
            }
            if (m3 - n > (Integer.MAX_VALUE - delta) / (h2 + 1)) {
                throw new UtilException("OVERFLOW");
            }
            delta += (m3 - n) * (h2 + 1);
            n = m3;
            for (int j = 0; j < length; ++j) {
                int t;
                c = input.charAt(j);
                if (c < n && 0 == ++delta) {
                    throw new UtilException("OVERFLOW");
                }
                if (c != n) continue;
                int q = delta;
                int k = 36;
                while (q >= (t = k <= bias ? 1 : (k >= bias + 26 ? 26 : k - bias))) {
                    output.append((char)PunyCode.digit2codepoint(t + (q - t) % (36 - t)));
                    q = (q - t) / (36 - t);
                    k += 36;
                }
                output.append((char)PunyCode.digit2codepoint(q));
                bias = PunyCode.adapt(delta, h2 + 1, h2 == b);
                delta = 0;
                ++h2;
            }
            ++delta;
            ++n;
        }
        if (withPrefix) {
            output.insert(0, PUNY_CODE_PREFIX);
        }
        return output.toString();
    }

    public static String decodeDomain(String domain) throws UtilException {
        Assert.notNull(domain, "domain must not be null!", new Object[0]);
        List<String> split2 = StrUtil.split((CharSequence)domain, '.');
        StringBuilder result = new StringBuilder(domain.length() / 4 + 1);
        for (String str : split2) {
            if (result.length() != 0) {
                result.append('.');
            }
            result.append(StrUtil.startWithIgnoreEquals(str, PUNY_CODE_PREFIX) ? PunyCode.decode(str) : str);
        }
        return result.toString();
    }

    public static String decode(String input) throws UtilException {
        Assert.notNull(input, "input must not be null!", new Object[0]);
        input = StrUtil.removePrefixIgnoreCase(input, PUNY_CODE_PREFIX);
        int n = 128;
        int i = 0;
        int bias = 72;
        StringBuilder output = new StringBuilder();
        int d = input.lastIndexOf(45);
        if (d > 0) {
            for (int j = 0; j < d; ++j) {
                char c = input.charAt(j);
                if (!PunyCode.isBasic(c)) continue;
                output.append(c);
            }
            ++d;
        } else {
            d = 0;
        }
        int length = input.length();
        while (d < length) {
            int oldi = i;
            int w = 1;
            int k = 36;
            while (true) {
                char c;
                int digit;
                if (d == length) {
                    throw new UtilException("BAD_INPUT");
                }
                if ((digit = PunyCode.codepoint2digit(c = input.charAt(d++))) > (Integer.MAX_VALUE - i) / w) {
                    throw new UtilException("OVERFLOW");
                }
                i += digit * w;
                int t = k <= bias ? 1 : (k >= bias + 26 ? 26 : k - bias);
                if (digit < t) break;
                w *= 36 - t;
                k += 36;
            }
            bias = PunyCode.adapt(i - oldi, output.length() + 1, oldi == 0);
            if (i / (output.length() + 1) > Integer.MAX_VALUE - n) {
                throw new UtilException("OVERFLOW");
            }
            n += i / (output.length() + 1);
            output.insert(i %= output.length() + 1, (char)n);
            ++i;
        }
        return output.toString();
    }

    private static int adapt(int delta, int numpoints, boolean first) {
        delta = first ? (delta /= 700) : (delta /= 2);
        delta += delta / numpoints;
        int k = 0;
        while (delta > 455) {
            delta /= 35;
            k += 36;
        }
        return k + 36 * delta / (delta + 38);
    }

    private static boolean isBasic(char c) {
        return c < '\u0080';
    }

    private static int digit2codepoint(int d) throws UtilException {
        Assert.checkBetween(d, 0, 35);
        if (d < 26) {
            return d + 97;
        }
        if (d < 36) {
            return d - 26 + 48;
        }
        throw new UtilException("BAD_INPUT");
    }

    private static int codepoint2digit(int c) throws UtilException {
        if (c - 48 < 10) {
            return c - 48 + 26;
        }
        if (c - 97 < 26) {
            return c - 97;
        }
        throw new UtilException("BAD_INPUT");
    }
}

