/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api.naming.utils;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.utils.StringUtils;

public class NamingUtils {
    public static String getGroupedName(String serviceName, String groupName) {
        if (StringUtils.isBlank(serviceName)) {
            throw new IllegalArgumentException("Param 'serviceName' is illegal, serviceName is blank");
        }
        if (StringUtils.isBlank(groupName)) {
            throw new IllegalArgumentException("Param 'groupName' is illegal, groupName is blank");
        }
        String resultGroupedName = groupName + "@@" + serviceName;
        return resultGroupedName.intern();
    }

    public static String getServiceName(String serviceNameWithGroup) {
        if (StringUtils.isBlank(serviceNameWithGroup)) {
            return "";
        }
        if (!serviceNameWithGroup.contains("@@")) {
            return serviceNameWithGroup;
        }
        return serviceNameWithGroup.split("@@")[1];
    }

    public static String getGroupName(String serviceNameWithGroup) {
        if (StringUtils.isBlank(serviceNameWithGroup)) {
            return "";
        }
        if (!serviceNameWithGroup.contains("@@")) {
            return "DEFAULT_GROUP";
        }
        return serviceNameWithGroup.split("@@")[0];
    }

    public static void checkServiceNameFormat(String combineServiceName) {
        String[] split2 = combineServiceName.split("@@");
        if (split2.length <= 1) {
            throw new IllegalArgumentException("Param 'serviceName' is illegal, it should be format as 'groupName@@serviceName'");
        }
        if (split2[0].isEmpty()) {
            throw new IllegalArgumentException("Param 'serviceName' is illegal, groupName can't be empty");
        }
    }

    public static String getGroupedNameOptional(String serviceName, String groupName) {
        return groupName + "@@" + serviceName;
    }

    public static void checkInstanceIsLegal(Instance instance) throws NacosException {
        if (instance.getInstanceHeartBeatTimeOut() < instance.getInstanceHeartBeatInterval() || instance.getIpDeleteTimeout() < instance.getInstanceHeartBeatInterval()) {
            throw new NacosException(400, "Instance 'heart beat interval' must less than 'heart beat timeout' and 'ip delete timeout'.");
        }
    }
}

