/*
 * Decompiled with CFR 0.152.
 */
package io.fury.builder;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import io.fury.Fury;
import io.fury.builder.BaseObjectCodecBuilder;
import io.fury.builder.CompatibleCodecBuilder;
import io.fury.builder.Generated;
import io.fury.builder.MetaSharedCodecBuilder;
import io.fury.builder.ObjectCodecBuilder;
import io.fury.codegen.CodeGenerator;
import io.fury.codegen.CompileUnit;
import io.fury.resolver.FieldResolver;
import io.fury.serializer.Serializer;
import io.fury.type.ClassDef;
import java.util.Collections;

public class CodecUtils {
    public static <T> Class<? extends Serializer<T>> loadOrGenObjectCodecClass(Class<T> cls, Fury fury) {
        Preconditions.checkNotNull(fury);
        ObjectCodecBuilder codecBuilder = new ObjectCodecBuilder(cls, fury);
        return CodecUtils.loadOrGenCodecClass(cls, fury, codecBuilder);
    }

    public static <T> Class<? extends Serializer<T>> loadOrGenMetaSharedCodecClass(Fury fury, Class<T> cls, ClassDef classDef) {
        Preconditions.checkNotNull(fury);
        MetaSharedCodecBuilder codecBuilder = new MetaSharedCodecBuilder(TypeToken.of(cls), fury, classDef);
        return CodecUtils.loadOrGenCodecClass(cls, fury, codecBuilder);
    }

    public static <T> Class<? extends Serializer<T>> loadOrGenCompatibleCodecClass(Class<T> cls, Fury fury) {
        FieldResolver resolver = FieldResolver.of(fury, cls, true, false);
        return CodecUtils.loadOrGenCompatibleCodecClass(cls, fury, resolver, Generated.GeneratedSerializer.class);
    }

    public static <T> Class<? extends Serializer<T>> loadOrGenCompatibleCodecClass(Class<T> cls, Fury fury, FieldResolver fieldResolver, Class<?> parentSerializerClass) {
        Preconditions.checkNotNull(fury);
        CompatibleCodecBuilder codecBuilder = new CompatibleCodecBuilder(TypeToken.of(cls), fury, fieldResolver, parentSerializerClass);
        return CodecUtils.loadOrGenCodecClass(cls, fury, codecBuilder);
    }

    static <T> Class<? extends Serializer<T>> loadOrGenCodecClass(Class<T> beanClass, Fury fury, BaseObjectCodecBuilder codecBuilder) {
        CodeGenerator codeGenerator;
        CompileUnit compileUnit = new CompileUnit(CodeGenerator.getPackage(beanClass), codecBuilder.codecClassName(beanClass), codecBuilder::genCode);
        ClassLoader beanClassClassLoader = beanClass.getClassLoader() == null ? Thread.currentThread().getContextClassLoader() : beanClass.getClassLoader();
        try {
            beanClassClassLoader.loadClass(Fury.class.getName());
            codeGenerator = CodeGenerator.getSharedCodeGenerator(beanClassClassLoader);
        }
        catch (ClassNotFoundException e) {
            codeGenerator = CodeGenerator.getSharedCodeGenerator(beanClassClassLoader, fury.getClass().getClassLoader());
        }
        ClassLoader classLoader = codeGenerator.compile(Collections.singletonList(compileUnit), compileState -> compileState.lock.lock());
        String className = codecBuilder.codecQualifiedClassName(beanClass);
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Impossible because we just compiled class", e);
        }
    }
}

