/*
 * Decompiled with CFR 0.152.
 */
package io.fury.builder;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import io.fury.Fury;
import io.fury.builder.Generated;
import io.fury.builder.ObjectCodecBuilder;
import io.fury.builder.ObjectCodecOptimizer;
import io.fury.codegen.CodeGenerator;
import io.fury.codegen.Expression;
import io.fury.memory.MemoryBuffer;
import io.fury.serializer.CodegenSerializer;
import io.fury.serializer.MetaSharedSerializer;
import io.fury.serializer.ObjectSerializer;
import io.fury.serializer.Serializer;
import io.fury.serializer.Serializers;
import io.fury.type.ClassDef;
import io.fury.type.Descriptor;
import io.fury.type.DescriptorGrouper;
import io.fury.util.StringUtils;
import io.fury.util.Utils;
import java.util.Collection;

public class MetaSharedCodecBuilder
extends ObjectCodecBuilder {
    private final ClassDef classDef;

    public MetaSharedCodecBuilder(TypeToken<?> beanType, Fury fury, ClassDef classDef) {
        super(beanType, fury, Generated.GeneratedMetaSharedSerializer.class);
        Preconditions.checkArgument(!fury.getConfig().checkClassVersion(), "Class version check should be disabled when compatible mode is enabled.");
        this.classDef = classDef;
        Collection descriptors = this.visitFury(f -> MetaSharedSerializer.consolidateFields(f.getClassResolver(), this.beanClass, classDef));
        DescriptorGrouper grouper = DescriptorGrouper.createDescriptorGrouper(descriptors, true, fury.compressNumber());
        this.objectCodecOptimizer = new ObjectCodecOptimizer(this.beanClass, grouper, !fury.isBasicTypesRefIgnored(), this.ctx);
    }

    @Override
    protected String codecSuffix() {
        return "MetaShared" + this.classDef.getId();
    }

    @Override
    public String genCode() {
        this.ctx.setPackage(CodeGenerator.getPackage(this.beanClass));
        String className = this.codecClassName(this.beanClass);
        this.ctx.setClassName(className);
        this.ctx.extendsClasses(this.ctx.type(this.parentSerializerClass));
        this.ctx.reserveName("classType");
        this.ctx.reserveName("serializer");
        this.ctx.addField(this.ctx.type(Fury.class), "fury");
        String constructorCode = StringUtils.format("super(${fury}, ${cls});\nthis.${fury} = ${fury};\n${serializer} = ${builderClass}.setCodegenSerializer(${fury}, ${cls}, this);\n", "fury", "fury", "cls", "classType", "builderClass", MetaSharedCodecBuilder.class.getName(), "serializer", "serializer");
        this.ctx.clearExprState();
        Expression decodeExpr = this.buildDecodeExpression();
        String decodeCode = decodeExpr.genCode(this.ctx).code();
        decodeCode = this.ctx.optimizeMethodCode(decodeCode);
        this.ctx.overrideMethod("read", decodeCode, Object.class, MemoryBuffer.class, "buffer");
        this.registerJITNotifyCallback();
        this.ctx.addConstructor(constructorCode, Fury.class, "fury", Class.class, "classType");
        return this.ctx.genCode();
    }

    @Override
    protected void addCommonImports() {
        super.addCommonImports();
        this.ctx.addImport(Generated.GeneratedMetaSharedSerializer.class);
    }

    public static Serializer setCodegenSerializer(Fury fury, Class<?> cls, Generated.GeneratedMetaSharedSerializer s2) {
        Class serializerClass = fury.getJITContext().registerSerializerJITCallback(() -> ObjectSerializer.class, () -> CodegenSerializer.loadCodegenSerializer(fury, s2.getType()), c -> {
            s2.serializer = Serializers.newSerializer(fury, s2.getType(), c);
        });
        return Serializers.newSerializer(fury, cls, serializerClass);
    }

    @Override
    public Expression buildEncodeExpression() {
        throw new IllegalStateException("unreachable");
    }

    @Override
    protected Expression setFieldValue(Expression bean, Descriptor descriptor, Expression value) {
        if (descriptor.getField() == null) {
            return new Expression.StaticInvoke(Utils.class, "ignore", value);
        }
        return super.setFieldValue(bean, descriptor, value);
    }
}

