/*
 * Decompiled with CFR 0.152.
 */
package io.fury.builder;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import io.fury.Fury;
import io.fury.builder.BaseObjectCodecBuilder;
import io.fury.builder.Generated;
import io.fury.builder.ObjectCodecOptimizer;
import io.fury.codegen.Expression;
import io.fury.codegen.ExpressionUtils;
import io.fury.codegen.ExpressionVisitor;
import io.fury.serializer.ObjectSerializer;
import io.fury.type.Descriptor;
import io.fury.type.DescriptorGrouper;
import io.fury.type.TypeUtils;
import io.fury.util.Functions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ObjectCodecBuilder
extends BaseObjectCodecBuilder {
    public static final String BUFFER_NAME = "buffer";
    private final Expression.Literal classVersionHash;
    protected ObjectCodecOptimizer objectCodecOptimizer;

    public ObjectCodecBuilder(Class<?> beanClass, Fury fury) {
        super(TypeToken.of(beanClass), fury, Generated.GeneratedObjectSerializer.class);
        Collection<Descriptor> descriptors = fury.getClassResolver().getAllDescriptorsMap(beanClass, true).values();
        this.classVersionHash = new Expression.Literal(ObjectSerializer.computeVersionHash(descriptors), TypeUtils.PRIMITIVE_INT_TYPE);
        DescriptorGrouper grouper = DescriptorGrouper.createDescriptorGrouper(descriptors, false, fury.compressNumber());
        this.objectCodecOptimizer = new ObjectCodecOptimizer(beanClass, grouper, !fury.isBasicTypesRefIgnored(), this.ctx);
    }

    protected ObjectCodecBuilder(TypeToken<?> beanType, Fury fury, Class<?> superSerializerClass) {
        super(beanType, fury, superSerializerClass);
        this.classVersionHash = null;
    }

    @Override
    protected String codecSuffix() {
        return "";
    }

    @Override
    protected void addCommonImports() {
        super.addCommonImports();
        this.ctx.addImport(Generated.GeneratedObjectSerializer.class);
    }

    @Override
    protected boolean isFinal(Class<?> clz) {
        return this.visitFury(f -> f.getClassResolver().isFinal(clz));
    }

    @Override
    public Expression buildEncodeExpression() {
        Expression.Reference inputObject = new Expression.Reference("obj", TypeUtils.OBJECT_TYPE, false);
        Expression.Reference buffer = new Expression.Reference(BUFFER_NAME, bufferTypeToken, false);
        Expression.ListExpression expressions = new Expression.ListExpression(new Expression[0]);
        Expression bean = this.tryCastIfPublic((Expression)inputObject, this.beanType, this.ctx.newName(this.beanClass));
        expressions.add(bean);
        if (this.fury.checkClassVersion()) {
            expressions.add(new Expression.Invoke((Expression)buffer, "writeInt", this.classVersionHash));
        }
        expressions.addAll(this.serializePrimitives(bean, buffer, this.objectCodecOptimizer.primitiveGroups));
        int numGroups = this.getNumGroups(this.objectCodecOptimizer);
        for (List<Descriptor> group : Iterables.concat(this.objectCodecOptimizer.boxedWriteGroups, this.objectCodecOptimizer.finalWriteGroups, this.objectCodecOptimizer.otherWriteGroups)) {
            if (group.isEmpty()) continue;
            boolean inline = group.size() == 1 && numGroups < 10;
            expressions.add(this.serializeGroup(group, bean, buffer, inline));
        }
        for (Descriptor descriptor : this.objectCodecOptimizer.descriptorGrouper.getCollectionDescriptors()) {
            expressions.add(this.serializeGroup(Collections.singletonList(descriptor), bean, buffer, false));
        }
        for (Descriptor d : this.objectCodecOptimizer.descriptorGrouper.getMapDescriptors()) {
            expressions.add(this.serializeGroup(Collections.singletonList(d), bean, buffer, false));
        }
        return expressions;
    }

    private int getNumGroups(ObjectCodecOptimizer objectCodecOptimizer) {
        return objectCodecOptimizer.boxedWriteGroups.size() + objectCodecOptimizer.finalWriteGroups.size() + objectCodecOptimizer.otherWriteGroups.size() + objectCodecOptimizer.descriptorGrouper.getCollectionDescriptors().size() + objectCodecOptimizer.descriptorGrouper.getMapDescriptors().size();
    }

    private Expression serializeGroup(List<Descriptor> group, Expression bean, Expression buffer, boolean inline) {
        Functions.SerializableSupplier expressionSupplier = () -> {
            Expression.ListExpression groupExpressions = new Expression.ListExpression(new Expression[0]);
            for (Descriptor d : group) {
                Expression fieldValue = this.getFieldValue(bean, d);
                Expression fieldExpr = this.serializeFor(fieldValue, buffer, d.getTypeToken());
                groupExpressions.add(fieldExpr);
            }
            return groupExpressions;
        };
        if (inline) {
            return (Expression)expressionSupplier.get();
        }
        return this.objectCodecOptimizer.invokeGenerated(expressionSupplier, "writeFields");
    }

    private List<Expression> serializePrimitives(Expression bean, Expression buffer, List<List<Descriptor>> primitiveGroups) {
        int totalSize = this.getTotalSizeOfPrimitives(primitiveGroups);
        if (totalSize == 0) {
            return new ArrayList<Expression>();
        }
        if (this.fury.compressNumber()) {
            return this.serializePrimitivesCompressed(bean, buffer, primitiveGroups, totalSize);
        }
        return this.serializePrimitivesUnCompressed(bean, buffer, primitiveGroups, totalSize);
    }

    protected int getNumPrimitiveFields(List<List<Descriptor>> primitiveGroups) {
        return primitiveGroups.stream().mapToInt(List::size).sum();
    }

    private List<Expression> serializePrimitivesUnCompressed(Expression bean, Expression buffer, List<List<Descriptor>> primitiveGroups, int totalSize) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        int numPrimitiveFields = this.getNumPrimitiveFields(primitiveGroups);
        Expression.Literal totalSizeLiteral = new Expression.Literal(totalSize, TypeUtils.PRIMITIVE_INT_TYPE);
        expressions.add(new Expression.Invoke(buffer, "grow", totalSizeLiteral));
        Expression.Invoke base = new Expression.Invoke(buffer, "getHeapMemory", "base", TypeUtils.PRIMITIVE_BYTE_ARRAY_TYPE);
        Expression.Invoke writerAddr = new Expression.Invoke(buffer, "getUnsafeWriterAddress", "writerAddr", TypeUtils.PRIMITIVE_LONG_TYPE);
        expressions.add(base);
        expressions.add(writerAddr);
        int acc = 0;
        for (List<Descriptor> group : primitiveGroups) {
            Expression.ListExpression groupExpressions = new Expression.ListExpression(new Expression[0]);
            for (Descriptor descriptor : group) {
                Class<?> clz = descriptor.getRawType();
                Preconditions.checkArgument(TypeUtils.isPrimitive(clz));
                Expression fieldValue = this.getFieldValue(bean, descriptor);
                if (fieldValue instanceof Expression.Inlineable) {
                    ((Expression.Inlineable)fieldValue).inline();
                }
                if (clz == Byte.TYPE) {
                    groupExpressions.add(this.unsafePut(base, this.getWriterPos(writerAddr, acc), fieldValue));
                    ++acc;
                    continue;
                }
                if (clz == Boolean.TYPE) {
                    groupExpressions.add(this.unsafePutBoolean(base, this.getWriterPos(writerAddr, acc), fieldValue));
                    ++acc;
                    continue;
                }
                if (clz == Character.TYPE) {
                    groupExpressions.add(this.unsafePutChar(base, this.getWriterPos(writerAddr, acc), fieldValue));
                    acc += 2;
                    continue;
                }
                if (clz == Short.TYPE) {
                    groupExpressions.add(this.unsafePutShort(base, this.getWriterPos(writerAddr, acc), fieldValue));
                    acc += 2;
                    continue;
                }
                if (clz == Integer.TYPE) {
                    groupExpressions.add(this.unsafePutInt(base, this.getWriterPos(writerAddr, acc), fieldValue));
                    acc += 4;
                    continue;
                }
                if (clz == Long.TYPE) {
                    groupExpressions.add(this.unsafePutLong(base, this.getWriterPos(writerAddr, acc), fieldValue));
                    acc += 8;
                    continue;
                }
                if (clz == Float.TYPE) {
                    groupExpressions.add(this.unsafePutFloat(base, this.getWriterPos(writerAddr, acc), fieldValue));
                    acc += 4;
                    continue;
                }
                if (clz == Double.TYPE) {
                    groupExpressions.add(this.unsafePutDouble(base, this.getWriterPos(writerAddr, acc), fieldValue));
                    acc += 8;
                    continue;
                }
                throw new IllegalStateException("impossible");
            }
            if (numPrimitiveFields < 4) {
                expressions.add(groupExpressions);
                continue;
            }
            expressions.add(this.objectCodecOptimizer.invokeGenerated(ImmutableSet.of(bean, base, writerAddr), groupExpressions, "writeFields"));
        }
        Expression.Invoke increaseWriterIndex = new Expression.Invoke(buffer, "increaseWriterIndexUnsafe", new Expression.Literal(totalSizeLiteral, TypeUtils.PRIMITIVE_INT_TYPE));
        expressions.add(increaseWriterIndex);
        return expressions;
    }

    private List<Expression> serializePrimitivesCompressed(Expression bean, Expression buffer, List<List<Descriptor>> primitiveGroups, int totalSize) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        int numPrimitiveFields = this.getNumPrimitiveFields(primitiveGroups);
        int growSize = (int)((long)totalSize + primitiveGroups.stream().mapToLong(Collection::size).sum());
        expressions.add(new Expression.Invoke(buffer, "grow", Expression.Literal.ofInt(growSize)));
        Expression.Invoke base = new Expression.Invoke(buffer, "getHeapMemory", "base", TypeUtils.PRIMITIVE_BYTE_ARRAY_TYPE);
        expressions.add(base);
        for (List<Descriptor> group : primitiveGroups) {
            Expression.ListExpression groupExpressions = new Expression.ListExpression(new Expression[0]);
            Expression.Invoke writerAddr = new Expression.Invoke(buffer, "getUnsafeWriterAddress", "writerAddr", TypeUtils.PRIMITIVE_LONG_TYPE);
            int acc = 0;
            boolean compressStarted = false;
            for (Descriptor descriptor : group) {
                Class<?> clz = descriptor.getRawType();
                Preconditions.checkArgument(TypeUtils.isPrimitive(clz));
                Expression fieldValue = this.getFieldValue(bean, descriptor);
                if (fieldValue instanceof Expression.Inlineable) {
                    ((Expression.Inlineable)fieldValue).inline();
                }
                if (clz == Byte.TYPE) {
                    groupExpressions.add(this.unsafePut(base, this.getWriterPos(writerAddr, acc), fieldValue));
                    ++acc;
                    continue;
                }
                if (clz == Boolean.TYPE) {
                    groupExpressions.add(this.unsafePutBoolean(base, this.getWriterPos(writerAddr, acc), fieldValue));
                    ++acc;
                    continue;
                }
                if (clz == Character.TYPE) {
                    groupExpressions.add(this.unsafePutChar(base, this.getWriterPos(writerAddr, acc), fieldValue));
                    acc += 2;
                    continue;
                }
                if (clz == Short.TYPE) {
                    groupExpressions.add(this.unsafePutShort(base, this.getWriterPos(writerAddr, acc), fieldValue));
                    acc += 2;
                    continue;
                }
                if (clz == Float.TYPE) {
                    groupExpressions.add(this.unsafePutFloat(base, this.getWriterPos(writerAddr, acc), fieldValue));
                    acc += 4;
                    continue;
                }
                if (clz == Double.TYPE) {
                    groupExpressions.add(this.unsafePutDouble(base, this.getWriterPos(writerAddr, acc), fieldValue));
                    acc += 8;
                    continue;
                }
                if (clz == Integer.TYPE) {
                    if (!compressStarted) {
                        this.addIncWriterIndexExpr(groupExpressions, buffer, acc);
                        compressStarted = true;
                    }
                    groupExpressions.add(new Expression.Invoke(buffer, "unsafeWriteVarInt", fieldValue));
                    acc += 0;
                    continue;
                }
                if (clz == Long.TYPE) {
                    if (!compressStarted) {
                        this.addIncWriterIndexExpr(groupExpressions, buffer, acc);
                        compressStarted = true;
                    }
                    groupExpressions.add(new Expression.Invoke(buffer, "unsafeWriteVarLong", fieldValue));
                    continue;
                }
                throw new IllegalStateException("impossible");
            }
            if (!compressStarted) {
                this.addIncWriterIndexExpr(groupExpressions, buffer, acc);
            }
            if (numPrimitiveFields < 4) {
                expressions.add(groupExpressions);
                continue;
            }
            expressions.add(this.objectCodecOptimizer.invokeGenerated(ImmutableSet.of(bean, buffer, base), groupExpressions, "writeFields"));
        }
        return expressions;
    }

    private void addIncWriterIndexExpr(Expression.ListExpression expressions, Expression buffer, int diff) {
        if (diff != 0) {
            expressions.add(new Expression.Invoke(buffer, "increaseWriterIndexUnsafe", Expression.Literal.ofInt(diff)));
        }
    }

    private int getTotalSizeOfPrimitives(List<List<Descriptor>> primitiveGroups) {
        return primitiveGroups.stream().flatMap(Collection::stream).mapToInt(d -> TypeUtils.getSizeOfPrimitiveType(d.getRawType())).sum();
    }

    private Expression getWriterPos(Expression writerPos, long acc) {
        if (acc == 0L) {
            return writerPos;
        }
        return ExpressionUtils.add(writerPos, Expression.Literal.ofLong(acc));
    }

    @Override
    public Expression buildDecodeExpression() {
        Expression.Reference buffer = new Expression.Reference(BUFFER_NAME, bufferTypeToken, false);
        Expression.ListExpression expressions = new Expression.ListExpression(new Expression[0]);
        if (this.fury.checkClassVersion()) {
            expressions.add(this.checkClassVersion(buffer));
        }
        Expression bean = this.newBean();
        Expression.Invoke referenceObject = new Expression.Invoke((Expression)this.refResolverRef, "reference", TypeUtils.PRIMITIVE_VOID_TYPE, bean);
        expressions.add(bean);
        expressions.add(referenceObject);
        expressions.addAll(this.deserializePrimitives(bean, buffer, this.objectCodecOptimizer.primitiveGroups));
        int numGroups = this.getNumGroups(this.objectCodecOptimizer);
        for (List<Descriptor> group : Iterables.concat(this.objectCodecOptimizer.boxedReadGroups, this.objectCodecOptimizer.finalReadGroups, this.objectCodecOptimizer.otherReadGroups)) {
            if (group.isEmpty()) continue;
            boolean inline = group.size() == 1 && numGroups < 10;
            expressions.add(this.deserializeGroup(group, bean, buffer, inline));
        }
        for (Descriptor d : this.objectCodecOptimizer.descriptorGrouper.getCollectionDescriptors()) {
            expressions.add(this.deserializeGroup(Collections.singletonList(d), bean, buffer, false));
        }
        for (Descriptor d : this.objectCodecOptimizer.descriptorGrouper.getMapDescriptors()) {
            expressions.add(this.deserializeGroup(Collections.singletonList(d), bean, buffer, false));
        }
        expressions.add(new Expression.Return(bean));
        return expressions;
    }

    protected Expression deserializeGroup(List<Descriptor> group, Expression bean, Expression buffer, boolean inline) {
        Functions.SerializableSupplier exprSupplier = () -> {
            Expression.ListExpression groupExpressions = new Expression.ListExpression(new Expression[0]);
            for (Descriptor d : group) {
                ExpressionVisitor.ExprHolder exprHolder = ExpressionVisitor.ExprHolder.of("bean", bean);
                Expression action = this.deserializeFor(buffer, d.getTypeToken(), expr -> this.setFieldValue(exprHolder.get("bean"), d, this.tryInlineCast((Expression)expr, d.getTypeToken())));
                groupExpressions.add(action);
            }
            return groupExpressions;
        };
        if (inline) {
            return (Expression)exprSupplier.get();
        }
        return this.objectCodecOptimizer.invokeGenerated(exprSupplier, "readFields");
    }

    private Expression checkClassVersion(Expression buffer) {
        return new Expression.StaticInvoke(ObjectSerializer.class, "checkClassVersion", TypeUtils.PRIMITIVE_VOID_TYPE, false, this.furyRef, Expression.Invoke.inlineInvoke(buffer, "readInt", TypeUtils.PRIMITIVE_INT_TYPE, new Expression[0]), Objects.requireNonNull(this.classVersionHash));
    }

    private List<Expression> deserializePrimitives(Expression bean, Expression buffer, List<List<Descriptor>> primitiveGroups) {
        int totalSize = this.getTotalSizeOfPrimitives(primitiveGroups);
        if (totalSize == 0) {
            return new ArrayList<Expression>();
        }
        if (this.fury.compressNumber()) {
            return this.deserializeCompressedPrimitives(bean, buffer, primitiveGroups);
        }
        return this.deserializeUnCompressedPrimitives(bean, buffer, primitiveGroups, totalSize);
    }

    private List<Expression> deserializeUnCompressedPrimitives(Expression bean, Expression buffer, List<List<Descriptor>> primitiveGroups, int totalSize) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        int numPrimitiveFields = this.getNumPrimitiveFields(primitiveGroups);
        Expression.Literal totalSizeLiteral = Expression.Literal.ofInt(totalSize);
        Expression.Invoke heapBuffer = new Expression.Invoke(buffer, "getHeapMemory", "heapBuffer", TypeUtils.PRIMITIVE_BYTE_ARRAY_TYPE);
        Expression.Invoke readerAddr = new Expression.Invoke(buffer, "getUnsafeReaderAddress", "readerAddr", TypeUtils.PRIMITIVE_LONG_TYPE);
        expressions.add(heapBuffer);
        expressions.add(readerAddr);
        expressions.add(new Expression.Invoke(buffer, "checkReadableBytes", totalSizeLiteral));
        int acc = 0;
        for (List<Descriptor> group : primitiveGroups) {
            Expression.ListExpression groupExpressions = new Expression.ListExpression(new Expression[0]);
            for (Descriptor descriptor : group) {
                Expression fieldValue;
                TypeToken<?> type = descriptor.getTypeToken();
                Class<?> clz = TypeUtils.getRawType(type);
                Preconditions.checkArgument(TypeUtils.isPrimitive(clz));
                if (clz == Byte.TYPE) {
                    fieldValue = this.unsafeGet(heapBuffer, this.getReaderAddress(readerAddr, acc));
                    ++acc;
                } else if (clz == Boolean.TYPE) {
                    fieldValue = this.unsafeGetBoolean(heapBuffer, this.getReaderAddress(readerAddr, acc));
                    ++acc;
                } else if (clz == Character.TYPE) {
                    fieldValue = this.unsafeGetChar(heapBuffer, this.getReaderAddress(readerAddr, acc));
                    acc += 2;
                } else if (clz == Short.TYPE) {
                    fieldValue = this.unsafeGetShort(heapBuffer, this.getReaderAddress(readerAddr, acc));
                    acc += 2;
                } else if (clz == Integer.TYPE) {
                    fieldValue = this.unsafeGetInt(heapBuffer, this.getReaderAddress(readerAddr, acc));
                    acc += 4;
                } else if (clz == Long.TYPE) {
                    fieldValue = this.unsafeGetLong(heapBuffer, this.getReaderAddress(readerAddr, acc));
                    acc += 8;
                } else if (clz == Float.TYPE) {
                    fieldValue = this.unsafeGetFloat(heapBuffer, this.getReaderAddress(readerAddr, acc));
                    acc += 4;
                } else if (clz == Double.TYPE) {
                    fieldValue = this.unsafeGetDouble(heapBuffer, this.getReaderAddress(readerAddr, acc));
                    acc += 8;
                } else {
                    throw new IllegalStateException("impossible");
                }
                groupExpressions.add(this.setFieldValue(bean, descriptor, fieldValue));
            }
            if (numPrimitiveFields < 4) {
                expressions.add(groupExpressions);
                continue;
            }
            expressions.add(this.objectCodecOptimizer.invokeGenerated(ImmutableSet.of(bean, heapBuffer, readerAddr), groupExpressions, "readFields"));
        }
        Expression.Invoke increaseReaderIndex = new Expression.Invoke(buffer, "increaseReaderIndexUnsafe", new Expression.Literal(totalSizeLiteral, TypeUtils.PRIMITIVE_INT_TYPE));
        expressions.add(increaseReaderIndex);
        return expressions;
    }

    private List<Expression> deserializeCompressedPrimitives(Expression bean, Expression buffer, List<List<Descriptor>> primitiveGroups) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        int numPrimitiveFields = this.getNumPrimitiveFields(primitiveGroups);
        Expression.Invoke heapBuffer = new Expression.Invoke(buffer, "getHeapMemory", "heapBuffer", TypeUtils.PRIMITIVE_BYTE_ARRAY_TYPE);
        expressions.add(heapBuffer);
        for (List<Descriptor> group : primitiveGroups) {
            Expression.ListExpression groupExpressions = new Expression.ListExpression(new Expression[0]);
            Expression.Invoke readerAddr = new Expression.Invoke(buffer, "getUnsafeReaderAddress", "readerAddr", TypeUtils.PRIMITIVE_LONG_TYPE);
            Expression.ReplaceStub checkReadableBytesStub = new Expression.ReplaceStub();
            expressions.add(checkReadableBytesStub);
            int acc = 0;
            boolean compressStarted = false;
            for (Descriptor descriptor : group) {
                Expression fieldValue;
                TypeToken<?> type = descriptor.getTypeToken();
                Class<?> clz = TypeUtils.getRawType(type);
                Preconditions.checkArgument(TypeUtils.isPrimitive(clz));
                if (clz == Byte.TYPE) {
                    fieldValue = this.unsafeGet(heapBuffer, this.getReaderAddress(readerAddr, acc));
                    ++acc;
                } else if (clz == Boolean.TYPE) {
                    fieldValue = this.unsafeGetBoolean(heapBuffer, this.getReaderAddress(readerAddr, acc));
                    ++acc;
                } else if (clz == Character.TYPE) {
                    fieldValue = this.unsafeGetChar(heapBuffer, this.getReaderAddress(readerAddr, acc));
                    acc += 2;
                } else if (clz == Short.TYPE) {
                    fieldValue = this.unsafeGetShort(heapBuffer, this.getReaderAddress(readerAddr, acc));
                    acc += 2;
                } else if (clz == Float.TYPE) {
                    fieldValue = this.unsafeGetFloat(heapBuffer, this.getReaderAddress(readerAddr, acc));
                    acc += 4;
                } else if (clz == Double.TYPE) {
                    fieldValue = this.unsafeGetDouble(heapBuffer, this.getReaderAddress(readerAddr, acc));
                    acc += 8;
                } else if (clz == Integer.TYPE) {
                    if (!compressStarted) {
                        compressStarted = true;
                        this.addIncReaderIndexExpr(groupExpressions, buffer, acc);
                    }
                    fieldValue = new Expression.Invoke(buffer, "readVarInt", TypeUtils.PRIMITIVE_INT_TYPE);
                } else if (clz == Long.TYPE) {
                    if (!compressStarted) {
                        compressStarted = true;
                        this.addIncReaderIndexExpr(groupExpressions, buffer, acc);
                    }
                    fieldValue = new Expression.Invoke(buffer, "readVarLong", TypeUtils.PRIMITIVE_LONG_TYPE);
                } else {
                    throw new IllegalStateException("impossible");
                }
                groupExpressions.add(this.setFieldValue(bean, descriptor, fieldValue));
            }
            if (acc != 0) {
                checkReadableBytesStub.setTargetObject(new Expression.Invoke(buffer, "checkReadableBytes", Expression.Literal.ofInt(acc)));
            }
            if (!compressStarted) {
                this.addIncReaderIndexExpr(groupExpressions, buffer, acc);
            }
            if (numPrimitiveFields < 4) {
                expressions.add(groupExpressions);
                continue;
            }
            expressions.add(this.objectCodecOptimizer.invokeGenerated(ImmutableSet.of(bean, buffer, heapBuffer), groupExpressions, "readFields"));
        }
        return expressions;
    }

    private void addIncReaderIndexExpr(Expression.ListExpression expressions, Expression buffer, int diff) {
        if (diff != 0) {
            expressions.add(new Expression.Invoke(buffer, "increaseReaderIndexUnsafe", Expression.Literal.ofInt(diff)));
        }
    }

    private Expression getReaderAddress(Expression readerPos, long acc) {
        if (acc == 0L) {
            return readerPos;
        }
        return ExpressionUtils.add(readerPos, new Expression.Literal(acc, TypeUtils.PRIMITIVE_LONG_TYPE));
    }
}

