/*
 * Decompiled with CFR 0.152.
 */
package io.fury.resolver;

import io.fury.collection.LongMap;
import io.fury.collection.ObjectMap;
import io.fury.memory.MemoryBuffer;
import io.fury.resolver.EnumStringBytes;
import java.nio.charset.StandardCharsets;

public final class EnumStringResolver {
    public static final byte USE_STRING_VALUE = 0;
    public static final byte USE_STRING_ID = 1;
    private static final int initialCapacity = 8;
    private static final float furyMapLoadFactor = 0.25f;
    private final ObjectMap<EnumStringBytes, String> enumStringBytes2StringMap = new ObjectMap(8, 0.25f);
    private final LongMap<EnumStringBytes> hash2EnumStringBytesMap = new LongMap(8, 0.25f);
    private final ObjectMap<String, EnumStringBytes> enumString2BytesMap = new ObjectMap(8, 0.25f);
    private EnumStringBytes[] dynamicWrittenString = new EnumStringBytes[32];
    private EnumStringBytes[] dynamicReadStringIds = new EnumStringBytes[32];
    private short dynamicWriteStringId = 0;
    private short dynamicReadStringId = 0;

    EnumStringBytes getOrCreateEnumStringBytes(String str) {
        EnumStringBytes enumStringBytes = (EnumStringBytes)this.enumString2BytesMap.get(str);
        if (enumStringBytes == null) {
            enumStringBytes = new EnumStringBytes(str);
            this.enumString2BytesMap.put(str, enumStringBytes);
        }
        return enumStringBytes;
    }

    public void writeEnumString(MemoryBuffer buffer, String str) {
        this.writeEnumStringBytes(buffer, this.getOrCreateEnumStringBytes(str));
    }

    public String readEnumString(MemoryBuffer buffer) {
        EnumStringBytes byteString = this.readEnumStringBytes(buffer);
        String str = (String)this.enumStringBytes2StringMap.get(byteString);
        if (str == null) {
            str = new String(byteString.bytes, StandardCharsets.UTF_8);
            this.enumStringBytes2StringMap.put(byteString, str);
        }
        return str;
    }

    public void writeEnumStringBytes(MemoryBuffer buffer, EnumStringBytes byteString) {
        short id = byteString.dynamicWriteStringId;
        int writerIndex = buffer.writerIndex();
        if (id == -1) {
            short s2 = this.dynamicWriteStringId;
            this.dynamicWriteStringId = (short)(s2 + 1);
            byteString.dynamicWriteStringId = id = s2;
            EnumStringBytes[] dynamicWrittenEnumString = this.dynamicWrittenString;
            if (dynamicWrittenEnumString.length <= id) {
                EnumStringBytes[] tmp = new EnumStringBytes[id * 2];
                System.arraycopy(dynamicWrittenEnumString, 0, tmp, 0, dynamicWrittenEnumString.length);
                dynamicWrittenEnumString = tmp;
                this.dynamicWrittenString = tmp;
            }
            dynamicWrittenEnumString[id] = byteString;
            int bytesLen = byteString.bytes.length;
            buffer.increaseWriterIndex(11 + bytesLen);
            buffer.unsafePut(writerIndex, (byte)0);
            buffer.unsafePutLong(writerIndex + 1, byteString.hashCode);
            buffer.unsafePutShort(writerIndex + 9, (short)bytesLen);
            buffer.put(writerIndex + 11, byteString.bytes, 0, bytesLen);
        } else {
            buffer.increaseWriterIndex(3);
            buffer.unsafePut(writerIndex, (byte)1);
            buffer.unsafePutShort(writerIndex + 1, id);
        }
    }

    EnumStringBytes readEnumStringBytes(MemoryBuffer buffer) {
        if (buffer.readByte() == 0) {
            long hashCode = buffer.readLong();
            EnumStringBytes byteString = this.trySkipEnumStringBytes(buffer, hashCode);
            this.updateDynamicString(byteString);
            return byteString;
        }
        return this.dynamicReadStringIds[buffer.readShort()];
    }

    EnumStringBytes readEnumStringBytes(MemoryBuffer buffer, EnumStringBytes cache) {
        if (buffer.readByte() == 0) {
            long hashCode = buffer.readLong();
            if (cache.hashCode == hashCode) {
                buffer.increaseReaderIndex(2 + cache.bytes.length);
                this.updateDynamicString(cache);
                return cache;
            }
            EnumStringBytes byteString = this.trySkipEnumStringBytes(buffer, hashCode);
            this.updateDynamicString(byteString);
            return byteString;
        }
        return this.dynamicReadStringIds[buffer.readShort()];
    }

    private EnumStringBytes trySkipEnumStringBytes(MemoryBuffer buffer, long hashCode) {
        EnumStringBytes byteString = this.hash2EnumStringBytesMap.get(hashCode);
        if (byteString == null) {
            short strBytesLength = buffer.readShort();
            byte[] strBytes = buffer.readBytes(strBytesLength);
            byteString = new EnumStringBytes(strBytes, hashCode);
            this.hash2EnumStringBytesMap.put(hashCode, byteString);
        } else {
            buffer.increaseReaderIndex(2 + byteString.bytes.length);
        }
        return byteString;
    }

    private void updateDynamicString(EnumStringBytes byteString) {
        short s2 = this.dynamicReadStringId;
        this.dynamicReadStringId = (short)(s2 + 1);
        EnumStringBytes[] dynamicReadStringIds = this.dynamicReadStringIds;
        short currentDynamicReadId = s2;
        if (dynamicReadStringIds.length <= currentDynamicReadId) {
            EnumStringBytes[] tmp = new EnumStringBytes[currentDynamicReadId * 2];
            System.arraycopy(dynamicReadStringIds, 0, tmp, 0, dynamicReadStringIds.length);
            dynamicReadStringIds = tmp;
            this.dynamicReadStringIds = tmp;
        }
        dynamicReadStringIds[currentDynamicReadId] = byteString;
    }

    public void reset() {
        this.resetRead();
        this.resetWrite();
    }

    public void resetRead() {
        int dynamicReadId = this.dynamicReadStringId;
        if (dynamicReadId != 0) {
            for (int i = 0; i < dynamicReadId; ++i) {
                this.dynamicReadStringIds[i] = null;
            }
            this.dynamicReadStringId = 0;
        }
    }

    public void resetWrite() {
        int dynamicWriteStringId = this.dynamicWriteStringId;
        if (dynamicWriteStringId != 0) {
            for (int i = 0; i < dynamicWriteStringId; ++i) {
                this.dynamicWrittenString[i].dynamicWriteStringId = (short)-1;
                this.dynamicWrittenString[i] = null;
            }
            this.dynamicWriteStringId = 0;
        }
    }
}

