/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import com.google.common.base.Preconditions;
import io.fury.Fury;
import io.fury.collection.Tuple2;
import io.fury.collection.Tuple3;
import io.fury.memory.MemoryBuffer;
import io.fury.resolver.ClassInfoCache;
import io.fury.resolver.ClassResolver;
import io.fury.resolver.RefResolver;
import io.fury.serializer.ObjectSerializer;
import io.fury.serializer.Serializer;
import io.fury.type.ClassDef;
import io.fury.type.Descriptor;
import io.fury.type.DescriptorGrouper;
import io.fury.type.Generics;
import io.fury.util.ReflectionUtils;
import io.fury.util.UnsafeFieldAccessor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;

public class MetaSharedSerializer<T>
extends Serializer<T> {
    private final ObjectSerializer.FinalTypeField[] finalFields;
    private final boolean[] isFinal;
    private final ObjectSerializer.GenericTypeField[] otherFields;
    private final ObjectSerializer.GenericTypeField[] containerFields;
    private final Constructor<T> constructor;
    private Serializer<T> serializer;
    private final ClassInfoCache classInfoCache;

    public MetaSharedSerializer(Fury fury, Class<T> type, ClassDef classDef) {
        super(fury, type);
        Preconditions.checkArgument(!fury.getConfig().checkClassVersion(), "Class version check should be disabled when compatible mode is enabled.");
        Preconditions.checkArgument(fury.getConfig().shareMetaContext(), "Meta share must be enabled.");
        Collection<Descriptor> descriptors = MetaSharedSerializer.consolidateFields(fury.getClassResolver(), type, classDef);
        DescriptorGrouper descriptorGrouper = DescriptorGrouper.createDescriptorGrouper(descriptors, true, fury.compressNumber());
        this.constructor = ReflectionUtils.getExecutableNoArgConstructor(type);
        Tuple3<Tuple2<ObjectSerializer.FinalTypeField[], boolean[]>, ObjectSerializer.GenericTypeField[], ObjectSerializer.GenericTypeField[]> infos = ObjectSerializer.buildFieldInfos(fury, descriptorGrouper);
        this.finalFields = (ObjectSerializer.FinalTypeField[])((Tuple2)infos.f0).f0;
        this.isFinal = (boolean[])((Tuple2)infos.f0).f1;
        this.otherFields = (ObjectSerializer.GenericTypeField[])infos.f1;
        this.containerFields = (ObjectSerializer.GenericTypeField[])infos.f2;
        this.classInfoCache = fury.getClassResolver().nilClassInfoCache();
    }

    @Override
    public void write(MemoryBuffer buffer, T value) {
        if (this.serializer == null) {
            this.serializer = this.fury.getClassResolver().createSerializerSafe(this.type, () -> new ObjectSerializer(this.fury, this.type));
        }
        this.serializer.write(buffer, value);
    }

    @Override
    public T read(MemoryBuffer buffer) {
        Object fieldValue;
        T obj = ObjectSerializer.newBean(this.constructor, this.type);
        Fury fury = this.fury;
        RefResolver refResolver = fury.getRefResolver();
        ClassResolver classResolver = fury.getClassResolver();
        refResolver.reference(obj);
        ObjectSerializer.FinalTypeField[] finalFields = this.finalFields;
        for (int i = 0; i < finalFields.length; ++i) {
            ObjectSerializer.FinalTypeField fieldInfo = finalFields[i];
            boolean isFinal = this.isFinal[i];
            UnsafeFieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            if (fieldAccessor != null) {
                short classId = fieldInfo.classId;
                if (!ObjectSerializer.readPrimitiveFieldValueFailed(fury, buffer, obj, fieldAccessor, classId) || !ObjectSerializer.readBasicObjectFieldValueFailed(fury, buffer, obj, fieldAccessor, classId)) continue;
                assert (fieldInfo.classInfo != null);
                fieldValue = ObjectSerializer.readFinalObjectFieldValue(fury, refResolver, classResolver, fieldInfo, isFinal, buffer);
                fieldAccessor.putObject(obj, fieldValue);
                continue;
            }
            if (!MetaSharedSerializer.skipPrimitiveFieldValueFailed(fury, fieldInfo.classId, buffer)) continue;
            if (fieldInfo.classInfo == null) {
                fury.readRef(buffer, this.classInfoCache);
                continue;
            }
            ObjectSerializer.readFinalObjectFieldValue(fury, refResolver, classResolver, fieldInfo, isFinal, buffer);
        }
        for (ObjectSerializer.GenericTypeField fieldInfo : this.otherFields) {
            Object fieldValue2 = ObjectSerializer.readOtherFieldValue(fury, fieldInfo, buffer);
            UnsafeFieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            if (fieldAccessor == null) continue;
            fieldAccessor.putObject(obj, fieldValue2);
        }
        Generics generics = fury.getGenerics();
        for (ObjectSerializer.GenericTypeField fieldInfo : this.containerFields) {
            fieldValue = ObjectSerializer.readContainerFieldValue(fury, generics, fieldInfo, buffer);
            UnsafeFieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            if (fieldAccessor == null) continue;
            fieldAccessor.putObject(obj, fieldValue);
        }
        return obj;
    }

    static boolean skipPrimitiveFieldValueFailed(Fury fury, short classId, MemoryBuffer buffer) {
        switch (classId) {
            case 5: {
                buffer.increaseReaderIndex(1);
                return false;
            }
            case 6: {
                buffer.increaseReaderIndex(1);
                return false;
            }
            case 7: {
                buffer.increaseReaderIndex(2);
                return false;
            }
            case 8: {
                buffer.increaseReaderIndex(2);
                return false;
            }
            case 9: {
                if (fury.compressNumber()) {
                    buffer.readVarInt();
                } else {
                    buffer.increaseReaderIndex(4);
                }
                return false;
            }
            case 10: {
                buffer.increaseReaderIndex(4);
                return false;
            }
            case 11: {
                if (fury.compressNumber()) {
                    buffer.readVarLong();
                } else {
                    buffer.increaseReaderIndex(8);
                }
                return false;
            }
            case 12: {
                buffer.increaseReaderIndex(8);
                return false;
            }
        }
        return true;
    }

    public static Collection<Descriptor> consolidateFields(ClassResolver classResolver, Class<?> cls, ClassDef classDef) {
        SortedMap<Field, Descriptor> allDescriptorsMap = classResolver.getAllDescriptorsMap(cls, true);
        HashMap<String, Descriptor> descriptorsMap = new HashMap<String, Descriptor>();
        for (Map.Entry<Field, Descriptor> e : allDescriptorsMap.entrySet()) {
            if (descriptorsMap.put(e.getKey().getDeclaringClass().getName() + "." + e.getKey().getName(), e.getValue()) == null) continue;
            throw new IllegalStateException("Duplicate key");
        }
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>(classDef.getFieldsInfo().size());
        for (ClassDef.FieldInfo fieldInfo : classDef.getFieldsInfo()) {
            Descriptor descriptor = (Descriptor)descriptorsMap.get(fieldInfo.getDefinedClass() + "." + fieldInfo.getFieldName());
            if (descriptor != null) {
                descriptors.add(descriptor);
                continue;
            }
            descriptors.add(fieldInfo.toDescriptor(classResolver));
        }
        return descriptors;
    }
}

