/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import com.google.common.base.Preconditions;
import io.fury.Fury;
import io.fury.builder.CodecUtils;
import io.fury.builder.Generated;
import io.fury.collection.ObjectArray;
import io.fury.collection.ObjectIntMap;
import io.fury.memory.MemoryBuffer;
import io.fury.resolver.ClassInfo;
import io.fury.resolver.ClassResolver;
import io.fury.resolver.FieldResolver;
import io.fury.serializer.CodegenSerializer;
import io.fury.serializer.CompatibleSerializer;
import io.fury.serializer.CompatibleSerializerBase;
import io.fury.serializer.JavaSerializer;
import io.fury.serializer.Serializer;
import io.fury.serializer.Serializers;
import io.fury.util.LoggerFactory;
import io.fury.util.Platform;
import io.fury.util.ReflectionUtils;
import io.fury.util.Utils;
import io.fury.util.unsafe._JDKAccess;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;

public class ObjectStreamSerializer
extends Serializer {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectStreamSerializer.class);
    private final Constructor constructor;
    private final ClassResolver classResolver;
    private final SlotsInfo[] slotsInfos;

    public ObjectStreamSerializer(Fury fury, Class<?> type) {
        super(fury, type);
        Class<?> end;
        Constructor constructor;
        if (!Serializable.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(String.format("Class %s should implement %s.", type, Serializable.class));
        }
        LOG.warn("{} customized jdk serialization, which is inefficient. Please replace it with a {} or implements {}", type, Serializer.class.getCanonicalName(), Externalizable.class.getCanonicalName());
        fury.getClassResolver().setSerializerIfAbsent(type, this);
        try {
            constructor = type.getConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
        }
        catch (Exception e) {
            constructor = (Constructor)ReflectionUtils.getObjectFieldValue(ObjectStreamClass.lookup(type), "cons");
        }
        this.classResolver = fury.getClassResolver();
        this.constructor = constructor;
        ArrayList<SlotsInfo> slotsInfoList = new ArrayList<SlotsInfo>();
        for (end = type; end != null && Serializable.class.isAssignableFrom(end); end = end.getSuperclass()) {
        }
        while (type != end) {
            slotsInfoList.add(new SlotsInfo(fury, type));
            type = type.getSuperclass();
        }
        Collections.reverse(slotsInfoList);
        this.slotsInfos = slotsInfoList.toArray(new SlotsInfo[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(MemoryBuffer buffer, Object value) {
        buffer.writeShort((short)this.slotsInfos.length);
        try {
            for (SlotsInfo slotsInfo : this.slotsInfos) {
                this.classResolver.writeClass(buffer, slotsInfo.classInfo);
                Method writeObjectMethod = slotsInfo.writeObjectMethod;
                if (writeObjectMethod == null) {
                    slotsInfo.slotsSerializer.write(buffer, value);
                    continue;
                }
                FuryObjectOutputStream objectOutputStream = slotsInfo.objectOutputStream;
                Object oldObject = objectOutputStream.targetObject;
                MemoryBuffer oldBuffer = objectOutputStream.buffer;
                FuryObjectOutputStream.PutFieldImpl oldPutField = objectOutputStream.curPut;
                boolean fieldsWritten = objectOutputStream.fieldsWritten;
                try {
                    objectOutputStream.targetObject = value;
                    objectOutputStream.buffer = buffer;
                    objectOutputStream.curPut = null;
                    objectOutputStream.fieldsWritten = false;
                    if (slotsInfo.writeObjectFunc != null) {
                        slotsInfo.writeObjectFunc.accept(value, objectOutputStream);
                        continue;
                    }
                    writeObjectMethod.invoke(value, objectOutputStream);
                }
                finally {
                    objectOutputStream.targetObject = oldObject;
                    objectOutputStream.buffer = oldBuffer;
                    objectOutputStream.curPut = oldPutField;
                    objectOutputStream.fieldsWritten = fieldsWritten;
                }
            }
        }
        catch (Exception e) {
            ObjectStreamSerializer.throwSerializationException(this.type, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(MemoryBuffer buffer) {
        Object obj = null;
        if (this.constructor != null) {
            try {
                obj = this.constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                Platform.throwException(e);
            }
        } else {
            obj = Platform.newInstance(this.type);
        }
        this.fury.getRefResolver().reference(obj);
        int numClasses = buffer.readShort();
        int slotIndex = 0;
        try {
            TreeMap callbacks = new TreeMap(Collections.reverseOrder());
            for (int i = 0; i < numClasses; ++i) {
                Class<?> currentClass = this.classResolver.readClassInternal(buffer);
                SlotsInfo slotsInfo = this.slotsInfos[slotIndex++];
                while (currentClass != slotsInfo.cls) {
                    Method readObjectNoData = slotsInfo.readObjectNoData;
                    if (readObjectNoData != null) {
                        if (slotsInfo.readObjectNoDataFunc != null) {
                            slotsInfo.readObjectNoDataFunc.accept(obj);
                        } else {
                            readObjectNoData.invoke(obj, new Object[0]);
                        }
                    }
                    slotsInfo = this.slotsInfos[slotIndex++];
                }
                Method readObjectMethod = slotsInfo.readObjectMethod;
                if (readObjectMethod == null) {
                    slotsInfo.slotsSerializer.readAndSetFields(buffer, obj);
                    continue;
                }
                FuryObjectInputStream objectInputStream = slotsInfo.objectInputStream;
                MemoryBuffer oldBuffer = objectInputStream.buffer;
                Object oldObject = objectInputStream.targetObject;
                FuryObjectInputStream.GetFieldImpl oldGetField = objectInputStream.getField;
                FuryObjectInputStream.GetFieldImpl getField = (FuryObjectInputStream.GetFieldImpl)slotsInfo.getFieldPool.popOrNull();
                if (getField == null) {
                    getField = new FuryObjectInputStream.GetFieldImpl(slotsInfo);
                }
                boolean fieldsRead = objectInputStream.fieldsRead;
                try {
                    objectInputStream.fieldsRead = false;
                    objectInputStream.buffer = buffer;
                    objectInputStream.targetObject = obj;
                    objectInputStream.getField = getField;
                    objectInputStream.callbacks = callbacks;
                    if (slotsInfo.readObjectFunc != null) {
                        slotsInfo.readObjectFunc.accept(obj, objectInputStream);
                        continue;
                    }
                    readObjectMethod.invoke(obj, objectInputStream);
                    continue;
                }
                finally {
                    objectInputStream.fieldsRead = fieldsRead;
                    objectInputStream.buffer = oldBuffer;
                    objectInputStream.targetObject = oldObject;
                    objectInputStream.getField = oldGetField;
                    slotsInfo.getFieldPool.add(getField);
                    objectInputStream.callbacks = null;
                    Arrays.fill(getField.vals, FuryObjectInputStream.NO_VALUE_STUB);
                }
            }
            for (ObjectInputValidation validation : callbacks.values()) {
                validation.validateObject();
            }
        }
        catch (InvalidObjectException | IllegalAccessException | InvocationTargetException e) {
            ObjectStreamSerializer.throwSerializationException(this.type, e);
        }
        return obj;
    }

    private static void throwUnsupportedEncodingException(Class<?> cls) throws UnsupportedEncodingException {
        throw new UnsupportedEncodingException(String.format("Use %s instead by `fury.registerSerializer(%s, new JavaSerializer(fury, %s))` or implement a custom %s.", JavaSerializer.class, cls, cls, Serializer.class));
    }

    private static void throwSerializationException(Class<?> type, Exception e) {
        throw new RuntimeException(String.format("Serialize object of type %s failed, Try to use %s instead by `fury.registerSerializer(%s, new JavaSerializer(fury, %s))` or implement a custom %s.", type, JavaSerializer.class, type, type, Serializer.class), e);
    }

    private static class SlotsInfo {
        private final Class<?> cls;
        private final ClassInfo classInfo;
        private final Method writeObjectMethod;
        private final Method readObjectMethod;
        private final Method readObjectNoData;
        private final BiConsumer writeObjectFunc;
        private final BiConsumer readObjectFunc;
        private final Consumer readObjectNoDataFunc;
        private CompatibleSerializerBase slotsSerializer;
        private final ObjectIntMap<String> fieldIndexMap;
        private final FieldResolver putFieldsResolver;
        private final CompatibleSerializer compatibleStreamSerializer;
        private final FuryObjectOutputStream objectOutputStream;
        private final FuryObjectInputStream objectInputStream;
        private final ObjectArray getFieldPool;

        public SlotsInfo(Fury fury, Class<?> type) {
            this.cls = type;
            this.classInfo = fury.getClassResolver().newClassInfo(type, null, (short)0);
            ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(type);
            this.writeObjectMethod = (Method)ReflectionUtils.getObjectFieldValue(objectStreamClass, "writeObjectMethod");
            this.readObjectMethod = (Method)ReflectionUtils.getObjectFieldValue(objectStreamClass, "readObjectMethod");
            this.readObjectNoData = (Method)ReflectionUtils.getObjectFieldValue(objectStreamClass, "readObjectNoData");
            MethodHandles.Lookup lookup = _JDKAccess._trustedLookup(type);
            BiConsumer writeObjectFunc = null;
            BiConsumer readObjectFunc = null;
            Consumer readObjectNoDataFunc = null;
            try {
                if (this.writeObjectMethod != null) {
                    writeObjectFunc = _JDKAccess.makeJDKBiConsumer(lookup, lookup.unreflect(this.writeObjectMethod));
                }
                if (this.readObjectMethod != null) {
                    readObjectFunc = _JDKAccess.makeJDKBiConsumer(lookup, lookup.unreflect(this.readObjectMethod));
                }
                if (this.readObjectNoData != null) {
                    readObjectNoDataFunc = _JDKAccess.makeJDKConsumer(lookup, lookup.unreflect(this.readObjectNoData));
                }
            }
            catch (Exception e) {
                Utils.ignore(e);
            }
            this.writeObjectFunc = writeObjectFunc;
            this.readObjectFunc = readObjectFunc;
            this.readObjectNoDataFunc = readObjectNoDataFunc;
            Class sc = CompatibleSerializer.class;
            FieldResolver fieldResolver = FieldResolver.of(fury, type, false, true);
            if (fury.getConfig().isCodeGenEnabled() && CodegenSerializer.supportCodegenForJavaSerialization(this.cls)) {
                sc = fury.getJITContext().registerSerializerJITCallback(() -> CompatibleSerializer.class, () -> CodecUtils.loadOrGenCompatibleCodecClass(this.cls, fury, fieldResolver, Generated.GeneratedCompatibleSerializer.class), c -> {
                    this.slotsSerializer = (CompatibleSerializerBase)Serializers.newSerializer(fury, type, c);
                });
            }
            this.slotsSerializer = sc == CompatibleSerializer.class ? new CompatibleSerializer(fury, type, fieldResolver) : (CompatibleSerializerBase)Serializers.newSerializer(fury, type, sc);
            this.fieldIndexMap = new ObjectIntMap(4, 0.4f);
            ArrayList<FieldResolver.ClassField> allFields = new ArrayList<FieldResolver.ClassField>();
            for (ObjectStreamField serialField : objectStreamClass.getFields()) {
                allFields.add(new FieldResolver.ClassField(serialField.getName(), serialField.getType(), this.cls));
            }
            if (this.writeObjectMethod != null || this.readObjectMethod != null) {
                this.putFieldsResolver = new FieldResolver(fury, this.cls, true, allFields, new HashSet<String>());
                AtomicInteger idx = new AtomicInteger(0);
                for (FieldResolver.FieldInfo fieldInfo : this.putFieldsResolver.getAllFieldsList()) {
                    this.fieldIndexMap.put(fieldInfo.getName(), idx.getAndIncrement());
                }
                this.compatibleStreamSerializer = new CompatibleSerializer(fury, this.cls, this.putFieldsResolver);
            } else {
                this.putFieldsResolver = null;
                this.compatibleStreamSerializer = null;
            }
            if (this.writeObjectMethod != null) {
                try {
                    this.objectOutputStream = new FuryObjectOutputStream(this);
                }
                catch (IOException e) {
                    Platform.throwException(e);
                    throw new IllegalStateException("unreachable");
                }
            } else {
                this.objectOutputStream = null;
            }
            if (this.readObjectMethod != null) {
                try {
                    this.objectInputStream = new FuryObjectInputStream(this);
                }
                catch (IOException e) {
                    Platform.throwException(e);
                    throw new IllegalStateException("unreachable");
                }
            } else {
                this.objectInputStream = null;
            }
            this.getFieldPool = new ObjectArray();
        }

        public String toString() {
            return "SlotsInfo{cls=" + this.cls + '}';
        }
    }

    private static class FuryObjectOutputStream
    extends ObjectOutputStream {
        private final Fury fury;
        private final SlotsInfo slotsInfo;
        private MemoryBuffer buffer;
        private Object targetObject;
        private boolean fieldsWritten;
        private final ObjectArray putFieldsCache = new ObjectArray();
        private PutFieldImpl curPut;

        protected FuryObjectOutputStream(SlotsInfo slotsInfo) throws IOException {
            this.slotsInfo = slotsInfo;
            this.fury = ((SlotsInfo)slotsInfo).slotsSerializer.fury;
        }

        @Override
        protected final void writeObjectOverride(Object obj) throws IOException {
            this.fury.writeRef(this.buffer, obj);
        }

        @Override
        public void writeUnshared(Object obj) throws IOException {
            this.fury.writeNonRef(this.buffer, obj);
        }

        @Override
        public ObjectOutputStream.PutField putFields() throws IOException {
            if (this.curPut == null) {
                Object o = this.putFieldsCache.popOrNull();
                if (o == null) {
                    o = new PutFieldImpl();
                }
                this.curPut = (PutFieldImpl)o;
            }
            return this.curPut;
        }

        @Override
        public void writeFields() throws IOException {
            if (this.fieldsWritten) {
                throw new NotActiveException("not in writeObject invocation or fields already written");
            }
            PutFieldImpl curPut = this.curPut;
            if (curPut == null) {
                throw new NotActiveException("no current PutField object");
            }
            this.slotsInfo.compatibleStreamSerializer.writeFieldsValues(this.buffer, curPut.vals);
            Arrays.fill(curPut.vals, null);
            this.putFieldsCache.add(curPut);
            this.curPut = null;
            this.fieldsWritten = true;
        }

        @Override
        public void defaultWriteObject() throws IOException, NotActiveException {
            if (this.fieldsWritten) {
                throw new NotActiveException("not in writeObject invocation or fields already written");
            }
            this.slotsInfo.slotsSerializer.write(this.buffer, this.targetObject);
            this.fieldsWritten = true;
        }

        @Override
        public void reset() throws IOException {
            Class cls = this.slotsInfo.slotsSerializer.getType();
            ObjectStreamSerializer.throwUnsupportedEncodingException(cls);
        }

        @Override
        protected void annotateClass(Class<?> cl) throws IOException {
            throw new IllegalStateException();
        }

        @Override
        protected void annotateProxyClass(Class<?> cl) throws IOException {
            throw new IllegalStateException();
        }

        @Override
        protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
            throw new UnsupportedEncodingException();
        }

        @Override
        protected Object replaceObject(Object obj) throws IOException {
            throw new UnsupportedEncodingException();
        }

        @Override
        protected boolean enableReplaceObject(boolean enable) throws SecurityException {
            throw new IllegalStateException();
        }

        @Override
        protected void writeStreamHeader() throws IOException {
            throw new IllegalStateException();
        }

        @Override
        public void write(int b) throws IOException {
            this.buffer.writeByte((byte)b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.buffer.writeBytes(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.buffer.writeBytes(b, off, len);
        }

        @Override
        public void writeBoolean(boolean v) throws IOException {
            this.buffer.writeBoolean(v);
        }

        @Override
        public void writeByte(int v) throws IOException {
            this.buffer.writeByte((byte)v);
        }

        @Override
        public void writeShort(int v) throws IOException {
            this.buffer.writeShort((short)v);
        }

        @Override
        public void writeChar(int v) throws IOException {
            this.buffer.writeChar((char)v);
        }

        @Override
        public void writeInt(int v) throws IOException {
            this.buffer.writeInt(v);
        }

        @Override
        public void writeLong(long v) throws IOException {
            this.buffer.writeLong(v);
        }

        @Override
        public void writeFloat(float v) throws IOException {
            this.buffer.writeFloat(v);
        }

        @Override
        public void writeDouble(double v) throws IOException {
            this.buffer.writeDouble(v);
        }

        @Override
        public void writeBytes(String s2) throws IOException {
            Preconditions.checkNotNull(s2);
            int len = s2.length();
            for (int i = 0; i < len; ++i) {
                this.buffer.writeByte((byte)s2.charAt(i));
            }
        }

        @Override
        public void writeChars(String s2) throws IOException {
            Preconditions.checkNotNull(s2);
            this.fury.writeJavaString(this.buffer, s2);
        }

        @Override
        public void writeUTF(String s2) throws IOException {
            Preconditions.checkNotNull(s2);
            this.fury.writeJavaString(this.buffer, s2);
        }

        @Override
        public void useProtocolVersion(int version) throws IOException {
            Class cls = this.slotsInfo.cls;
            ObjectStreamSerializer.throwUnsupportedEncodingException(cls);
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        protected void drain() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        private class PutFieldImpl
        extends ObjectOutputStream.PutField {
            private final Object[] vals;

            PutFieldImpl() {
                this.vals = new Object[FuryObjectOutputStream.this.slotsInfo.putFieldsResolver.getNumFields()];
            }

            private void putValue(String name, Object val2) {
                int index = FuryObjectOutputStream.this.slotsInfo.fieldIndexMap.get(name, -1);
                if (index == -1) {
                    throw new IllegalArgumentException(String.format("Field name %s not exist in class %s", name, ((SlotsInfo)((FuryObjectOutputStream)FuryObjectOutputStream.this).slotsInfo).slotsSerializer.type));
                }
                this.vals[index] = val2;
            }

            @Override
            public void put(String name, boolean val2) {
                this.putValue(name, val2);
            }

            @Override
            public void put(String name, byte val2) {
                this.putValue(name, val2);
            }

            @Override
            public void put(String name, char val2) {
                this.putValue(name, Character.valueOf(val2));
            }

            @Override
            public void put(String name, short val2) {
                this.putValue(name, val2);
            }

            @Override
            public void put(String name, int val2) {
                this.putValue(name, val2);
            }

            @Override
            public void put(String name, long val2) {
                this.putValue(name, val2);
            }

            @Override
            public void put(String name, float val2) {
                this.putValue(name, Float.valueOf(val2));
            }

            @Override
            public void put(String name, double val2) {
                this.putValue(name, val2);
            }

            @Override
            public void put(String name, Object val2) {
                this.putValue(name, val2);
            }

            @Override
            @Deprecated
            public void write(ObjectOutput out) throws IOException {
                Class cls = ((SlotsInfo)((FuryObjectOutputStream)FuryObjectOutputStream.this).slotsInfo).slotsSerializer.type;
                ObjectStreamSerializer.throwUnsupportedEncodingException(cls);
            }
        }
    }

    private static class FuryObjectInputStream
    extends ObjectInputStream {
        private final Fury fury;
        private final SlotsInfo slotsInfo;
        private MemoryBuffer buffer;
        private Object targetObject;
        private GetFieldImpl getField;
        private boolean fieldsRead;
        private TreeMap<Integer, ObjectInputValidation> callbacks;
        private static final Object NO_VALUE_STUB = new Object();

        protected FuryObjectInputStream(SlotsInfo slotsInfo) throws IOException {
            this.fury = ((SlotsInfo)slotsInfo).slotsSerializer.fury;
            this.slotsInfo = slotsInfo;
        }

        @Override
        protected Object readObjectOverride() {
            return this.fury.readRef(this.buffer);
        }

        @Override
        public Object readUnshared() {
            return this.fury.readNonRef(this.buffer);
        }

        @Override
        public ObjectInputStream.GetField readFields() throws IOException {
            if (this.fieldsRead) {
                throw new NotActiveException("not in readObject invocation or fields already read");
            }
            this.slotsInfo.compatibleStreamSerializer.readFields(this.buffer, this.getField.vals);
            this.fieldsRead = true;
            return this.getField;
        }

        @Override
        public void defaultReadObject() throws IOException, ClassNotFoundException {
            if (this.fieldsRead) {
                throw new NotActiveException("not in readObject invocation or fields already read");
            }
            this.slotsInfo.slotsSerializer.readAndSetFields(this.buffer, this.targetObject);
            this.fieldsRead = true;
        }

        @Override
        public void registerValidation(ObjectInputValidation obj, int prio) throws NotActiveException, InvalidObjectException {
            if (obj == null) {
                throw new InvalidObjectException("null callback");
            }
            this.callbacks.put(prio, obj);
        }

        @Override
        public int read() throws IOException {
            return this.buffer.readByte();
        }

        @Override
        public int read(byte[] buf, int offset, int length) throws IOException {
            if (buf == null) {
                throw new NullPointerException();
            }
            int endOffset = offset + length;
            if (offset < 0 || length < 0 || endOffset > buf.length || endOffset < 0) {
                throw new IndexOutOfBoundsException();
            }
            int remaining = this.buffer.remaining();
            if (remaining < length) {
                this.buffer.readBytes(buf, offset, remaining);
                return remaining;
            }
            this.buffer.readBytes(buf, offset, length);
            return length;
        }

        @Override
        public int available() throws IOException {
            return this.buffer.remaining();
        }

        @Override
        public boolean readBoolean() throws IOException {
            return this.buffer.readBoolean();
        }

        @Override
        public byte readByte() throws IOException {
            return this.buffer.readByte();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            byte b = this.buffer.readByte();
            return b & 0xFF;
        }

        @Override
        public short readShort() throws IOException {
            return this.buffer.readShort();
        }

        @Override
        public int readUnsignedShort() throws IOException {
            short b = this.buffer.readShort();
            return b & 0xFFFF;
        }

        @Override
        public char readChar() throws IOException {
            return this.buffer.readChar();
        }

        @Override
        public int readInt() throws IOException {
            return this.buffer.readInt();
        }

        @Override
        public long readLong() throws IOException {
            return this.buffer.readLong();
        }

        @Override
        public float readFloat() throws IOException {
            return this.buffer.readFloat();
        }

        @Override
        public double readDouble() throws IOException {
            return this.buffer.readDouble();
        }

        @Override
        public void readFully(byte[] data) throws IOException {
            this.buffer.readBytes(data);
        }

        @Override
        public void readFully(byte[] data, int offset, int size) throws IOException {
            this.buffer.readBytes(data, offset, size);
        }

        @Override
        public int skipBytes(int len) throws IOException {
            this.buffer.increaseReaderIndex(len);
            return len;
        }

        @Override
        public String readLine() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String readUTF() throws IOException {
            return this.fury.readJavaString(this.buffer);
        }

        @Override
        public void close() throws IOException {
        }

        private static class GetFieldImpl
        extends ObjectInputStream.GetField {
            private final SlotsInfo slotsInfo;
            private final Object[] vals;

            GetFieldImpl(SlotsInfo slotsInfo) {
                this.slotsInfo = slotsInfo;
                this.vals = new Object[slotsInfo.putFieldsResolver.getNumFields()];
                Arrays.fill(this.vals, NO_VALUE_STUB);
            }

            @Override
            public ObjectStreamClass getObjectStreamClass() {
                return ObjectStreamClass.lookup(this.slotsInfo.cls);
            }

            @Override
            public boolean defaulted(String name) throws IOException {
                int index = this.slotsInfo.fieldIndexMap.get(name, -1);
                this.checkFieldExists(name, index);
                return this.vals[index] == NO_VALUE_STUB;
            }

            @Override
            public boolean get(String name, boolean val2) throws IOException {
                Object fieldValue = this.getFieldValue(name);
                if (fieldValue == NO_VALUE_STUB) {
                    return val2;
                }
                return (Boolean)fieldValue;
            }

            @Override
            public byte get(String name, byte val2) throws IOException {
                Object fieldValue = this.getFieldValue(name);
                if (fieldValue == NO_VALUE_STUB) {
                    return val2;
                }
                return (Byte)fieldValue;
            }

            @Override
            public char get(String name, char val2) throws IOException {
                Object fieldValue = this.getFieldValue(name);
                if (fieldValue == NO_VALUE_STUB) {
                    return val2;
                }
                return ((Character)fieldValue).charValue();
            }

            @Override
            public short get(String name, short val2) throws IOException {
                Object fieldValue = this.getFieldValue(name);
                if (fieldValue == NO_VALUE_STUB) {
                    return val2;
                }
                return (Short)fieldValue;
            }

            @Override
            public int get(String name, int val2) throws IOException {
                Object fieldValue = this.getFieldValue(name);
                if (fieldValue == NO_VALUE_STUB) {
                    return val2;
                }
                return (Integer)fieldValue;
            }

            @Override
            public long get(String name, long val2) throws IOException {
                Object fieldValue = this.getFieldValue(name);
                if (fieldValue == NO_VALUE_STUB) {
                    return val2;
                }
                return (Long)fieldValue;
            }

            @Override
            public float get(String name, float val2) throws IOException {
                Object fieldValue = this.getFieldValue(name);
                if (fieldValue == NO_VALUE_STUB) {
                    return val2;
                }
                return ((Float)fieldValue).floatValue();
            }

            @Override
            public double get(String name, double val2) throws IOException {
                Object fieldValue = this.getFieldValue(name);
                if (fieldValue == NO_VALUE_STUB) {
                    return val2;
                }
                return (Double)fieldValue;
            }

            @Override
            public Object get(String name, Object val2) throws IOException {
                Object fieldValue = this.getFieldValue(name);
                if (fieldValue == NO_VALUE_STUB) {
                    return val2;
                }
                return fieldValue;
            }

            private Object getFieldValue(String name) {
                int index = this.slotsInfo.fieldIndexMap.get(name, -1);
                this.checkFieldExists(name, index);
                return this.vals[index];
            }

            private void checkFieldExists(String name, int index) {
                if (index == -1) {
                    throw new IllegalArgumentException(String.format("Field name %s not exist in class %s", name, ((SlotsInfo)this.slotsInfo).slotsSerializer.type));
                }
            }
        }
    }
}

