/*
 * Decompiled with CFR 0.152.
 */
package io.fury.util;

import com.google.common.base.Preconditions;
import io.fury.Fury;
import io.fury.annotation.Internal;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Function;

@Internal
public final class LoaderBinding {
    private final Function<ClassLoader, Fury> furyFactory;
    private final HashMap<ClassLoader, Fury> furyMap = new HashMap();
    private final WeakHashMap<ClassLoader, SoftReference<Fury>> furySoftMap = new WeakHashMap();
    private Consumer<Fury> bindingCallback = f -> {};
    private ClassLoader loader;
    private Fury fury;

    public LoaderBinding(Function<ClassLoader, Fury> furyFactory) {
        this.furyFactory = furyFactory;
    }

    public Fury get() {
        return this.fury;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.setClassLoader(classLoader, StagingType.SOFT_STAGING);
    }

    public void setClassLoader(ClassLoader classLoader, StagingType stagingType) {
        if (this.loader != classLoader) {
            this.loader = classLoader;
            switch (stagingType) {
                case NO_STAGING: {
                    this.fury = this.furyFactory.apply(classLoader);
                    this.bindingCallback.accept(this.fury);
                    break;
                }
                case SOFT_STAGING: {
                    Fury fury;
                    SoftReference<Fury> furySoftReference = this.furySoftMap.get(classLoader);
                    Fury fury2 = fury = furySoftReference == null ? null : furySoftReference.get();
                    if (fury != null) break;
                    fury = this.furyFactory.apply(classLoader);
                    this.bindingCallback.accept(fury);
                    this.furySoftMap.put(classLoader, new SoftReference<Fury>(fury));
                    this.fury = fury;
                    break;
                }
                case STRONG_STAGING: {
                    Fury fury = this.furyMap.get(classLoader);
                    if (fury != null) break;
                    fury = this.furyFactory.apply(classLoader);
                    this.bindingCallback.accept(fury);
                    this.furyMap.put(classLoader, fury);
                    this.fury = fury;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    public void clearClassLoader(ClassLoader classLoader) {
        this.furyMap.remove(classLoader);
        SoftReference<Fury> softReference = this.furySoftMap.remove(classLoader);
        if (softReference != null) {
            softReference.clear();
        }
        if (this.loader == classLoader) {
            this.loader = null;
            this.fury = null;
        }
    }

    public void register(Class<?> clz) {
        this.furyMap.values().forEach(fury -> fury.register(clz));
        this.bindingCallback = this.bindingCallback.andThen(fury -> fury.register(clz));
    }

    public void register(Class<?> clz, int id) {
        Preconditions.checkArgument(id < Short.MAX_VALUE);
        this.furyMap.values().forEach(fury -> fury.register(clz, (short)id));
        this.bindingCallback = this.bindingCallback.andThen(fury -> fury.register(clz, (short)id));
    }

    public static enum StagingType {
        NO_STAGING,
        SOFT_STAGING,
        STRONG_STAGING;

    }
}

