/*
 * Decompiled with CFR 0.152.
 */
package io.fury.util;

import com.google.common.io.BaseEncoding;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class StringUtils {
    public static String encodeHexString(byte[] data) {
        return BaseEncoding.base16().lowerCase().encode(data);
    }

    public static String format(String str, Object ... args) {
        StringBuilder builder = new StringBuilder(str);
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("args length must be multiple of 2, but get " + args.length);
        }
        HashMap<String, String> values = new HashMap<String, String>();
        for (int i = 0; i < args.length; i += 2) {
            values.put(args[i].toString(), args[i + 1].toString());
        }
        for (Map.Entry entry : values.entrySet()) {
            int start;
            String pattern = "${" + (String)entry.getKey() + "}";
            String value = (String)entry.getValue();
            while ((start = builder.indexOf(pattern)) != -1) {
                builder.replace(start, start + pattern.length(), value);
            }
        }
        return builder.toString();
    }

    public static String stripBlankLines(String str) {
        String[] split2;
        StringBuilder builder = new StringBuilder();
        for (String s2 : split2 = str.split("\n")) {
            if (s2.trim().isEmpty()) continue;
            builder.append(s2).append('\n');
        }
        if (builder.charAt(builder.length() - 1) == '\n') {
            return builder.toString();
        }
        return builder.substring(0, builder.length() - 1);
    }

    public static String random(int size) {
        return StringUtils.random(size, new Random());
    }

    public static String random(int size, int rand) {
        return StringUtils.random(size, new Random(rand));
    }

    public static String random(int size, Random random) {
        char[] chars = new char[size];
        int start = 32;
        int end = 123;
        int gap = end - start;
        for (int i = 0; i < size; ++i) {
            chars[i] = (char)(start + random.nextInt(gap));
        }
        return new String(chars);
    }

    public static String capitalize(String str) {
        int codepoint;
        int newCodePoint;
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        int firstCodepoint = str.codePointAt(0);
        if (firstCodepoint == (newCodePoint = Character.toTitleCase(firstCodepoint))) {
            return str;
        }
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        newCodePoints[outOffset++] = newCodePoint;
        for (int inOffset = Character.charCount(firstCodepoint); inOffset < strLen; inOffset += Character.charCount(codepoint)) {
            codepoint = str.codePointAt(inOffset);
            newCodePoints[outOffset++] = codepoint;
        }
        return new String(newCodePoints, 0, outOffset);
    }

    public static String uncapitalize(String str) {
        int codepoint;
        int newCodePoint;
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        int firstCodepoint = str.codePointAt(0);
        if (firstCodepoint == (newCodePoint = Character.toLowerCase(firstCodepoint))) {
            return str;
        }
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        newCodePoints[outOffset++] = newCodePoint;
        for (int inOffset = Character.charCount(firstCodepoint); inOffset < strLen; inOffset += Character.charCount(codepoint)) {
            codepoint = str.codePointAt(inOffset);
            newCodePoints[outOffset++] = codepoint;
        }
        return new String(newCodePoints, 0, outOffset);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }
}

