/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.net.netty.client;

import cn.fyupeng.codec.CommonDecoder;
import cn.fyupeng.codec.CommonEncoder;
import cn.fyupeng.exception.ConnectFailedException;
import cn.fyupeng.exception.RpcException;
import cn.fyupeng.net.netty.client.NettyClientHandler;
import cn.fyupeng.net.netty.client.RequestParser;
import cn.fyupeng.serializer.CommonSerializer;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyChannelProvider {
    private static final Logger log = LoggerFactory.getLogger(NettyChannelProvider.class);
    private static EventLoopGroup group;
    private static Bootstrap bootstrap;
    private static Map<String, Channel> channels;

    public static Channel get(InetSocketAddress address, final CommonSerializer serializer) throws RpcException {
        Channel channel;
        String key = address.toString() + serializer.getCode();
        if (channels.containsKey(key)) {
            channel = channels.get(key);
            if (channel != null && channel.isActive()) {
                return channel;
            }
            channels.remove(key);
        }
        bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{new DelimiterBasedFrameDecoder(1024, Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.UTF_8))}).addLast(new ChannelHandler[]{new CommonDecoder()}).addLast(new ChannelHandler[]{new CommonEncoder(serializer, "\r\n")}).addLast(new ChannelHandler[]{new RequestParser(serializer)}).addLast(new ChannelHandler[]{new NettyClientHandler()});
            }
        });
        channel = null;
        try {
            channel = NettyChannelProvider.connect(bootstrap, address);
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("error occurred while customer connecting server: {}", (Object)e.getMessage());
            throw new ConnectFailedException("error occurred while customer connecting server Exception");
        }
        log.debug("get channel: key [{}] - channel [{}]", (Object)key, (Object)channel);
        channels.put(key, channel);
        return channel;
    }

    private static Channel connect(Bootstrap bootstrap, final InetSocketAddress address) throws ExecutionException, InterruptedException {
        final CompletableFuture completableFuture = new CompletableFuture();
        log.debug("try to connect to target address [{}:{}]", (Object)address.getHostName(), (Object)address.getPort());
        ChannelFuture channelFuture = bootstrap.connect((SocketAddress)address);
        channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                log.debug("connect operationComplete: future [{}]", (Object)future);
                log.debug("connect operationComplete: future.isSuccess [{}]", (Object)future.isSuccess());
                if (!future.isSuccess()) {
                    throw new IllegalStateException();
                }
                log.debug("customer operationComplete to server [{}] successfully", (Object)address);
                completableFuture.complete(future.channel());
            }
        });
        return (Channel)completableFuture.get();
    }

    private static Bootstrap initBootstrap() {
        group = new NioEventLoopGroup();
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(group)).channel(NioSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true);
        return bootstrap;
    }

    public static void shutdownAll() {
        try {
            log.info("clear all channels between NettyClient to NettyServer now...");
            channels.clear();
            log.info("All channels between NettyClient to NettyServer clear successfully");
            log.info("close client EventLoopGroup now ...");
            group.shutdownGracefully().sync();
            log.info("close Netty Client Boss EventLoopGroup [{}] [{}]", group.getClass(), (Object)group.isTerminated());
        }
        catch (InterruptedException e) {
            log.error("close thread was interrupted: ", (Throwable)e);
        }
        try {
            group.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error("failed to close Netty Server Boss EventLoopGroup: ", (Throwable)e);
            group.shutdownNow();
        }
        log.info("Netty Client EventLoopGroup closed successfully");
    }

    static {
        bootstrap = NettyChannelProvider.initBootstrap();
        channels = new ConcurrentHashMap<String, Channel>();
    }
}

