/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.handler;

import cn.fyupeng.exception.RpcException;
import cn.fyupeng.protocol.RpcRequest;
import cn.fyupeng.provider.DefaultServiceProvider;
import cn.fyupeng.provider.ServiceProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdkRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(JdkRequestHandler.class);
    private static final ServiceProvider serviceProvider = new DefaultServiceProvider();

    public Object handler(RpcRequest rpcRequest) {
        long begin = System.currentTimeMillis();
        Object result = null;
        try {
            Object service = serviceProvider.getServiceProvider(rpcRequest.getInterfaceName());
            result = this.invokeTargetMethod(rpcRequest, service);
            log.info("Service: {} completed the method [{}] call", (Object)rpcRequest.getInterfaceName(), (Object)rpcRequest.getMethodName());
            long end = System.currentTimeMillis();
            log.info("==> Task execution takes {} ms", (Object)(end - begin));
        }
        catch (RpcException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Error occurred while invoking remote method: ", e);
            throw new RuntimeException("Error occurred while invoking remote method: " + e.getMessage());
        }
        return result;
    }

    private Object invokeTargetMethod(RpcRequest rpcRequest, Object service) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        log.info("Proxy target Service {}", service);
        log.info("Service: {} is invoking method [{}], paramTypes [{}] ,parameters [{}]", rpcRequest.getInterfaceName(), rpcRequest.getMethodName(), rpcRequest.getParamTypes(), rpcRequest.getParameters());
        Class[] paramTypes = (Class[])Arrays.stream(rpcRequest.getParamTypes()).map(className -> {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                log.error("Class parse failed:", e);
                throw new RuntimeException(e);
            }
        }).toArray(Class[]::new);
        Method method = service.getClass().getMethod(rpcRequest.getMethodName(), paramTypes);
        return method.invoke(service, rpcRequest.getParameters());
    }
}

