/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.loadbalancer;

import cn.fyupeng.exception.RpcException;
import cn.fyupeng.exception.ServiceNotFoundException;
import cn.fyupeng.loadbalancer.LoadBalancer;
import java.util.List;
import java.util.Random;

public class RandomLoadBalancer
implements LoadBalancer {
    @Override
    public <T> T selectService(List<T> services) throws RpcException {
        if (services.size() == 0) {
            throw new ServiceNotFoundException("service instances size is zero, can't provide service! please start server first!");
        }
        return services.get(new Random().nextInt(services.size()));
    }

    @Override
    public String selectNode(String[] nodes) throws RpcException {
        if (nodes.length == 0) {
            throw new ServiceNotFoundException("service instances size is zero, can't provide service! please start server first!");
        }
        return nodes[new Random().nextInt(nodes.length)];
    }
}

