/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.net.netty.client;

import cn.fyupeng.factory.SingleFactory;
import cn.fyupeng.net.netty.client.UnprocessedResults;
import cn.fyupeng.protocol.RpcResponse;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClientHandler
extends SimpleChannelInboundHandler<RpcResponse> {
    private static final Logger log = LoggerFactory.getLogger(NettyClientHandler.class);
    private static final UnprocessedResults<RpcResponse> unprocessedRequests = SingleFactory.getInstance(UnprocessedResults.class);

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, RpcResponse msg) throws Exception {
        try {
            log.info(String.format("customer has received response package {requestId: %s, message: %s, statusCode: %s , checkCode: %s]}", msg.getRequestId(), msg.getMessage(), msg.getStatusCode(), msg.getCheckCode()));
            unprocessedRequests.complete(msg.getRequestId(), msg);
        }
        finally {
            ReferenceCountUtil.release(msg);
        }
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        log.warn("trigger hi-lo channel buffer\uff0cnow channel status:[active {}, writable: {}]", (Object)ctx.channel().isActive(), (Object)ctx.channel().isWritable());
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error("error occurred while invoking, error information:", cause);
        ctx.close();
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        super.userEventTriggered(ctx, evt);
    }
}

