/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpUtils {
    private static final Logger log = LoggerFactory.getLogger(IpUtils.class);

    public static boolean valid(String ip) {
        if (ip.equals("localhost")) {
            return true;
        }
        String z = ip.replace(".", "");
        int x = ip.length() - z.length();
        int t = ip.indexOf("..");
        if (t < 0) {
            boolean y = z.matches("[0-9]+");
            if (!(y && Character.isDigit(ip.charAt(0)) && Character.isDigit(ip.charAt(ip.length() - 1)))) {
                return false;
            }
            if (x == 3) {
                int b = ip.indexOf(46);
                String c = ip.substring(0, ip.indexOf(46));
                int i = Integer.parseInt(c);
                String d = ip.substring(b + 1);
                int e = d.indexOf(46);
                String f = d.substring(0, e);
                int j = Integer.parseInt(f);
                String g2 = d.substring(e + 1);
                int h2 = g2.indexOf(46);
                String l = g2.substring(0, h2);
                int k = Integer.parseInt(l);
                String m3 = g2.substring(h2 + 1);
                int n = Integer.parseInt(m3);
                return i >= 0 && i <= 255 && j >= 0 && j <= 255 && k >= 0 && k <= 255 && n >= 0 && n <= 255;
            }
            return false;
        }
        return false;
    }

    public static String getPubIpAddr() {
        String ip = "";
        String chinaz = "https://ip.chinaz.com";
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpGet request = new HttpGet(chinaz);
            request.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36");
            try (CloseableHttpResponse response = httpClient.execute(request);){
                HttpEntity entity = response.getEntity();
                String content = EntityUtils.toString(entity);
                Pattern p = Pattern.compile("\"\u8bf7\u8f93\u5165\u4f60\u60f3\u67e5\u8be2\u7684IP\u6216\u8005\u57df\u540d\" value=\"(.*?)\"\n");
                Matcher m3 = p.matcher(content);
                if (m3.find()) {
                    String ipstr;
                    ip = ipstr = m3.group(1);
                }
            }
            catch (MalformedURLException e) {
                log.warn("get public ip error, try get from [http://checkip.amazonaws.com]");
                throw new RuntimeException("get public ip error, try get from [http://checkip.amazonaws.com]");
            }
        }
        catch (IOException e) {
            log.warn("get public ip error, try get from [http://checkip.amazonaws.com]");
            throw new RuntimeException("get public ip error, try get from [http://checkip.amazonaws.com]");
        }
        return ip;
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < 10; ++i) {
            String pubIpAddr = IpUtils.getPubIpAddr();
            System.out.println(pubIpAddr);
        }
    }
}

