/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.img;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class ColorUtil {
    private static final int RGB_COLOR_BOUND = 256;

    public static String toHex(Color color) {
        return ColorUtil.toHex(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static String toHex(int r, int g2, int b) {
        if (r < 0 || r > 255 || g2 < 0 || g2 > 255 || b < 0 || b > 255) {
            throw new IllegalArgumentException("RGB must be 0~255!");
        }
        return String.format("#%02X%02X%02X", r, g2, b);
    }

    public static Color getColor(String colorName) {
        if (StrUtil.isBlank(colorName)) {
            return null;
        }
        if ("BLACK".equals(colorName = colorName.toUpperCase())) {
            return Color.BLACK;
        }
        if ("WHITE".equals(colorName)) {
            return Color.WHITE;
        }
        if ("LIGHTGRAY".equals(colorName) || "LIGHT_GRAY".equals(colorName)) {
            return Color.LIGHT_GRAY;
        }
        if ("GRAY".equals(colorName)) {
            return Color.GRAY;
        }
        if ("DARKGRAY".equals(colorName) || "DARK_GRAY".equals(colorName)) {
            return Color.DARK_GRAY;
        }
        if ("RED".equals(colorName)) {
            return Color.RED;
        }
        if ("PINK".equals(colorName)) {
            return Color.PINK;
        }
        if ("ORANGE".equals(colorName)) {
            return Color.ORANGE;
        }
        if ("YELLOW".equals(colorName)) {
            return Color.YELLOW;
        }
        if ("GREEN".equals(colorName)) {
            return Color.GREEN;
        }
        if ("MAGENTA".equals(colorName)) {
            return Color.MAGENTA;
        }
        if ("CYAN".equals(colorName)) {
            return Color.CYAN;
        }
        if ("BLUE".equals(colorName)) {
            return Color.BLUE;
        }
        if ("DARKGOLD".equals(colorName)) {
            return ColorUtil.hexToColor("#9e7e67");
        }
        if ("LIGHTGOLD".equals(colorName)) {
            return ColorUtil.hexToColor("#ac9c85");
        }
        if (StrUtil.startWith((CharSequence)colorName, '#')) {
            return ColorUtil.hexToColor(colorName);
        }
        if (StrUtil.startWith((CharSequence)colorName, '$')) {
            return ColorUtil.hexToColor("#" + colorName.substring(1));
        }
        List<String> rgb = StrUtil.split((CharSequence)colorName, ',');
        if (3 == rgb.size()) {
            Integer b;
            Integer g2;
            Integer r = Convert.toInt(rgb.get(0));
            if (!ArrayUtil.hasNull(r, g2 = Convert.toInt(rgb.get(1)), b = Convert.toInt(rgb.get(2)))) {
                return new Color(r, g2, b);
            }
        } else {
            return null;
        }
        return null;
    }

    public static Color getColor(int rgb) {
        return new Color(rgb);
    }

    public static Color hexToColor(String hex) {
        return ColorUtil.getColor(Integer.parseInt(StrUtil.removePrefix(hex, "#"), 16));
    }

    public static Color add(Color color1, Color color2) {
        double r1 = color1.getRed();
        double g1 = color1.getGreen();
        double b1 = color1.getBlue();
        double a1 = color1.getAlpha();
        double r2 = color2.getRed();
        double g2 = color2.getGreen();
        double b2 = color2.getBlue();
        double a2 = color2.getAlpha();
        int r = (int)((r1 * a1 / 255.0 + r2 * a2 / 255.0) / (a1 / 255.0 + a2 / 255.0));
        int g3 = (int)((g1 * a1 / 255.0 + g2 * a2 / 255.0) / (a1 / 255.0 + a2 / 255.0));
        int b = (int)((b1 * a1 / 255.0 + b2 * a2 / 255.0) / (a1 / 255.0 + a2 / 255.0));
        return new Color(r, g3, b);
    }

    public static Color randomColor() {
        return ColorUtil.randomColor(null);
    }

    public static Color randomColor(Random random) {
        if (null == random) {
            random = RandomUtil.getRandom();
        }
        return new Color(random.nextInt(256), random.nextInt(256), random.nextInt(256));
    }

    public static String getMainColor(BufferedImage image, int[] ... rgbFilters) {
        HashMap<String, Long> countMap = new HashMap<String, Long>();
        int width = image.getWidth();
        int height = image.getHeight();
        int minx = image.getMinX();
        int miny = image.getMinY();
        for (int i = minx; i < width; ++i) {
            for (int j = miny; j < height; ++j) {
                int b;
                int g2;
                int pixel = image.getRGB(i, j);
                int r = (pixel & 0xFF0000) >> 16;
                if (ColorUtil.matchFilters(r, g2 = (pixel & 0xFF00) >> 8, b = pixel & 0xFF, rgbFilters)) continue;
                countMap.merge(r + "-" + g2 + "-" + b, 1L, Long::sum);
            }
        }
        String maxColor = null;
        long maxCount = 0L;
        for (Map.Entry entry : countMap.entrySet()) {
            String key = (String)entry.getKey();
            Long count = (Long)entry.getValue();
            if (count <= maxCount) continue;
            maxColor = key;
            maxCount = count;
        }
        String[] splitRgbStr = StrUtil.splitToArray(maxColor, '-');
        String rHex = Integer.toHexString(Integer.parseInt(splitRgbStr[0]));
        String gHex = Integer.toHexString(Integer.parseInt(splitRgbStr[1]));
        String bHex = Integer.toHexString(Integer.parseInt(splitRgbStr[2]));
        rHex = rHex.length() == 1 ? "0" + rHex : rHex;
        gHex = gHex.length() == 1 ? "0" + gHex : gHex;
        bHex = bHex.length() == 1 ? "0" + bHex : bHex;
        return "#" + rHex + gHex + bHex;
    }

    private static boolean matchFilters(int r, int g2, int b, int[] ... rgbFilters) {
        if (rgbFilters != null && rgbFilters.length > 0) {
            for (int[] rgbFilter : rgbFilters) {
                if (r != rgbFilter[0] || g2 != rgbFilter[1] || b != rgbFilter[2]) continue;
                return true;
            }
        }
        return false;
    }
}

