/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json.xml;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.EscapeUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONObject;

public class JSONXMLSerializer {
    public static String toXml(Object object) throws JSONException {
        return JSONXMLSerializer.toXml(object, null);
    }

    public static String toXml(Object object, String tagName) throws JSONException {
        return JSONXMLSerializer.toXml(object, tagName, "content");
    }

    public static String toXml(Object object, String tagName, String ... contentKeys) throws JSONException {
        if (null == object) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (object instanceof JSONObject) {
            JSONXMLSerializer.appendTag(sb, tagName, false);
            ((JSONObject)object).forEach((key, value) -> {
                if (ArrayUtil.isArray(value)) {
                    value = new JSONArray(value);
                }
                if (ArrayUtil.contains(contentKeys, key)) {
                    if (value instanceof JSONArray) {
                        int i = 0;
                        for (Object val2 : (JSONArray)value) {
                            if (i > 0) {
                                sb.append('\n');
                            }
                            sb.append(EscapeUtil.escapeXml(val2.toString()));
                            ++i;
                        }
                    } else {
                        sb.append(EscapeUtil.escapeXml(value.toString()));
                    }
                } else if (StrUtil.isEmptyIfStr(value)) {
                    sb.append(JSONXMLSerializer.wrapWithTag(null, key));
                } else if (value instanceof JSONArray) {
                    for (Object val3 : (JSONArray)value) {
                        if (val3 instanceof JSONArray) {
                            sb.append(JSONXMLSerializer.wrapWithTag(JSONXMLSerializer.toXml(val3, null, contentKeys), key));
                            continue;
                        }
                        sb.append(JSONXMLSerializer.toXml(val3, key, contentKeys));
                    }
                } else {
                    sb.append(JSONXMLSerializer.toXml(value, key, contentKeys));
                }
            });
            JSONXMLSerializer.appendTag(sb, tagName, true);
            return sb.toString();
        }
        if (ArrayUtil.isArray(object)) {
            object = new JSONArray(object);
        }
        if (object instanceof JSONArray) {
            for (Object val2 : (JSONArray)object) {
                sb.append(JSONXMLSerializer.toXml(val2, tagName == null ? "array" : tagName, contentKeys));
            }
            return sb.toString();
        }
        return JSONXMLSerializer.wrapWithTag(EscapeUtil.escapeXml(object.toString()), tagName);
    }

    private static void appendTag(StringBuilder sb, String tagName, boolean isEndTag) {
        if (StrUtil.isNotBlank(tagName)) {
            sb.append('<');
            if (isEndTag) {
                sb.append('/');
            }
            sb.append(tagName).append('>');
        }
    }

    private static String wrapWithTag(String content, String tagName) {
        if (StrUtil.isBlank(tagName)) {
            return StrUtil.wrap(content, "\"");
        }
        if (StrUtil.isEmpty(content)) {
            return "<" + tagName + "/>";
        }
        return "<" + tagName + ">" + content + "</" + tagName + ">";
    }
}

