/*
 * Decompiled with CFR 0.152.
 */
package io.fury;

import com.google.common.base.Preconditions;
import io.fury.Fury;
import io.fury.Language;
import io.fury.serializer.CompatibleMode;
import io.fury.serializer.Serializer;
import io.fury.util.MurmurHash3;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Config
implements Serializable {
    private final Language language;
    private final boolean trackingRef;
    private final boolean basicTypesRefIgnored;
    private final boolean stringRefIgnored;
    private final boolean timeRefIgnored;
    private final boolean codeGenEnabled;
    private final boolean checkClassVersion;
    private final CompatibleMode compatibleMode;
    private final boolean checkJdkClassSerializable;
    private final Class<? extends Serializer> defaultJDKStreamSerializerType;
    private final boolean compressString;
    private final boolean compressNumber;
    private final boolean requireClassRegistration;
    private final boolean registerGuavaTypes;
    private final boolean shareMetaContext;
    private final boolean asyncCompilationEnabled;
    private final boolean deserializeUnexistedClass;
    private transient int configHash;

    Config(Fury.FuryBuilder builder) {
        this.language = builder.language;
        this.trackingRef = builder.trackingRef;
        this.basicTypesRefIgnored = !this.trackingRef || builder.basicTypesRefIgnored;
        this.stringRefIgnored = !this.trackingRef || builder.stringRefIgnored;
        this.timeRefIgnored = !this.trackingRef || builder.timeRefIgnored;
        this.compressString = builder.compressString;
        this.compressNumber = builder.compressNumber;
        this.requireClassRegistration = builder.requireClassRegistration;
        this.registerGuavaTypes = builder.registerGuavaTypes;
        this.codeGenEnabled = builder.codeGenEnabled;
        this.checkClassVersion = builder.checkClassVersion;
        this.compatibleMode = builder.compatibleMode;
        this.checkJdkClassSerializable = builder.checkJdkClassSerializable;
        this.defaultJDKStreamSerializerType = builder.defaultJDKStreamSerializerType;
        this.shareMetaContext = builder.shareMetaContext;
        this.deserializeUnexistedClass = builder.deserializeUnexistedClass;
        if (this.deserializeUnexistedClass) {
            Preconditions.checkArgument(this.shareMetaContext || this.compatibleMode == CompatibleMode.COMPATIBLE);
        }
        this.asyncCompilationEnabled = builder.asyncCompilationEnabled;
    }

    public Language getLanguage() {
        return this.language;
    }

    public boolean trackingRef() {
        return this.trackingRef;
    }

    public boolean isBasicTypesRefIgnored() {
        return this.basicTypesRefIgnored;
    }

    public boolean isStringRefIgnored() {
        return this.stringRefIgnored;
    }

    public boolean isTimeRefIgnored() {
        return this.timeRefIgnored;
    }

    public boolean checkClassVersion() {
        return this.checkClassVersion;
    }

    public CompatibleMode getCompatibleMode() {
        return this.compatibleMode;
    }

    public boolean checkJdkClassSerializable() {
        return this.checkJdkClassSerializable;
    }

    public boolean compressString() {
        return this.compressString;
    }

    public boolean compressNumber() {
        return this.compressNumber;
    }

    public boolean requireClassRegistration() {
        return this.requireClassRegistration;
    }

    public boolean registerGuavaTypes() {
        return this.registerGuavaTypes;
    }

    public Class<? extends Serializer> getDefaultJDKStreamSerializerType() {
        return this.defaultJDKStreamSerializerType;
    }

    public boolean shareMetaContext() {
        return this.shareMetaContext;
    }

    public boolean deserializeUnexistedClass() {
        return this.deserializeUnexistedClass;
    }

    public boolean isCodeGenEnabled() {
        return this.codeGenEnabled;
    }

    public boolean isAsyncCompilationEnabled() {
        return this.asyncCompilationEnabled;
    }

    public int getConfigHash() {
        if (this.configHash == 0) {
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            try (ObjectOutputStream stream = new ObjectOutputStream(bas);){
                stream.writeObject(this);
                stream.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            byte[] bytes = bas.toByteArray();
            long hashPart1 = MurmurHash3.murmurhash3_x64_128(bytes, 0, bytes.length, 47)[0];
            this.configHash = Math.abs((int)hashPart1);
        }
        return this.configHash;
    }
}

