/*
 * Decompiled with CFR 0.152.
 */
package io.fury.codegen;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.fury.builder.Generated;
import io.fury.codegen.CompileCallback;
import io.fury.codegen.CompileState;
import io.fury.codegen.CompileUnit;
import io.fury.codegen.JaninoUtils;
import io.fury.collection.MultiKeyWeakMap;
import io.fury.util.ClassLoaderUtils;
import io.fury.util.LoggerFactory;
import io.fury.util.ReflectionUtils;
import io.fury.util.StringUtils;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class CodeGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(CodeGenerator.class);
    private static final String CODE_DIR_KEY = "FURY_CODE_DIR";
    private static final String DELETE_CODE_ON_EXIT_KEY = "FURY_DELETE_CODE_ON_EXIT";
    static final int DEFAULT_JVM_HUGE_METHOD_LIMIT = 8000;
    static final int DEFAULT_JVM_INLINE_METHOD_LIMIT = 325;
    static final int MAX_JVM_METHOD_PARAMS_LENGTH = 255;
    private static final WeakHashMap<ClassLoader, SoftReference<CodeGenerator>> sharedCodeGenerator = new WeakHashMap();
    private static final MultiKeyWeakMap<SoftReference<CodeGenerator>> sharedCodeGenerator2 = new MultiKeyWeakMap();
    private static final String FALLBACK_PACKAGE = Generated.class.getPackage().getName();
    public static final boolean ENABLE_FURY_GENERATED_CLASS_UNIQUE_ID;
    private static int maxPoolSize;
    private static ListeningExecutorService compilationExecutorService;
    private ClassLoader classLoader;
    private final Object classLoaderLock;
    private final ConcurrentHashMap<String, CompileState> parallelCompileState;
    private final ConcurrentHashMap<String, DefineState> parallelDefineStatusLock;

    public CodeGenerator(ClassLoader classLoader) {
        Preconditions.checkNotNull(classLoader);
        this.classLoader = classLoader;
        this.parallelCompileState = new ConcurrentHashMap();
        this.parallelDefineStatusLock = new ConcurrentHashMap();
        this.classLoaderLock = new Object();
    }

    public ClassLoader compile(CompileUnit ... units) {
        return this.compile(Arrays.asList(units), (CompileState compileState) -> compileState.lock.lock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader compile(List<CompileUnit> units, CompileCallback callback) {
        Map<String, byte[]> classes;
        ClassLoader parentClassLoader;
        ArrayList<CompileUnit> compileUnits = new ArrayList<CompileUnit>();
        Object object = this.classLoaderLock;
        synchronized (object) {
            for (CompileUnit unit : units) {
                if (this.classExists(this.classLoader, unit.getQualifiedClassName())) continue;
                compileUnits.add(unit);
            }
            if (compileUnits.isEmpty()) {
                return this.classLoader;
            }
            parentClassLoader = this.classLoader;
        }
        CompileState compileState = this.getCompileState(compileUnits);
        callback.lock(compileState);
        if (compileState.finished) {
            classes = compileState.result;
            compileState.lock.unlock();
        } else {
            try {
                compileState.result = classes = JaninoUtils.toBytecode(parentClassLoader, compileUnits.toArray(new CompileUnit[0]));
                compileState.finished = true;
            }
            finally {
                compileState.lock.unlock();
            }
            for (Map.Entry<String, byte[]> e : classes.entrySet()) {
                String key = e.getKey();
                byte[] value = e.getValue();
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Code stats for class {} is {}", (Object)key, (Object)JaninoUtils.getClassStats(value));
            }
        }
        return this.defineClasses(classes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoader defineClasses(Map<String, byte[]> classes) {
        boolean isByteArrayClassLoader;
        if (classes.isEmpty()) {
            return this.getClassLoader();
        }
        ClassLoader resultClassLoader = null;
        Object object = this.classLoaderLock;
        synchronized (object) {
            isByteArrayClassLoader = this.classLoader instanceof ClassLoaderUtils.ByteArrayClassLoader;
            if (isByteArrayClassLoader) {
                resultClassLoader = this.classLoader;
            }
        }
        if (isByteArrayClassLoader) {
            for (Map.Entry entry : classes.entrySet()) {
                String className = CodeGenerator.fullClassNameFromClassFilePath((String)entry.getKey());
                DefineState defineState = this.getDefineState(className);
                if (defineState.defined) continue;
                Object object2 = defineState.lock;
                synchronized (object2) {
                    if (!defineState.defined) {
                        ((ClassLoaderUtils.ByteArrayClassLoader)resultClassLoader).defineClassPublic(className, (byte[])entry.getValue());
                        defineState.defined = true;
                    }
                }
            }
        } else {
            object = this.classLoaderLock;
            synchronized (object) {
                ClassLoaderUtils.ByteArrayClassLoader byteArrayClassLoader = new ClassLoaderUtils.ByteArrayClassLoader(classes, this.classLoader);
                for (String k : classes.keySet()) {
                    String className = CodeGenerator.fullClassNameFromClassFilePath(k);
                    DefineState defineState = this.getDefineState(className);
                    defineState.defined = true;
                }
                this.classLoader = byteArrayClassLoader;
                resultClassLoader = byteArrayClassLoader;
            }
        }
        return resultClassLoader;
    }

    public ListenableFuture<Class<?>[]> asyncCompile(CompileUnit ... compileUnits) {
        return CodeGenerator.getCompilationService().submit(() -> {
            ClassLoader loader = this.compile(compileUnits);
            return (Class[])Arrays.stream(compileUnits).map(compileUnit -> {
                try {
                    return loader.loadClass(compileUnit.getQualifiedClassName());
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Impossible because we just compiled class", e);
                }
            }).toArray(Class[]::new);
        });
    }

    public static void seMaxCompilationThreadPoolSize(int maxCompilationThreadPoolSize) {
        maxPoolSize = maxCompilationThreadPoolSize;
    }

    public static synchronized ListeningExecutorService getCompilationService() {
        if (compilationExecutorService == null) {
            ThreadPoolExecutor executor = new ThreadPoolExecutor(maxPoolSize, maxPoolSize, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("fury-jit-compiler-%d").build(), (r, e) -> LOG.warn("Task {} rejected from {}", (Object)r.toString(), (Object)e));
            executor.allowCoreThreadTimeOut(true);
            compilationExecutorService = MoreExecutors.listeningDecorator(executor);
        }
        return compilationExecutorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader() {
        Object object = this.classLoaderLock;
        synchronized (object) {
            return this.classLoader;
        }
    }

    private CompileState getCompileState(List<CompileUnit> toCompile) {
        return this.parallelCompileState.computeIfAbsent(this.getCompileLockKey(toCompile), k -> new CompileState());
    }

    private String getCompileLockKey(List<CompileUnit> toCompile) {
        if (toCompile.size() == 1) {
            return toCompile.get(0).getQualifiedClassName();
        }
        StringJoiner joiner = new StringJoiner(",");
        for (CompileUnit unit : toCompile) {
            joiner.add(unit.getQualifiedClassName());
        }
        return joiner.toString();
    }

    private DefineState getDefineState(String className) {
        return this.parallelDefineStatusLock.computeIfAbsent(className, k -> new DefineState());
    }

    private boolean classExists(ClassLoader loader, String className) {
        try {
            loader.loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static synchronized CodeGenerator getSharedCodeGenerator(ClassLoader ... classLoaders) {
        CodeGenerator codeGenerator;
        SoftReference<CodeGenerator> codeGeneratorWeakRef = sharedCodeGenerator2.get(classLoaders);
        CodeGenerator codeGenerator2 = codeGenerator = codeGeneratorWeakRef != null ? codeGeneratorWeakRef.get() : null;
        if (codeGenerator == null) {
            codeGenerator = new CodeGenerator(new ClassLoaderUtils.ComposedClassLoader(classLoaders));
            sharedCodeGenerator2.put(classLoaders, new SoftReference<CodeGenerator>(codeGenerator));
        }
        return codeGenerator;
    }

    public static synchronized CodeGenerator getSharedCodeGenerator(ClassLoader classLoader) {
        SoftReference<CodeGenerator> codeGeneratorWeakRef;
        CodeGenerator codeGenerator;
        if (classLoader == null) {
            classLoader = CodeGenerator.class.getClassLoader();
        }
        CodeGenerator codeGenerator2 = codeGenerator = (codeGeneratorWeakRef = sharedCodeGenerator.get(classLoader)) != null ? codeGeneratorWeakRef.get() : null;
        if (codeGenerator == null) {
            codeGenerator = new CodeGenerator(classLoader);
            sharedCodeGenerator.put(classLoader, new SoftReference<CodeGenerator>(codeGenerator));
        }
        return codeGenerator;
    }

    public static String getPackage(Class<?> cls) {
        String pkg = ReflectionUtils.getPackage(cls);
        if (pkg.startsWith("java")) {
            return FALLBACK_PACKAGE;
        }
        return pkg;
    }

    public static String getClassUniqueId(Class<?> cls) {
        if (!ENABLE_FURY_GENERATED_CLASS_UNIQUE_ID) {
            return "";
        }
        ClassLoader classLoader = cls.getClassLoader();
        if (classLoader == null) {
            return String.valueOf(cls.hashCode());
        }
        return String.format("%s_%s", classLoader.hashCode(), cls.hashCode());
    }

    public static String getCodeDir() {
        return System.getProperty(CODE_DIR_KEY, System.getenv(CODE_DIR_KEY));
    }

    static boolean deleteCodeOnExit() {
        boolean deleteCodeOnExit = StringUtils.isBlank(CodeGenerator.getCodeDir());
        String deleteCodeOnExitStr = System.getProperty(DELETE_CODE_ON_EXIT_KEY, System.getenv(DELETE_CODE_ON_EXIT_KEY));
        if (deleteCodeOnExitStr != null) {
            deleteCodeOnExit = Boolean.parseBoolean(deleteCodeOnExitStr);
        }
        return deleteCodeOnExit;
    }

    public static String classFilepath(CompileUnit unit) {
        return CodeGenerator.classFilepath(CodeGenerator.fullClassName(unit));
    }

    public static String classFilepath(String pkg, String className) {
        return CodeGenerator.classFilepath(pkg + "." + className);
    }

    public static String classFilepath(String fullClassName) {
        int index = fullClassName.lastIndexOf(".");
        if (index >= 0) {
            return String.format("%s/%s.class", fullClassName.substring(0, index).replace(".", "/"), fullClassName.substring(index + 1));
        }
        return fullClassName + ".class";
    }

    public static String fullClassName(CompileUnit unit) {
        return unit.pkg + "." + unit.mainClassName;
    }

    public static String fullClassNameFromClassFilePath(String classFilePath) {
        return classFilePath.substring(0, classFilePath.length() - ".class".length()).replace("/", ".");
    }

    public static String alignIndent(String code) {
        return CodeGenerator.alignIndent(code, 4);
    }

    public static String alignIndent(String code, int numSpaces) {
        if (code == null) {
            return "";
        }
        String[] split2 = code.split("\n");
        if (split2.length == 1) {
            return code;
        }
        StringBuilder codeBuilder = new StringBuilder(split2[0]).append('\n');
        for (int i = 1; i < split2.length; ++i) {
            for (int j = 0; j < numSpaces; ++j) {
                codeBuilder.append(' ');
            }
            codeBuilder.append(split2[i]).append('\n');
        }
        if (code.charAt(code.length() - 1) == '\n') {
            return codeBuilder.toString();
        }
        return codeBuilder.substring(0, codeBuilder.length() - 1);
    }

    static String indent(String code) {
        return CodeGenerator.indent(code, 2);
    }

    static String indent(String code, int numSpaces) {
        if (code == null) {
            return "";
        }
        String[] split2 = code.split("\n");
        StringBuilder codeBuilder = new StringBuilder();
        for (String line : split2) {
            for (int i = 0; i < numSpaces; ++i) {
                codeBuilder.append(' ');
            }
            codeBuilder.append(line).append('\n');
        }
        if (code.charAt(code.length() - 1) == '\n') {
            return codeBuilder.toString();
        }
        return codeBuilder.substring(0, codeBuilder.length() - 1);
    }

    static String spaces(int numSpaces) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < numSpaces; ++i) {
            builder.append(' ');
        }
        return builder.toString();
    }

    static void appendNewlineIfNeeded(StringBuilder sb) {
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) != '\n') {
            sb.append('\n');
        }
    }

    static StringBuilder stripLastNewline(StringBuilder sb) {
        int length = sb.length();
        Preconditions.checkArgument(length > 0 && sb.charAt(length - 1) == '\n');
        sb.deleteCharAt(length - 1);
        return sb;
    }

    static StringBuilder stripIfHasLastNewline(StringBuilder sb) {
        int length = sb.length();
        if (length > 0 && sb.charAt(length - 1) == '\n') {
            sb.deleteCharAt(length - 1);
        }
        return sb;
    }

    static {
        maxPoolSize = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
        boolean useUniqueId = StringUtils.isBlank(CodeGenerator.getCodeDir());
        String flagValue = System.getProperty("fury.enable_fury_generated_class_unique_id", System.getenv("ENABLE_FURY_GENERATED_CLASS_UNIQUE_ID"));
        if (flagValue != null) {
            useUniqueId = "true".equals(flagValue);
        }
        ENABLE_FURY_GENERATED_CLASS_UNIQUE_ID = useUniqueId;
    }

    private static class DefineState {
        final Object lock = new Object();
        volatile boolean defined;

        private DefineState() {
        }
    }
}

