/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import com.google.common.base.Preconditions;
import io.fury.Fury;
import io.fury.memory.MemoryBuffer;
import io.fury.resolver.ClassInfo;
import io.fury.resolver.ClassResolver;
import io.fury.resolver.FieldResolver;
import io.fury.resolver.RefResolver;
import io.fury.serializer.CollectionSerializers;
import io.fury.serializer.CompatibleSerializerBase;
import io.fury.serializer.MapSerializers;
import io.fury.serializer.ObjectSerializer;
import io.fury.serializer.Serializer;
import io.fury.util.Platform;
import io.fury.util.UnsafeFieldAccessor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;

public final class CompatibleSerializer<T>
extends CompatibleSerializerBase<T> {
    private static final int INDEX_FOR_SKIP_FILL_VALUES = -1;
    private final RefResolver refResolver;
    private final ClassResolver classResolver;
    private final FieldResolver fieldResolver;
    private final Constructor<T> constructor;
    private final boolean compressNumber;

    public CompatibleSerializer(Fury fury, Class<T> cls) {
        super(fury, cls);
        Constructor<T> constructor;
        this.refResolver = fury.getRefResolver();
        this.classResolver = fury.getClassResolver();
        this.classResolver.setSerializerIfAbsent(cls, this);
        try {
            constructor = cls.getConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
        }
        catch (Exception e) {
            constructor = null;
        }
        this.constructor = constructor;
        this.fieldResolver = this.classResolver.getFieldResolver(cls);
        this.compressNumber = fury.compressNumber();
    }

    public CompatibleSerializer(Fury fury, Class<T> cls, FieldResolver fieldResolver) {
        super(fury, cls);
        this.refResolver = fury.getRefResolver();
        this.classResolver = fury.getClassResolver();
        this.constructor = null;
        this.fieldResolver = fieldResolver;
        this.compressNumber = fury.compressNumber();
    }

    @Override
    public void write(MemoryBuffer buffer, T value) {
        for (FieldResolver.FieldInfo fieldInfo : this.fieldResolver.getEmbedTypes4Fields()) {
            buffer.writeInt((int)fieldInfo.getEncodedFieldInfo());
            this.readAndWriteFieldValue(buffer, fieldInfo, value);
        }
        for (FieldResolver.FieldInfo fieldInfo : this.fieldResolver.getEmbedTypes9Fields()) {
            buffer.writeLong(fieldInfo.getEncodedFieldInfo());
            this.readAndWriteFieldValue(buffer, fieldInfo, value);
        }
        for (FieldResolver.FieldInfo fieldInfo : this.fieldResolver.getEmbedTypesHashFields()) {
            buffer.writeLong(fieldInfo.getEncodedFieldInfo());
            this.readAndWriteFieldValue(buffer, fieldInfo, value);
        }
        for (FieldResolver.FieldInfo fieldInfo : this.fieldResolver.getSeparateTypesHashFields()) {
            buffer.writeLong(fieldInfo.getEncodedFieldInfo());
            this.readAndWriteFieldValue(buffer, fieldInfo, value);
        }
        buffer.writeLong(this.fieldResolver.getEndTag());
    }

    public void writeFieldsValues(MemoryBuffer buffer, Object[] vals) {
        FieldResolver fieldResolver = this.fieldResolver;
        Fury fury = this.fury;
        int index = 0;
        for (FieldResolver.FieldInfo fieldInfo : fieldResolver.getEmbedTypes4Fields()) {
            buffer.writeInt((int)fieldInfo.getEncodedFieldInfo());
            this.writeFieldValue(fieldInfo, buffer, vals[index++]);
        }
        for (FieldResolver.FieldInfo fieldInfo : fieldResolver.getEmbedTypes9Fields()) {
            buffer.writeLong(fieldInfo.getEncodedFieldInfo());
            this.writeFieldValue(fieldInfo, buffer, vals[index++]);
        }
        for (FieldResolver.FieldInfo fieldInfo : fieldResolver.getEmbedTypesHashFields()) {
            buffer.writeLong(fieldInfo.getEncodedFieldInfo());
            this.writeFieldValue(fieldInfo, buffer, vals[index++]);
        }
        for (FieldResolver.FieldInfo fieldInfo : fieldResolver.getSeparateTypesHashFields()) {
            buffer.writeLong(fieldInfo.getEncodedFieldInfo());
            Object value = vals[index++];
            if (fury.getRefResolver().writeRefOrNull(buffer, value)) continue;
            byte fieldType = fieldInfo.getFieldType();
            buffer.writeByte(fieldType);
            Preconditions.checkArgument(fieldType == 0);
            ClassInfo classInfo = fieldInfo.getClassInfo(value.getClass());
            fury.writeNonRef(buffer, value, classInfo);
        }
        buffer.writeLong(fieldResolver.getEndTag());
    }

    private void readAndWriteFieldValue(MemoryBuffer buffer, FieldResolver.FieldInfo fieldInfo, Object targetObject) {
        Object fieldValue;
        short classId;
        UnsafeFieldAccessor fieldAccessor = fieldInfo.getUnsafeFieldAccessor();
        if (ObjectSerializer.writePrimitiveFieldValueFailed(this.fury, buffer, targetObject, fieldAccessor, classId = fieldInfo.getEmbeddedClassId()) && ObjectSerializer.writeBasicObjectFieldValueFailed(this.fury, buffer, fieldValue = fieldAccessor.getObject(targetObject), classId)) {
            if (classId == 0) {
                this.writeSeparateFieldValue(fieldInfo, buffer, fieldValue);
            } else {
                ClassInfo classInfo = fieldInfo.getClassInfo(classId);
                Serializer serializer = classInfo.getSerializer();
                this.fury.writeRef(buffer, fieldValue, serializer);
            }
        }
    }

    private void writeFieldValue(FieldResolver.FieldInfo fieldInfo, MemoryBuffer buffer, Object fieldValue) {
        short classId = fieldInfo.getEmbeddedClassId();
        switch (classId) {
            case 5: {
                buffer.writeBoolean((Boolean)fieldValue);
                return;
            }
            case 6: {
                buffer.writeByte((Byte)fieldValue);
                return;
            }
            case 7: {
                buffer.writeChar(((Character)fieldValue).charValue());
                return;
            }
            case 8: {
                buffer.writeShort((Short)fieldValue);
                return;
            }
            case 9: {
                if (this.compressNumber) {
                    buffer.writeVarInt((Integer)fieldValue);
                } else {
                    buffer.writeInt((Integer)fieldValue);
                }
                return;
            }
            case 10: {
                buffer.writeFloat(((Float)fieldValue).floatValue());
                return;
            }
            case 11: {
                if (this.compressNumber) {
                    buffer.writeVarLong((Long)fieldValue);
                } else {
                    buffer.writeLong((Long)fieldValue);
                }
                return;
            }
            case 12: {
                buffer.writeDouble((Double)fieldValue);
                return;
            }
            case 22: {
                this.fury.writeJavaStringRef(buffer, (String)fieldValue);
                break;
            }
            case 0: {
                this.writeSeparateFieldValue(fieldInfo, buffer, fieldValue);
                break;
            }
            default: {
                ClassInfo classInfo = fieldInfo.getClassInfo(classId);
                Serializer serializer = classInfo.getSerializer();
                this.fury.writeRef(buffer, fieldValue, serializer);
            }
        }
    }

    private void writeSeparateFieldValue(FieldResolver.FieldInfo fieldInfo, MemoryBuffer buffer, Object fieldValue) {
        if (!this.refResolver.writeRefOrNull(buffer, fieldValue)) {
            byte fieldType = fieldInfo.getFieldType();
            buffer.writeByte(fieldType);
            if (fieldType == 0) {
                ClassInfo classInfo = fieldInfo.getClassInfo(fieldValue.getClass());
                this.fury.writeNonRef(buffer, fieldValue, classInfo);
            } else if (fieldType == 1) {
                this.writeCollectionField(buffer, (FieldResolver.CollectionFieldInfo)fieldInfo, (Collection)fieldValue);
            } else if (fieldType == 4) {
                this.writeMapKVFinal(buffer, (FieldResolver.MapFieldInfo)fieldInfo, (Map)fieldValue);
            } else if (fieldType == 2) {
                this.writeMapKeyFinal(buffer, (FieldResolver.MapFieldInfo)fieldInfo, (Map)fieldValue);
            } else {
                Preconditions.checkArgument(fieldType == 3);
                this.writeMapValueFinal(buffer, (FieldResolver.MapFieldInfo)fieldInfo, (Map)fieldValue);
            }
        }
    }

    private void writeCollectionField(MemoryBuffer buffer, FieldResolver.CollectionFieldInfo fieldInfo, Collection fieldValue) {
        ClassInfo elementClassInfo = fieldInfo.getElementClassInfo();
        this.classResolver.writeClass(buffer, elementClassInfo);
        ClassInfo classInfo = fieldInfo.getClassInfo(fieldValue.getClass());
        this.classResolver.writeClass(buffer, classInfo);
        CollectionSerializers.CollectionSerializer collectionSerializer = (CollectionSerializers.CollectionSerializer)classInfo.getSerializer();
        collectionSerializer.setElementSerializer(elementClassInfo.getSerializer());
        collectionSerializer.write(buffer, fieldValue);
    }

    private void writeMapKVFinal(MemoryBuffer buffer, FieldResolver.MapFieldInfo fieldInfo, Map fieldValue) {
        ClassInfo keyClassInfo = fieldInfo.getKeyClassInfo();
        ClassInfo valueClassInfo = fieldInfo.getValueClassInfo();
        this.classResolver.writeClass(buffer, keyClassInfo);
        this.classResolver.writeClass(buffer, valueClassInfo);
        ClassInfo classInfo = fieldInfo.getClassInfo(fieldValue.getClass());
        this.classResolver.writeClass(buffer, classInfo);
        MapSerializers.MapSerializer mapSerializer = (MapSerializers.MapSerializer)classInfo.getSerializer();
        mapSerializer.setKeySerializer(keyClassInfo.getSerializer());
        mapSerializer.setValueSerializer(valueClassInfo.getSerializer());
        mapSerializer.write(buffer, fieldValue);
    }

    private void writeMapKeyFinal(MemoryBuffer buffer, FieldResolver.MapFieldInfo fieldInfo, Map fieldValue) {
        ClassInfo keyClassInfo = fieldInfo.getKeyClassInfo();
        this.classResolver.writeClass(buffer, keyClassInfo);
        ClassInfo classInfo = fieldInfo.getClassInfo(fieldValue.getClass());
        this.classResolver.writeClass(buffer, classInfo);
        MapSerializers.MapSerializer mapSerializer = (MapSerializers.MapSerializer)classInfo.getSerializer();
        mapSerializer.setKeySerializer(keyClassInfo.getSerializer());
        mapSerializer.write(buffer, fieldValue);
    }

    private void writeMapValueFinal(MemoryBuffer buffer, FieldResolver.MapFieldInfo fieldInfo, Map fieldValue) {
        ClassInfo valueClassInfo = fieldInfo.getValueClassInfo();
        this.classResolver.writeClass(buffer, valueClassInfo);
        ClassInfo classInfo = fieldInfo.getClassInfo(fieldValue.getClass());
        this.classResolver.writeClass(buffer, classInfo);
        MapSerializers.MapSerializer mapSerializer = (MapSerializers.MapSerializer)classInfo.getSerializer();
        mapSerializer.setValueSerializer(valueClassInfo.getSerializer());
        mapSerializer.write(buffer, fieldValue);
    }

    @Override
    public T read(MemoryBuffer buffer) {
        Object obj = this.newBean();
        this.refResolver.reference(obj);
        return (T)this.readAndSetFields(buffer, obj);
    }

    @Override
    public T readAndSetFields(MemoryBuffer buffer, T obj) {
        long endTag;
        long partFieldInfo = this.readEmbedTypes4Fields(buffer, obj, null, -1);
        if (partFieldInfo == (endTag = this.fieldResolver.getEndTag())) {
            return obj;
        }
        long tmp = buffer.readInt();
        partFieldInfo = tmp << 32 | partFieldInfo & 0xFFFFFFFFL;
        if ((partFieldInfo = this.readEmbedTypes9Fields(buffer, partFieldInfo, obj, null, -1)) == endTag) {
            return obj;
        }
        if ((partFieldInfo = this.readEmbedTypesHashFields(buffer, partFieldInfo, obj, null, -1)) == endTag) {
            return obj;
        }
        this.readSeparateTypesHashField(buffer, partFieldInfo, obj, null, -1);
        return obj;
    }

    public void readFields(MemoryBuffer buffer, Object[] vals) {
        long endTag;
        int startIndex = 0;
        long partFieldInfo = this.readEmbedTypes4Fields(buffer, null, vals, startIndex);
        if (partFieldInfo == (endTag = this.fieldResolver.getEndTag())) {
            return;
        }
        long tmp = buffer.readInt();
        partFieldInfo = tmp << 32 | partFieldInfo & 0xFFFFFFFFL;
        if ((partFieldInfo = this.readEmbedTypes9Fields(buffer, partFieldInfo, null, vals, startIndex += this.fieldResolver.getEmbedTypes4Fields().length)) == endTag) {
            return;
        }
        if ((partFieldInfo = this.readEmbedTypesHashFields(buffer, partFieldInfo, null, vals, startIndex += this.fieldResolver.getEmbedTypes9Fields().length)) == endTag) {
            return;
        }
        this.readSeparateTypesHashField(buffer, partFieldInfo, null, vals, startIndex += this.fieldResolver.getEmbedTypesHashFields().length);
    }

    private long readEmbedTypes4Fields(MemoryBuffer buffer, Object obj, Object[] vals, int startIndex) {
        long partFieldInfo = buffer.readInt();
        FieldResolver.FieldInfo[] embedTypes4Fields = this.fieldResolver.getEmbedTypes4Fields();
        if (embedTypes4Fields.length > 0) {
            long minFieldInfo = embedTypes4Fields[0].getEncodedFieldInfo();
            while ((partFieldInfo & 3L) == 1L && partFieldInfo < minFieldInfo) {
                long part = this.fieldResolver.skipDataBy4(buffer, (int)partFieldInfo);
                if (part != partFieldInfo) {
                    return part;
                }
                partFieldInfo = buffer.readInt();
            }
            for (int i = 0; i < embedTypes4Fields.length; ++i) {
                FieldResolver.FieldInfo fieldInfo = embedTypes4Fields[i];
                long encodedFieldInfo = fieldInfo.getEncodedFieldInfo();
                if (encodedFieldInfo == partFieldInfo) {
                    if (obj != null) {
                        this.readAndSetFieldValue(fieldInfo, buffer, obj);
                    } else {
                        vals[startIndex + i] = this.readFieldValue(fieldInfo, buffer);
                    }
                    partFieldInfo = buffer.readInt();
                    continue;
                }
                if ((partFieldInfo & 3L) != 1L) break;
                if (partFieldInfo >= encodedFieldInfo) continue;
                long part = this.fieldResolver.skipDataBy4(buffer, (int)partFieldInfo);
                if (part != partFieldInfo) {
                    return part;
                }
                partFieldInfo = buffer.readInt();
                --i;
            }
        }
        while ((partFieldInfo & 3L) == 1L) {
            long part = this.fieldResolver.skipDataBy4(buffer, (int)partFieldInfo);
            if (part != partFieldInfo) {
                return part;
            }
            partFieldInfo = buffer.readInt();
        }
        return partFieldInfo;
    }

    private long readEmbedTypes9Fields(MemoryBuffer buffer, long partFieldInfo, Object obj, Object[] vals, int startIndex) {
        FieldResolver.FieldInfo[] embedTypes9Fields = this.fieldResolver.getEmbedTypes9Fields();
        if (embedTypes9Fields.length > 0) {
            long minFieldInfo = embedTypes9Fields[0].getEncodedFieldInfo();
            while ((partFieldInfo & 7L) == 3L && partFieldInfo < minFieldInfo) {
                long part = this.fieldResolver.skipDataBy8(buffer, partFieldInfo);
                if (part != partFieldInfo) {
                    return part;
                }
                partFieldInfo = buffer.readLong();
            }
            for (int i = 0; i < embedTypes9Fields.length; ++i) {
                FieldResolver.FieldInfo fieldInfo = embedTypes9Fields[i];
                long encodedFieldInfo = fieldInfo.getEncodedFieldInfo();
                if (encodedFieldInfo == partFieldInfo) {
                    if (obj != null) {
                        this.readAndSetFieldValue(fieldInfo, buffer, obj);
                    } else {
                        vals[startIndex + i] = this.readFieldValue(fieldInfo, buffer);
                    }
                    partFieldInfo = buffer.readLong();
                    continue;
                }
                if ((partFieldInfo & 7L) != 3L) break;
                if (partFieldInfo >= encodedFieldInfo) continue;
                long part = this.fieldResolver.skipDataBy8(buffer, partFieldInfo);
                if (part != partFieldInfo) {
                    return part;
                }
                partFieldInfo = buffer.readLong();
                --i;
            }
        }
        while ((partFieldInfo & 7L) == 3L) {
            long part = this.fieldResolver.skipDataBy8(buffer, partFieldInfo);
            if (part != partFieldInfo) {
                return part;
            }
            partFieldInfo = buffer.readLong();
        }
        return partFieldInfo;
    }

    private long readEmbedTypesHashFields(MemoryBuffer buffer, long partFieldInfo, Object obj, Object[] vals, int startIndex) {
        FieldResolver.FieldInfo[] embedTypesHashFields = this.fieldResolver.getEmbedTypesHashFields();
        if (embedTypesHashFields.length > 0) {
            long minFieldInfo = embedTypesHashFields[0].getEncodedFieldInfo();
            while ((partFieldInfo & 7L) == 7L && partFieldInfo < minFieldInfo) {
                long part = this.fieldResolver.skipDataBy8(buffer, partFieldInfo);
                if (part != partFieldInfo) {
                    return part;
                }
                partFieldInfo = buffer.readLong();
            }
            for (int i = 0; i < embedTypesHashFields.length; ++i) {
                FieldResolver.FieldInfo fieldInfo = embedTypesHashFields[i];
                long encodedFieldInfo = fieldInfo.getEncodedFieldInfo();
                if (encodedFieldInfo == partFieldInfo) {
                    if (obj != null) {
                        this.readAndSetFieldValue(fieldInfo, buffer, obj);
                    } else {
                        vals[startIndex + i] = this.readFieldValue(fieldInfo, buffer);
                    }
                    partFieldInfo = buffer.readLong();
                    continue;
                }
                if ((partFieldInfo & 7L) != 7L) break;
                if (partFieldInfo >= encodedFieldInfo) continue;
                long part = this.fieldResolver.skipDataBy8(buffer, partFieldInfo);
                if (part != partFieldInfo) {
                    return part;
                }
                partFieldInfo = buffer.readLong();
                --i;
            }
        }
        while ((partFieldInfo & 7L) == 7L) {
            long part = this.fieldResolver.skipDataBy8(buffer, partFieldInfo);
            if (part != partFieldInfo) {
                return part;
            }
            partFieldInfo = buffer.readLong();
        }
        return partFieldInfo;
    }

    private void readSeparateTypesHashField(MemoryBuffer buffer, long partFieldInfo, Object obj, Object[] vals, int startIndex) {
        FieldResolver.FieldInfo[] separateTypesHashFields = this.fieldResolver.getSeparateTypesHashFields();
        if (separateTypesHashFields.length > 0) {
            long minFieldInfo = separateTypesHashFields[0].getEncodedFieldInfo();
            while ((partFieldInfo & 3L) == 0L && partFieldInfo < minFieldInfo) {
                long part = this.fieldResolver.skipDataBy8(buffer, partFieldInfo);
                if (part != partFieldInfo) {
                    return;
                }
                partFieldInfo = buffer.readLong();
            }
            for (int i = 0; i < separateTypesHashFields.length; ++i) {
                FieldResolver.FieldInfo fieldInfo = separateTypesHashFields[i];
                long encodedFieldInfo = fieldInfo.getEncodedFieldInfo();
                if (encodedFieldInfo == partFieldInfo) {
                    if (obj != null) {
                        this.readAndSetFieldValue(fieldInfo, buffer, obj);
                    } else {
                        vals[startIndex + i] = this.readFieldValue(fieldInfo, buffer);
                    }
                    partFieldInfo = buffer.readLong();
                    continue;
                }
                if ((partFieldInfo & 3L) != 0L) break;
                if (partFieldInfo >= encodedFieldInfo) continue;
                long part = this.fieldResolver.skipDataBy8(buffer, partFieldInfo);
                if (part != partFieldInfo) {
                    return;
                }
                partFieldInfo = buffer.readLong();
                --i;
            }
        }
        this.fieldResolver.skipEndFields(buffer, partFieldInfo);
    }

    private void readAndSetFieldValue(FieldResolver.FieldInfo fieldInfo, MemoryBuffer buffer, Object targetObject) {
        short classId;
        UnsafeFieldAccessor fieldAccessor = fieldInfo.getUnsafeFieldAccessor();
        if (ObjectSerializer.readPrimitiveFieldValueFailed(this.fury, buffer, targetObject, fieldAccessor, classId = fieldInfo.getEmbeddedClassId()) && ObjectSerializer.readBasicObjectFieldValueFailed(this.fury, buffer, targetObject, fieldAccessor, classId)) {
            if (classId == 0) {
                Object fieldValue = this.fieldResolver.readObjectField(buffer, fieldInfo);
                fieldAccessor.putObject(targetObject, fieldValue);
            } else {
                ClassInfo classInfo = fieldInfo.getClassInfo(classId);
                Serializer serializer = classInfo.getSerializer();
                fieldAccessor.putObject(targetObject, this.fury.readRef(buffer, serializer));
            }
        }
    }

    private Object readFieldValue(FieldResolver.FieldInfo fieldInfo, MemoryBuffer buffer) {
        short classId = fieldInfo.getEmbeddedClassId();
        switch (classId) {
            case 5: {
                return buffer.readBoolean();
            }
            case 6: {
                return buffer.readByte();
            }
            case 7: {
                return Character.valueOf(buffer.readChar());
            }
            case 8: {
                return buffer.readShort();
            }
            case 9: {
                if (this.compressNumber) {
                    return buffer.readVarInt();
                }
                return buffer.readInt();
            }
            case 10: {
                return Float.valueOf(buffer.readFloat());
            }
            case 11: {
                if (this.compressNumber) {
                    return buffer.readVarLong();
                }
                return buffer.readLong();
            }
            case 12: {
                return buffer.readDouble();
            }
            case 22: {
                return this.fury.readJavaStringRef(buffer);
            }
            case 0: {
                return this.fieldResolver.readObjectField(buffer, fieldInfo);
            }
        }
        ClassInfo classInfo = fieldInfo.getClassInfo(classId);
        Serializer serializer = classInfo.getSerializer();
        return this.fury.readRef(buffer, serializer);
    }

    private Object newBean() {
        if (this.constructor != null) {
            try {
                return this.constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                Platform.throwException(e);
            }
        }
        return Platform.newInstance(this.type);
    }
}

