/*
 * Decompiled with CFR 0.152.
 */
package io.fury.util;

import com.google.common.base.Preconditions;
import io.fury.util.ReflectionUtils;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class Functions {
    public static boolean isLambda(Class<?> clz) {
        Preconditions.checkNotNull(clz);
        return clz.getName().indexOf(47) >= 0;
    }

    public static List<Object> extractCapturedVariables(Serializable closure) {
        return Functions.extractCapturedVariables(closure, o -> true);
    }

    public static List<Object> extractCapturedVariables(Serializable closure, Predicate<Object> predicate) {
        SerializedLambda serializedLambda;
        Preconditions.checkArgument(Functions.isLambda(closure.getClass()));
        Method writeReplace = ReflectionUtils.findMethods(closure.getClass(), "writeReplace").get(0);
        writeReplace.setAccessible(true);
        try {
            serializedLambda = (SerializedLambda)writeReplace.invoke((Object)closure, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException();
        }
        ArrayList<Object> variables = new ArrayList<Object>();
        for (int i = 0; i < serializedLambda.getCapturedArgCount(); ++i) {
            Object capturedArg = serializedLambda.getCapturedArg(i);
            if (!predicate.test(capturedArg)) continue;
            variables.add(capturedArg);
        }
        return variables;
    }

    @FunctionalInterface
    public static interface TriFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3);

        default public <V> TriFunction<A, B, C, V> andThen(Function<? super R, ? extends V> after) {
            Preconditions.checkNotNull(after);
            return (a, b, c) -> after.apply((R)this.apply(a, b, c));
        }
    }

    public static interface SerializableTriFunction<A, B, C, R>
    extends TriFunction<A, B, C, R>,
    Serializable {
    }

    public static interface SerializableSupplier<T>
    extends Supplier<T>,
    Serializable {
    }

    public static interface SerializableFunction<T, R>
    extends Function<T, R>,
    Serializable {
    }

    public static interface SerializableBiFunction<T, U, R>
    extends BiFunction<T, U, R>,
    Serializable {
    }
}

