/*
 * Decompiled with CFR 0.152.
 */
package io.fury.util;

import com.google.common.base.Preconditions;
import io.fury.util.unsafe._JDKAccess;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import sun.misc.Unsafe;

public final class Platform {
    public static final Unsafe UNSAFE;
    public static final int JAVA_VERSION;
    public static final boolean IS_LITTLE_ENDIAN;
    public static final int BOOLEAN_ARRAY_OFFSET;
    public static final int BYTE_ARRAY_OFFSET;
    public static final int CHAR_ARRAY_OFFSET;
    public static final int SHORT_ARRAY_OFFSET;
    public static final int INT_ARRAY_OFFSET;
    public static final int LONG_ARRAY_OFFSET;
    public static final int FLOAT_ARRAY_OFFSET;
    public static final int DOUBLE_ARRAY_OFFSET;
    private static final boolean unaligned;
    private static final long UNSAFE_COPY_THRESHOLD = 0x100000L;
    private static final long BUFFER_ADDRESS_FIELD_OFFSET;
    private static final long BUFFER_CAPACITY_FIELD_OFFSET;
    private static final ByteBuffer localBuffer;

    private static Class<?> getClassByName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean unaligned() {
        return unaligned;
    }

    public static long objectFieldOffset(Field f) {
        return UNSAFE.objectFieldOffset(f);
    }

    public static int getInt(Object object, long offset) {
        return UNSAFE.getInt(object, offset);
    }

    public static void putInt(Object object, long offset, int value) {
        UNSAFE.putInt(object, offset, value);
    }

    public static boolean getBoolean(Object object, long offset) {
        return UNSAFE.getBoolean(object, offset);
    }

    public static void putBoolean(Object object, long offset, boolean value) {
        UNSAFE.putBoolean(object, offset, value);
    }

    public static byte getByte(Object object, long offset) {
        return UNSAFE.getByte(object, offset);
    }

    public static void putByte(Object object, long offset, byte value) {
        UNSAFE.putByte(object, offset, value);
    }

    public static short getShort(Object object, long offset) {
        return UNSAFE.getShort(object, offset);
    }

    public static void putShort(Object object, long offset, short value) {
        UNSAFE.putShort(object, offset, value);
    }

    public static char getChar(Object obj, long offset) {
        return UNSAFE.getChar(obj, offset);
    }

    public static void putChar(Object obj, long offset, char value) {
        UNSAFE.putChar(obj, offset, value);
    }

    public static long getLong(Object object, long offset) {
        return UNSAFE.getLong(object, offset);
    }

    public static void putLong(Object object, long offset, long value) {
        UNSAFE.putLong(object, offset, value);
    }

    public static float getFloat(Object object, long offset) {
        return UNSAFE.getFloat(object, offset);
    }

    public static void putFloat(Object object, long offset, float value) {
        UNSAFE.putFloat(object, offset, value);
    }

    public static double getDouble(Object object, long offset) {
        return UNSAFE.getDouble(object, offset);
    }

    public static void putDouble(Object object, long offset, double value) {
        UNSAFE.putDouble(object, offset, value);
    }

    public static Object getObject(Object o, long offset) {
        return UNSAFE.getObject(o, offset);
    }

    public static void putObject(Object object, long offset, Object value) {
        UNSAFE.putObject(object, offset, value);
    }

    public static Object getObjectVolatile(Object object, long offset) {
        return UNSAFE.getObjectVolatile(object, offset);
    }

    public static void putObjectVolatile(Object object, long offset, Object value) {
        UNSAFE.putObjectVolatile(object, offset, value);
    }

    public static long allocateMemory(long size) {
        return UNSAFE.allocateMemory(size);
    }

    public static void freeMemory(long address) {
        UNSAFE.freeMemory(address);
    }

    public static long reallocateMemory(long address, long oldSize, long newSize) {
        long newMemory = UNSAFE.allocateMemory(newSize);
        Platform.copyMemory(null, address, null, newMemory, oldSize);
        Platform.freeMemory(address);
        return newMemory;
    }

    public static void setMemory(Object object, long offset, long size, byte value) {
        UNSAFE.setMemory(object, offset, size, value);
    }

    public static void setMemory(long address, byte value, long size) {
        UNSAFE.setMemory(address, size, value);
    }

    public static void copyMemory(Object src, long srcOffset, Object dst, long dstOffset, long length) {
        if (length < 0x100000L) {
            UNSAFE.copyMemory(src, srcOffset, dst, dstOffset, length);
        } else {
            while (length > 0L) {
                long size = Math.min(length, 0x100000L);
                UNSAFE.copyMemory(src, srcOffset, dst, dstOffset, size);
                length -= size;
                srcOffset += size;
                dstOffset += size;
            }
        }
    }

    public static boolean arrayEquals(Object leftBase, long leftOffset, Object rightBase, long rightOffset, long length) {
        int i = 0;
        if (leftOffset % 8L == rightOffset % 8L) {
            while ((leftOffset + (long)i) % 8L != 0L && (long)i < length) {
                if (Platform.getByte(leftBase, leftOffset + (long)i) != Platform.getByte(rightBase, rightOffset + (long)i)) {
                    return false;
                }
                ++i;
            }
        }
        if (unaligned || (leftOffset + (long)i) % 8L == 0L && (rightOffset + (long)i) % 8L == 0L) {
            while ((long)i <= length - 8L) {
                if (Platform.getLong(leftBase, leftOffset + (long)i) != Platform.getLong(rightBase, rightOffset + (long)i)) {
                    return false;
                }
                i += 8;
            }
        }
        while ((long)i < length) {
            if (Platform.getByte(leftBase, leftOffset + (long)i) != Platform.getByte(rightBase, rightOffset + (long)i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void throwException(Throwable t) {
        UNSAFE.throwException(t);
    }

    public static <T> T newInstance(Class<T> type) {
        try {
            return type.cast(UNSAFE.allocateInstance(type));
        }
        catch (InstantiationException e) {
            Platform.throwException(e);
            throw new IllegalStateException("unreachable");
        }
    }

    public static long getAddress(ByteBuffer buffer) {
        long offHeapAddress;
        Preconditions.checkNotNull(buffer, "buffer is null");
        Preconditions.checkArgument(buffer.isDirect(), "Can't get address of a non-direct ByteBuffer.");
        try {
            offHeapAddress = UNSAFE.getLong(buffer, BUFFER_ADDRESS_FIELD_OFFSET);
        }
        catch (Throwable t) {
            throw new Error("Could not access direct byte buffer address field.", t);
        }
        return offHeapAddress;
    }

    public static ByteBuffer createDirectByteBufferFromNativeAddress(long address, int size) {
        try {
            ByteBuffer buffer = localBuffer.duplicate();
            UNSAFE.putLong(buffer, BUFFER_ADDRESS_FIELD_OFFSET, address);
            UNSAFE.putInt(buffer, BUFFER_CAPACITY_FIELD_OFFSET, size);
            buffer.clear();
            return buffer;
        }
        catch (Throwable t) {
            throw new Error("Failed to wrap unsafe off-heap memory with ByteBuffer", t);
        }
    }

    public static void wrapDirectByteBufferFromNativeAddress(ByteBuffer buffer, long address, int size) {
        Preconditions.checkArgument(buffer.isDirect(), "Can't wrap native memory into a non-direct ByteBuffer.");
        UNSAFE.putLong(buffer, BUFFER_ADDRESS_FIELD_OFFSET, address);
        UNSAFE.putInt(buffer, BUFFER_CAPACITY_FIELD_OFFSET, size);
        buffer.clear();
    }

    public static ByteBuffer wrapDirectBuffer(long address, int size) {
        return Platform.createDirectByteBufferFromNativeAddress(address, size);
    }

    public static void wrapDirectBuffer(ByteBuffer buffer, long address, int size) {
        UNSAFE.putLong(buffer, BUFFER_ADDRESS_FIELD_OFFSET, address);
        UNSAFE.putInt(buffer, BUFFER_CAPACITY_FIELD_OFFSET, size);
        buffer.clear();
    }

    public static void clearBuffer(Buffer buffer) {
        buffer.clear();
    }

    public static void flipBuffer(Buffer buffer) {
        buffer.flip();
    }

    public static void rewind(Buffer buffer) {
        buffer.rewind();
    }

    static {
        boolean unalign;
        UNSAFE = _JDKAccess.UNSAFE;
        JAVA_VERSION = _JDKAccess.JAVA_VERSION;
        IS_LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
        BOOLEAN_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(boolean[].class);
        BYTE_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
        CHAR_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(char[].class);
        SHORT_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(short[].class);
        INT_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(int[].class);
        LONG_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(long[].class);
        FLOAT_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(float[].class);
        DOUBLE_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(double[].class);
        String arch = System.getProperty("os.arch", "");
        if (arch.equals("ppc64le") || arch.equals("ppc64") || arch.equals("s390x")) {
            unalign = true;
        } else {
            try {
                Class<?> bitsClass = Class.forName("java.nio.Bits", false, ClassLoader.getSystemClassLoader());
                if (JAVA_VERSION >= 9) {
                    Field unalignedField = bitsClass.getDeclaredField(JAVA_VERSION >= 11 ? "UNALIGNED" : "unaligned");
                    unalign = UNSAFE.getBoolean(UNSAFE.staticFieldBase(unalignedField), UNSAFE.staticFieldOffset(unalignedField));
                } else {
                    Method unalignedMethod = bitsClass.getDeclaredMethod("unaligned", new Class[0]);
                    unalignedMethod.setAccessible(true);
                    unalign = Boolean.TRUE.equals(unalignedMethod.invoke(null, new Object[0]));
                }
            }
            catch (Throwable t) {
                unalign = arch.matches("^(i[3-6]86|x86(_64)?|x64|amd64|aarch64)$");
            }
        }
        unaligned = unalign;
        try {
            Field addressField = Buffer.class.getDeclaredField("address");
            BUFFER_ADDRESS_FIELD_OFFSET = UNSAFE.objectFieldOffset(addressField);
            Preconditions.checkArgument(BUFFER_ADDRESS_FIELD_OFFSET != 0L);
            Field capacityField = Buffer.class.getDeclaredField("capacity");
            BUFFER_CAPACITY_FIELD_OFFSET = UNSAFE.objectFieldOffset(capacityField);
            Preconditions.checkArgument(BUFFER_CAPACITY_FIELD_OFFSET != 0L);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
        localBuffer = ByteBuffer.allocateDirect(0);
    }
}

