/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.net.netty.server;

import cn.fyupeng.protocol.RpcResponse;
import cn.fyupeng.serializer.CommonSerializer;
import cn.hutool.core.bean.BeanUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseParser
extends MessageToMessageEncoder<RpcResponse> {
    private static final Logger log = LoggerFactory.getLogger(ResponseParser.class);
    private CommonSerializer serializer;

    public ResponseParser(CommonSerializer serializer) {
        this.serializer = serializer;
    }

    protected void encode(ChannelHandlerContext channelHandlerContext, RpcResponse rpcResponse, List<Object> list) throws Exception {
        RpcResponse resp = (RpcResponse)BeanUtil.toBean((Object)rpcResponse, RpcResponse.class);
        resp.setDataType(rpcResponse.getDataType());
        list.add(resp);
    }

    private String adaptDataType(String dataType) throws ClassNotFoundException {
        String adaptDataType = "";
        if (CommonSerializer.SJSON_SERIALIZER.intValue() == this.serializer.getCode()) {
            Class<?> paramTypeClazz = Class.forName(dataType);
            if (String.class.equals(paramTypeClazz)) {
                adaptDataType = "string";
            } else if (Float.class.equals(paramTypeClazz) || Float.TYPE.equals(paramTypeClazz)) {
                adaptDataType = "float32";
            } else if (Double.class.equals(paramTypeClazz) || Double.TYPE.equals(paramTypeClazz)) {
                adaptDataType = "float64";
            } else if (Integer.class.equals(paramTypeClazz) || Integer.TYPE.equals(paramTypeClazz)) {
                adaptDataType = "int";
            }
            return adaptDataType;
        }
        return dataType;
    }
}

