/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.proxy;

import cn.fyupeng.annotation.Reference;
import cn.fyupeng.config.AbstractRedisConfiguration;
import cn.fyupeng.config.Configuration;
import cn.fyupeng.exception.AsyncTimeUnreasonableException;
import cn.fyupeng.exception.RetryTimeoutException;
import cn.fyupeng.factory.SingleFactory;
import cn.fyupeng.hook.ClientShutdownHook;
import cn.fyupeng.idworker.Sid;
import cn.fyupeng.idworker.WorkerIdServer;
import cn.fyupeng.net.RpcClient;
import cn.fyupeng.net.netty.client.NettyClient;
import cn.fyupeng.net.netty.client.UnprocessedResults;
import cn.fyupeng.net.socket.client.SocketClient;
import cn.fyupeng.protocol.RpcMessageChecker;
import cn.fyupeng.protocol.RpcRequest;
import cn.fyupeng.protocol.RpcResponse;
import cn.fyupeng.proxy.factory.javassist.JavassistProxyFactory;
import cn.fyupeng.proxy.factory.jdk.JdkProxyFactory;
import cn.fyupeng.serializer.HessianSerializer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcClientProxy {
    private static final Logger log = LoggerFactory.getLogger(RpcClientProxy.class);
    private RpcClient rpcClient;
    private Class<?> pareClazz = null;
    private static UnprocessedResults unprocessedRequests = (UnprocessedResults)SingleFactory.getInstance(UnprocessedResults.class);
    private static JdkProxyFactory jdkProxyFactory = new JdkProxyFactory();
    private static JavassistProxyFactory javassistProxyFactory = new JavassistProxyFactory();

    public RpcClientProxy(RpcClient rpcClient) {
        this.rpcClient = rpcClient;
        ClientShutdownHook.getShutdownHook().addClient(rpcClient).addClearAllHook();
    }

    public <T> T getProxy(Class<T> clazz, Class<?> pareClazz) {
        this.pareClazz = pareClazz;
        return jdkProxyFactory.getProxy(clazz, (Object proxy, Method method, Object[] args) -> this.invoke0(proxy, method, args));
    }

    public <T> T getJavassistProxy(Class<T> clazz, Class<?> pareClazz) {
        this.pareClazz = pareClazz;
        T javassistProxy = null;
        try {
            javassistProxy = javassistProxyFactory.getProxy(clazz, (Object proxy, Method method, Object[] args) -> this.invoke0(proxy, method, args));
        }
        catch (Throwable e) {
            log.error("javassist dynamic proxy exception: ", e);
        }
        return javassistProxy;
    }

    @Deprecated
    public <T> T getProxy(Class<T> clazz) {
        return jdkProxyFactory.getProxy(clazz, (Object proxy, Method method, Object[] args) -> this.invoke0(proxy, method, args));
    }

    public Object invoke0(Object proxy, Method method, Object[] args) throws Throwable {
        return this.invoke(proxy, method, args);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        RpcRequest rpcRequest = new RpcRequest.Builder().requestId(Sid.next()).interfaceName(method.getDeclaringClass().getName()).methodName(method.getName()).parameters(args).paramTypes((String[])Arrays.stream(method.getParameterTypes()).map(Class::getName).toArray(String[]::new)).returnType(method.getReturnType().getCanonicalName()).heartBeat(Boolean.FALSE).reSend(Boolean.FALSE).build();
        HessianSerializer hessianSerializer = new HessianSerializer();
        byte[] data = hessianSerializer.serialize((Object)rpcRequest);
        Object obj = hessianSerializer.deserialize(data, RpcRequest.class);
        System.out.println(obj);
        System.out.println(rpcRequest);
        RpcResponse rpcResponse = null;
        if (this.rpcClient instanceof SocketClient) {
            rpcResponse = this.revokeSocketClient(rpcRequest, method);
        } else if (this.rpcClient instanceof NettyClient) {
            rpcResponse = this.revokeNettyClient(rpcRequest, method);
        }
        return rpcResponse == null ? null : rpcResponse.getData();
    }

    private RpcResponse revokeNettyClient(RpcRequest rpcRequest, Method method) throws Throwable {
        Field[] fields;
        RpcResponse rpcResponse = null;
        if (this.pareClazz == null) {
            CompletableFuture completableFuture = (CompletableFuture)this.rpcClient.sendRequest(rpcRequest);
            rpcResponse = (RpcResponse)completableFuture.get();
            RpcMessageChecker.checkAndThrow((RpcRequest)rpcRequest, (RpcResponse)rpcResponse);
            return rpcResponse;
        }
        long timeout = 0L;
        long asyncTime = 0L;
        int retries = 0;
        int giveTime = 0;
        boolean useRetry = false;
        for (Field field : fields = this.pareClazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Reference.class) || !method.getDeclaringClass().getName().equals(field.getType().getName())) continue;
            retries = field.getAnnotation(Reference.class).retries();
            giveTime = field.getAnnotation(Reference.class).giveTime();
            timeout = field.getAnnotation(Reference.class).timeout();
            asyncTime = field.getAnnotation(Reference.class).asyncTime();
            useRetry = true;
            String name = field.getAnnotation(Reference.class).name();
            String group = field.getAnnotation(Reference.class).group();
            if (!"".equals(name)) {
                rpcRequest.setInterfaceName(name);
            }
            if ("".equals(group)) break;
            rpcRequest.setGroup(group);
            break;
        }
        if (useRetry && asyncTime > 0L && giveTime > 0) {
            log.debug("discover @Reference and asyncTime > 0, will use blocking mode");
            if (timeout >= asyncTime) {
                log.error("asyncTime [ {} ] should be greater than timeout [ {} ]", (Object)asyncTime, (Object)timeout);
                throw new AsyncTimeUnreasonableException("Asynchronous time is unreasonable, it should greater than timeout");
            }
            long handleTime = 0L;
            boolean checkPass = false;
            for (int i = 0; i < retries; ++i) {
                if (handleTime >= timeout) {
                    TimeUnit.SECONDS.sleep(giveTime);
                    rpcRequest.setReSend(Boolean.TRUE);
                    log.warn("call service timeout and retry to call [ rms: {}, tms: {} ]", (Object)handleTime, (Object)timeout);
                }
                long startTime = System.currentTimeMillis();
                log.info("start calling remote service [requestId: {}, serviceMethod: {}]", (Object)rpcRequest.getRequestId(), (Object)rpcRequest.getMethodName());
                CompletableFuture completableFuture = (CompletableFuture)this.rpcClient.sendRequest(rpcRequest);
                try {
                    rpcResponse = (RpcResponse)completableFuture.get(asyncTime, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    log.warn("recommend that asyncTime [ {} ] should be greater than current task runeTime [ {} ]", (Object)asyncTime, (Object)(System.currentTimeMillis() - startTime));
                    continue;
                }
                long endTime = System.currentTimeMillis();
                handleTime = endTime - startTime;
                if (handleTime >= timeout || !(checkPass = RpcMessageChecker.check((RpcRequest)rpcRequest, (RpcResponse)rpcResponse))) continue;
                log.info("client call success [ rms: {}, tms: {} ]", (Object)handleTime, (Object)timeout);
                return rpcResponse;
            }
            log.info("client call failed  [ rms: {}, tms: {} ]", (Object)handleTime, (Object)timeout);
            unprocessedRequests.remove(rpcRequest.getRequestId());
            throw new RetryTimeoutException("The retry call timeout exceeds the threshold, the channel is closed, the thread is interrupted, and an exception is forced to be thrown!");
        }
        log.debug("discover @Reference or asyncTime <= 0, will use blocking mode");
        long startTime = System.currentTimeMillis();
        log.info("start calling remote service [requestId: {}, serviceMethod: {}]", (Object)rpcRequest.getRequestId(), (Object)rpcRequest.getMethodName());
        CompletableFuture completableFuture = (CompletableFuture)this.rpcClient.sendRequest(rpcRequest);
        rpcResponse = (RpcResponse)completableFuture.get();
        long endTime = System.currentTimeMillis();
        log.info("handling the task takes time {} ms", (Object)(endTime - startTime));
        RpcMessageChecker.checkAndThrow((RpcRequest)rpcRequest, (RpcResponse)rpcResponse);
        return rpcResponse;
    }

    private RpcResponse revokeSocketClient(RpcRequest rpcRequest, Method method) throws Throwable {
        RpcResponse rpcResponse = null;
        if (this.pareClazz != null) {
            Field[] fields;
            for (Field field : fields = this.pareClazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Reference.class) || !method.getDeclaringClass().getName().equals(field.getType().getName())) continue;
                String name = field.getAnnotation(Reference.class).name();
                String group = field.getAnnotation(Reference.class).group();
                if (!"".equals(name)) {
                    rpcRequest.setInterfaceName(name);
                }
                if ("".equals(group)) break;
                rpcRequest.setGroup(group);
                break;
            }
        }
        rpcResponse = (RpcResponse)this.rpcClient.sendRequest(rpcRequest);
        RpcMessageChecker.checkAndThrow((RpcRequest)rpcRequest, (RpcResponse)rpcResponse);
        return rpcResponse;
    }

    private static void configWorkerServer() {
        WorkerIdServer.preLoad();
    }

    static {
        AbstractRedisConfiguration.getClientConfig();
        RpcClientProxy.configWorkerServer();
        ServiceLoader.load(Configuration.class).iterator().next();
    }
}

