/*
 * Decompiled with CFR 0.152.
 */
package cn.gmlee.tools.third.party.alibaba.kit;

import cn.gmlee.tools.base.util.BoolUtil;
import cn.gmlee.tools.third.party.alibaba.config.AliPayConfiguration;
import cn.gmlee.tools.third.party.alibaba.model.req.AliPayAppRequest;
import cn.gmlee.tools.third.party.alibaba.model.req.AliPayH5Request;
import cn.gmlee.tools.third.party.alibaba.model.req.AliPayNativeRequest;
import cn.gmlee.tools.third.party.alibaba.model.req.AliPayRequest;
import cn.gmlee.tools.third.party.alibaba.model.req.AliPayResultQueryRequest;
import cn.gmlee.tools.third.party.alibaba.model.req.AliRefundRequest;
import cn.gmlee.tools.third.party.alibaba.model.req.AliRefundResultQueryRequest;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.domain.AlipayTradeAppPayModel;
import com.alipay.api.domain.AlipayTradeFastpayRefundQueryModel;
import com.alipay.api.domain.AlipayTradePagePayModel;
import com.alipay.api.domain.AlipayTradeQueryModel;
import com.alipay.api.domain.AlipayTradeRefundModel;
import com.alipay.api.domain.AlipayTradeWapPayModel;
import com.alipay.api.request.AlipayTradeAppPayRequest;
import com.alipay.api.request.AlipayTradeFastpayRefundQueryRequest;
import com.alipay.api.request.AlipayTradePagePayRequest;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.alipay.api.response.AlipayTradeAppPayResponse;
import com.alipay.api.response.AlipayTradeFastpayRefundQueryResponse;
import com.alipay.api.response.AlipayTradePagePayResponse;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.alipay.api.response.AlipayTradeRefundResponse;
import com.alipay.api.response.AlipayTradeWapPayResponse;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;

public class AliPayKit {
    public static AlipayTradeQueryResponse orderQuery(AliPayConfiguration aliPayConfiguration, AliPayResultQueryRequest aliPayResultQueryRequest) throws Exception {
        DefaultAlipayClient client = new DefaultAlipayClient(aliPayConfiguration.getUrl(), aliPayConfiguration.getAppId(), aliPayConfiguration.getRsaPrivateKey(), "json", "UTF-8", aliPayConfiguration.getAliPayPublicKey(), aliPayConfiguration.getSignType());
        AlipayTradeQueryRequest request = new AlipayTradeQueryRequest();
        request.setBizModel(AliPayKit.getAlipayTradeQueryModel(aliPayConfiguration, aliPayResultQueryRequest));
        request.setNotifyUrl(aliPayConfiguration.getNotifyUrl());
        request.setReturnUrl(aliPayConfiguration.getReturnUrl());
        return (AlipayTradeQueryResponse)client.pageExecute((AlipayRequest)request);
    }

    public static AlipayTradeFastpayRefundQueryResponse refundQuery(AliPayConfiguration aliPayConfiguration, AliRefundResultQueryRequest aliRefundResultQueryRequest) throws Exception {
        DefaultAlipayClient client = new DefaultAlipayClient(aliPayConfiguration.getUrl(), aliPayConfiguration.getAppId(), aliPayConfiguration.getRsaPrivateKey(), "json", "UTF-8", aliPayConfiguration.getAliPayPublicKey(), aliPayConfiguration.getSignType());
        AlipayTradeFastpayRefundQueryRequest request = new AlipayTradeFastpayRefundQueryRequest();
        request.setBizModel((AlipayObject)AliPayKit.getAlipayTradeFastPayRefundQueryModel(aliPayConfiguration, aliRefundResultQueryRequest));
        request.setNotifyUrl(aliPayConfiguration.getNotifyUrl());
        request.setReturnUrl(aliPayConfiguration.getReturnUrl());
        return (AlipayTradeFastpayRefundQueryResponse)client.execute((AlipayRequest)request);
    }

    public static AlipayTradeWapPayResponse execute(AliPayConfiguration aliPayConfiguration, AliPayH5Request aliPayH5Request) throws Exception {
        DefaultAlipayClient client = new DefaultAlipayClient(aliPayConfiguration.getUrl(), aliPayConfiguration.getAppId(), aliPayConfiguration.getRsaPrivateKey(), "json", "UTF-8", aliPayConfiguration.getAliPayPublicKey(), aliPayConfiguration.getSignType());
        AlipayTradeWapPayRequest request = new AlipayTradeWapPayRequest();
        request.setBizModel((AlipayObject)AliPayKit.getAlipayTradeWapPayModel(aliPayConfiguration, aliPayH5Request));
        request.setNotifyUrl(aliPayConfiguration.getNotifyUrl());
        request.setReturnUrl(aliPayConfiguration.getReturnUrl());
        return (AlipayTradeWapPayResponse)client.pageExecute((AlipayRequest)request);
    }

    public static AlipayTradePagePayResponse execute(AliPayConfiguration aliPayConfiguration, AliPayNativeRequest aliPayNativeRequest) throws Exception {
        DefaultAlipayClient client = new DefaultAlipayClient(aliPayConfiguration.getUrl(), aliPayConfiguration.getAppId(), aliPayConfiguration.getRsaPrivateKey(), "json", "UTF-8", aliPayConfiguration.getAliPayPublicKey(), aliPayConfiguration.getSignType());
        AlipayTradePagePayRequest request = new AlipayTradePagePayRequest();
        request.setBizModel((AlipayObject)AliPayKit.getAlipayTradePagePayModel(aliPayConfiguration, aliPayNativeRequest));
        request.setNotifyUrl(aliPayConfiguration.getNotifyUrl());
        request.setReturnUrl(aliPayConfiguration.getReturnUrl());
        return (AlipayTradePagePayResponse)client.pageExecute((AlipayRequest)request);
    }

    public static AlipayTradeAppPayResponse execute(AliPayConfiguration aliPayConfiguration, AliPayAppRequest aliPayAppRequest) throws Exception {
        DefaultAlipayClient client = new DefaultAlipayClient(aliPayConfiguration.getUrl(), aliPayConfiguration.getAppId(), aliPayConfiguration.getRsaPrivateKey(), "json", "UTF-8", aliPayConfiguration.getAliPayPublicKey(), aliPayConfiguration.getSignType());
        AlipayTradeAppPayRequest request = new AlipayTradeAppPayRequest();
        request.setBizModel((AlipayObject)AliPayKit.getAlipayTradeAppPayModel(aliPayConfiguration, aliPayAppRequest));
        request.setNotifyUrl(aliPayConfiguration.getNotifyUrl());
        request.setReturnUrl(aliPayConfiguration.getReturnUrl());
        return (AlipayTradeAppPayResponse)client.pageExecute((AlipayRequest)request);
    }

    public static AlipayTradeRefundResponse execute(AliPayConfiguration aliPayConfiguration, AliRefundRequest aliRefundRequest) throws Exception {
        DefaultAlipayClient client = new DefaultAlipayClient(aliPayConfiguration.getUrl(), aliPayConfiguration.getAppId(), aliPayConfiguration.getRsaPrivateKey(), "json", "UTF-8", aliPayConfiguration.getAliPayPublicKey(), aliPayConfiguration.getSignType());
        AlipayTradeRefundRequest request = new AlipayTradeRefundRequest();
        request.setBizModel((AlipayObject)AliPayKit.getAlipayTradeRefundModel(aliPayConfiguration, aliRefundRequest));
        request.setNotifyUrl(aliPayConfiguration.getNotifyUrl());
        request.setReturnUrl(aliPayConfiguration.getReturnUrl());
        return (AlipayTradeRefundResponse)client.execute((AlipayRequest)request);
    }

    private static AlipayObject getAlipayTradeQueryModel(AliPayConfiguration aliPayConfiguration, AliPayResultQueryRequest aliPayResultQueryRequest) {
        AlipayTradeQueryModel model = new AlipayTradeQueryModel();
        model.setOutTradeNo(aliPayResultQueryRequest.getOutTradeNo());
        return model;
    }

    private static AlipayTradeWapPayModel getAlipayTradeWapPayModel(AliPayConfiguration aliPayConfiguration, AliPayRequest aliPayRequest) throws UnsupportedEncodingException {
        AlipayTradeWapPayModel model = new AlipayTradeWapPayModel();
        model.setOutTradeNo(aliPayRequest.getOutTradeNo());
        model.setSubject(aliPayRequest.getSubject());
        BigDecimal totalAmount = new BigDecimal(aliPayRequest.getMoney()).divide(new BigDecimal(100));
        model.setTotalAmount(totalAmount.setScale(2, RoundingMode.CEILING).toString());
        model.setProductCode(aliPayConfiguration.getProductCode());
        model.setBody(aliPayRequest.getBody());
        model.setTimeoutExpress(aliPayConfiguration.getTimeoutExpress().toString());
        model.setPassbackParams(URLEncoder.encode(aliPayRequest.getParams(), "UTF-8"));
        return model;
    }

    private static AlipayTradePagePayModel getAlipayTradePagePayModel(AliPayConfiguration aliPayConfiguration, AliPayRequest aliPayRequest) throws UnsupportedEncodingException {
        AlipayTradePagePayModel model = new AlipayTradePagePayModel();
        model.setOutTradeNo(aliPayRequest.getOutTradeNo());
        model.setSubject(aliPayRequest.getSubject());
        BigDecimal totalAmount = new BigDecimal(aliPayRequest.getMoney()).divide(new BigDecimal(100));
        model.setTotalAmount(totalAmount.setScale(2, RoundingMode.CEILING).toString());
        model.setProductCode(aliPayConfiguration.getProductCode());
        return model;
    }

    private static AlipayTradeAppPayModel getAlipayTradeAppPayModel(AliPayConfiguration aliPayConfiguration, AliPayRequest aliPayRequest) throws UnsupportedEncodingException {
        AlipayTradeAppPayModel model = new AlipayTradeAppPayModel();
        model.setOutTradeNo(aliPayRequest.getOutTradeNo());
        model.setSubject(aliPayRequest.getSubject());
        BigDecimal totalAmount = new BigDecimal(aliPayRequest.getMoney()).divide(new BigDecimal(100));
        model.setTotalAmount(totalAmount.setScale(2, RoundingMode.CEILING).toString());
        model.setProductCode("QUICK_MSECURITY_PAY");
        return model;
    }

    private static AlipayTradeRefundModel getAlipayTradeRefundModel(AliPayConfiguration aliPayConfiguration, AliRefundRequest aliRefundRequest) throws UnsupportedEncodingException {
        AlipayTradeRefundModel model = new AlipayTradeRefundModel();
        model.setOutRequestNo(aliRefundRequest.getOutRefundNo());
        model.setOutTradeNo(aliRefundRequest.getOutTradeNo());
        BigDecimal refundAmount = new BigDecimal(aliRefundRequest.getRefundAmount()).divide(new BigDecimal(100));
        model.setRefundAmount(refundAmount.setScale(2, RoundingMode.CEILING).toString());
        model.setRefundReason(aliRefundRequest.getRefundReason());
        return model;
    }

    private static AlipayTradeFastpayRefundQueryModel getAlipayTradeFastPayRefundQueryModel(AliPayConfiguration aliPayConfiguration, AliRefundResultQueryRequest aliRefundResultQueryRequest) {
        AlipayTradeFastpayRefundQueryModel model = new AlipayTradeFastpayRefundQueryModel();
        model.setOutTradeNo(aliRefundResultQueryRequest.getOutTradeNo());
        model.setOutRequestNo(aliRefundResultQueryRequest.getOutRefundNo());
        if (BoolUtil.isEmpty((CharSequence)aliRefundResultQueryRequest.getOutRefundNo())) {
            model.setOutRequestNo(aliRefundResultQueryRequest.getOutTradeNo());
        }
        return model;
    }
}

