/*
 * Decompiled with CFR 0.152.
 */
package cn.gmlee.tools.es.dao;

import cn.gmlee.tools.base.mod.PageResponse;
import cn.gmlee.tools.base.util.BeanUtil;
import java.util.Collection;
import java.util.Map;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.repository.ElasticsearchRepository;

public interface BaseRepository<T, ID>
extends ElasticsearchRepository<T, ID> {
    default public void update(T t) {
    }

    default public void updateById(T t) {
        this.save(t);
    }

    default public void updateBatchById(Collection<T> ts) {
        this.saveAll(ts);
    }

    default public PageResponse<T> selectPage(T t, cn.gmlee.tools.base.mod.PageRequest request, Sort.Order ... orders) {
        QueryBuilder all = this.getQueryBuilder(t);
        Page page = this.search(all, (Pageable)PageRequest.of((int)request.current, (int)request.size, (Sort)Sort.by((Sort.Order[])orders)));
        return new PageResponse(request, Long.valueOf(page.getTotalElements()), (Collection)page.getContent());
    }

    default public QueryBuilder getQueryBuilder(T t) {
        Map map = (Map)BeanUtil.convert(t, Map.class);
        BoolQueryBuilder all = QueryBuilders.boolQuery();
        for (Map.Entry next : map.entrySet()) {
            String key = (String)next.getKey();
            Object value = next.getValue();
            all.must((QueryBuilder)QueryBuilders.termQuery((String)key, value));
        }
        return all;
    }
}

