/*
 * Decompiled with CFR 0.152.
 */
package cn.gmlee.tools.jackson.assist;

import cn.gmlee.tools.base.util.QuickUtil;
import cn.gmlee.tools.jackson.assist.TimeJsonDeserializer;
import cn.gmlee.tools.jackson.config.JacksonModuleProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.DateSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;

public class JacksonAssist {
    public static void registerAllModule(ObjectMapper objectMapper, JacksonModuleProperties module) {
        JacksonAssist.registerTimeModule(objectMapper, module);
        JacksonAssist.registerConvertModule(objectMapper, module);
        JacksonAssist.registerDisableModule(objectMapper, module);
        JacksonAssist.registerAllowModule(objectMapper, module);
        JacksonAssist.registerIgnoreModule(objectMapper, module);
        JacksonAssist.registerEnableModule(objectMapper, module);
    }

    public static void registerTimeModule(ObjectMapper objectMapper, JacksonModuleProperties module) {
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        SimpleModule timeModule = new SimpleModule();
        timeModule.addSerializer(LocalDateTime.class, (JsonSerializer)LocalDateTimeSerializer.INSTANCE);
        timeModule.addSerializer(LocalDate.class, (JsonSerializer)LocalDateSerializer.INSTANCE);
        timeModule.addSerializer(LocalTime.class, (JsonSerializer)LocalTimeSerializer.INSTANCE);
        timeModule.addSerializer(Date.class, (JsonSerializer)DateSerializer.instance);
        timeModule.addDeserializer(Date.class, TimeJsonDeserializer.instance);
        objectMapper.registerModule((Module)timeModule);
    }

    public static void registerConvertModule(ObjectMapper objectMapper, JacksonModuleProperties module) {
        SimpleModule typeModule = new SimpleModule();
        QuickUtil.isTrue((Boolean)module.getLongToString(), () -> typeModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance));
        objectMapper.registerModule((Module)typeModule);
    }

    public static void registerDisableModule(ObjectMapper objectMapper, JacksonModuleProperties module) {
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public static void registerAllowModule(ObjectMapper objectMapper, JacksonModuleProperties module) {
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
    }

    public static void registerIgnoreModule(ObjectMapper objectMapper, JacksonModuleProperties module) {
        objectMapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        objectMapper.configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true);
    }

    public static void registerEnableModule(ObjectMapper objectMapper, JacksonModuleProperties module) {
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
    }
}

