/*
 * Decompiled with CFR 0.152.
 */
package cn.gmlee.tools.jackson.assist;

import cn.gmlee.tools.base.util.BoolUtil;
import cn.gmlee.tools.base.util.TimeUtil;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;

public class TimeJsonDeserializer
extends JsonDeserializer<Date> {
    public static JsonDeserializer<? extends Date> instance = new TimeJsonDeserializer();

    public Date deserialize(JsonParser p, DeserializationContext txt) throws IOException, JsonProcessingException {
        String text = p.getText();
        if (BoolUtil.isEmpty((CharSequence)text)) {
            return null;
        }
        try {
            DeserializationConfig config = txt.getConfig();
            DateFormat dateFormat = config.getDateFormat();
            return dateFormat.parse(text);
        }
        catch (Exception e) {
            return TimeUtil.parseTime((String)text);
        }
    }
}

