/*
 * Decompiled with CFR 0.152.
 */
package cn.gmlee.tools.jackson.config;

import cn.gmlee.tools.base.enums.XTime;
import cn.gmlee.tools.base.util.BoolUtil;
import cn.gmlee.tools.base.util.QuickUtil;
import cn.gmlee.tools.jackson.assist.JacksonAssist;
import cn.gmlee.tools.jackson.config.JacksonModuleProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jackson.JacksonProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.AbstractJackson2HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ConditionalOnClass(value={WebMvcConfigurer.class})
@EnableConfigurationProperties(value={JacksonModuleProperties.class, JacksonProperties.class})
public class JacksonWebMvcConfigurer
implements WebMvcConfigurer {
    @Resource
    private JacksonProperties jacksonProperties;
    @Resource
    private JacksonModuleProperties jacksonModuleProperties;

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.forEach(x -> {
            if (x instanceof AbstractJackson2HttpMessageConverter) {
                ObjectMapper objectMapper = ((AbstractJackson2HttpMessageConverter)x).getObjectMapper();
                JacksonWebMvcConfigurer.autoInjectSpringOriginal(objectMapper, this.jacksonProperties);
                JacksonAssist.registerAllModule(objectMapper, this.jacksonModuleProperties);
            }
        });
    }

    private static void autoInjectSpringOriginal(ObjectMapper objectMapper, JacksonProperties jacksonProperties) {
        QuickUtil.notNull((Object)jacksonProperties.getTimeZone(), x -> objectMapper.setTimeZone(x));
        QuickUtil.is((Boolean)BoolUtil.notEmpty((CharSequence)jacksonProperties.getDateFormat()), () -> objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(jacksonProperties.getDateFormat())), () -> objectMapper.setDateFormat((DateFormat)XTime.MS_MINUS_BLANK_COLON_DOT.dateFormat));
    }
}

