/*
 * Decompiled with CFR 0.152.
 */
package cn.gmlee.tools.seata.config;

import cn.gmlee.tools.base.enums.XCode;
import cn.gmlee.tools.base.ex.SkillException;
import cn.gmlee.tools.ds.assist.DatasourceAssist;
import cn.gmlee.tools.ds.config.dynamic.DynamicDataSourceProperties;
import cn.gmlee.tools.ds.config.dynamic.DynamicDatasourceAutoConfiguration;
import cn.gmlee.tools.ds.dynamic.DynamicDataSource;
import cn.gmlee.tools.ds.dynamic.DynamicDataSourceHolder;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import io.seata.rm.datasource.DataSourceProxy;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={DynamicDataSourceProperties.class})
@ConditionalOnClass(value={DynamicDatasourceAutoConfiguration.OverrideDataSourceConfiguration.class, MybatisSqlSessionFactoryBean.class, DataSourceProxy.class})
public class SeataDynamicDataSourceConfiguration
implements DynamicDatasourceAutoConfiguration.OverrideDataSourceConfiguration {
    @Bean(value={"dynamicDataSource"})
    public DataSource dataSource(DynamicDataSourceProperties dynamicDataSourceProperties) {
        Map dsMap = dynamicDataSourceProperties.getDatasource();
        if (!dsMap.isEmpty()) {
            HashMap targetDataSource = new HashMap(dsMap.size());
            dsMap.forEach((name, map) -> {
                MapConfigurationPropertySource source = new MapConfigurationPropertySource(map);
                Binder binder = new Binder(new ConfigurationPropertySource[]{source});
                DataSource targetDs = (DataSource)binder.bind(ConfigurationPropertyName.EMPTY, Bindable.of((Class)DatasourceAssist.getDatasourceType((Map)map))).get();
                targetDataSource.put(name, new DataSourceProxy(targetDs));
                DynamicDataSourceHolder.addDatasourceKeys((String)name);
            });
            DynamicDataSource dynamicDataSource = new DynamicDataSource();
            dynamicDataSource.setTargetDataSources(targetDataSource);
            return dynamicDataSource;
        }
        throw new SkillException(Integer.valueOf(XCode.THIRD_PARTY3000.code), "\u81f3\u5c11\u9700\u8981 1 \u4e2a\u6570\u636e\u6e90");
    }
}

