package cn.godmao.common;

import java.util.concurrent.Executor;

public interface IExecute<E extends Executor> extends IRun<IRunnable> {
    void execute(IRunnable command);

    default void execute(E executor, IRunnable runnable) {
        if (null == executor) {
            run(runnable);
        } else {
            executor.execute(() -> run(runnable));
        }
    }
}
