/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.pay;

import cn.godmao.pay.WeChatPay;
import com.github.wxpay.sdk.WXPayConstants;
import com.github.wxpay.sdk.WXPayUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;

public class WeChatPayService {
    private static final DecimalFormat df = new DecimalFormat("#");

    public static Map<String, Object> Unifiedorder(WeChatPay weChatPay) throws Exception {
        HashMap<String, Object> ResultMap = new HashMap<String, Object>();
        TreeMap<String, String> req = new TreeMap<String, String>();
        req.put("appid", weChatPay.getAppid());
        req.put("mch_id", weChatPay.getMch_id());
        req.put("body", weChatPay.getBody());
        req.put("out_trade_no", weChatPay.getOut_trade_no());
        req.put("total_fee", df.format(Double.parseDouble(weChatPay.getTotal_fee()) * 100.0));
        req.put("spbill_create_ip", weChatPay.getSpbill_create_ip());
        req.put("notify_url", weChatPay.getNotify_url());
        req.put("trade_type", weChatPay.getTrade_type());
        req.put("attach", weChatPay.getAttach());
        if (null == weChatPay.getNonce_str() || weChatPay.getNonce_str().isEmpty()) {
            weChatPay.setNonce_str(UUID.randomUUID().toString().replaceAll("-", "").substring(0, 32));
        }
        req.put("nonce_str", weChatPay.getNonce_str());
        if (null != weChatPay.getSub_mch_id() && !weChatPay.getSub_mch_id().isEmpty()) {
            req.put("sub_mch_id", weChatPay.getSub_mch_id());
        }
        if (null != weChatPay.getTime_expire() && !weChatPay.getTime_expire().isEmpty()) {
            req.put("time_expire", weChatPay.getTime_expire());
        }
        if (null != weChatPay.getOpenid() && !weChatPay.getOpenid().isEmpty()) {
            req.put("openid", weChatPay.getOpenid());
        }
        req.put("sign", WXPayUtil.generateSignature(req, (String)weChatPay.getApi_key(), (WXPayConstants.SignType)WXPayConstants.SignType.MD5));
        String xmlBody = WXPayUtil.generateSignedXml(req, (String)weChatPay.getApi_key());
        System.err.println(String.format("\u5fae\u4fe1\u652f\u4ed8\u9884\u4e0b\u5355\u8bf7\u6c42 xml \u683c\u5f0f:\n%s", xmlBody));
        String result = null;
        URL url = new URL("https://api.mch.weixin.qq.com/pay/unifiedorder");
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("content-type", "application/x-www-form-urlencoded");
        if (null != xmlBody) {
            OutputStream outputStream = conn.getOutputStream();
            outputStream.write(xmlBody.getBytes(StandardCharsets.UTF_8));
            outputStream.close();
        }
        InputStream inputStream = conn.getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String str = null;
        StringBuilder buffer = new StringBuilder();
        while ((str = bufferedReader.readLine()) != null) {
            buffer.append(str);
        }
        bufferedReader.close();
        inputStreamReader.close();
        inputStream.close();
        inputStream = null;
        conn.disconnect();
        result = buffer.toString();
        System.err.println(String.format("%s", result));
        Map WxResultMap = WXPayUtil.xmlToMap((String)result);
        String return_code = (String)WxResultMap.get("return_code");
        if (null != return_code && !return_code.isEmpty() && "SUCCESS".equals(return_code)) {
            if (((String)WxResultMap.get("result_code")).equals("SUCCESS")) {
                ResultMap.put("code", 0);
                ResultMap.put("msg", "\u9884\u4e0b\u5355\u6210\u529f");
                ResultMap.put("out_trade_no", weChatPay.getOut_trade_no());
                switch ((String)WxResultMap.get("trade_type")) {
                    case "NATIVE": {
                        ResultMap.put("QrCode", WxResultMap.get("code_url"));
                        break;
                    }
                    case "MWEB": {
                        ResultMap.put("mweb_url", WxResultMap.get("mweb_url"));
                        break;
                    }
                    case "JSAPI": {
                        ResultMap.put("prepay_id", WxResultMap.get("prepay_id"));
                    }
                }
            } else {
                ResultMap.put("code", 2);
                ResultMap.put("msg", WxResultMap.get("err_code_des"));
            }
        } else {
            ResultMap.put("code", 2);
            ResultMap.put("msg", WxResultMap.get("return_msg"));
        }
        return ResultMap;
    }
}

