package cn.godmao.pay.wechat;

import java.io.InputStream;

public class WXPayConfig implements com.github.wxpay.sdk.WXPayConfig {
    private String appID;

    private String mchID;

    private String key;

    private InputStream certStream;

    private int httpConnectTimeoutMs;

    private int httpReadTimeoutMs;

    public WXPayConfig(String appID, String mchID, String key) {
        this.appID = appID;
        this.mchID = mchID;
        this.key = key;
        this.certStream = null;
        this.httpConnectTimeoutMs = 1000;
        this.httpReadTimeoutMs = 1000;
    }

    public WXPayConfig(String appID, String mchID, String key, InputStream certStream, int httpConnectTimeoutMs, int httpReadTimeoutMs) {
        this.appID = appID;
        this.mchID = mchID;
        this.key = key;
        this.certStream = certStream;
        this.httpConnectTimeoutMs = httpConnectTimeoutMs;
        this.httpReadTimeoutMs = httpReadTimeoutMs;
    }

    @Override
    public String getAppID() {
        return appID;
    }

    public void setAppID(String appID) {
        this.appID = appID;
    }

    @Override
    public String getMchID() {
        return mchID;
    }

    public void setMchID(String mchID) {
        this.mchID = mchID;
    }

    @Override
    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public InputStream getCertStream() {
        return certStream;
    }

    public void setCertStream(InputStream certStream) {
        this.certStream = certStream;
    }

    @Override
    public int getHttpConnectTimeoutMs() {
        return httpConnectTimeoutMs;
    }

    public void setHttpConnectTimeoutMs(int httpConnectTimeoutMs) {
        this.httpConnectTimeoutMs = httpConnectTimeoutMs;
    }

    @Override
    public int getHttpReadTimeoutMs() {
        return httpReadTimeoutMs;
    }

    public void setHttpReadTimeoutMs(int httpReadTimeoutMs) {
        this.httpReadTimeoutMs = httpReadTimeoutMs;
    }
}
