/*
 * Decompiled with CFR 0.152.
 */
package cn.gomro.commons.log;

import cn.gomro.commons.utils.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FriendlyErrorLog {
    private static final Logger log = LoggerFactory.getLogger(FriendlyErrorLog.class);

    public FriendlyErrorLog() {
        String logOutPackage = System.getenv("LOG_OUT_PACKAGE");
        if (logOutPackage == null || logOutPackage.isEmpty()) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u73af\u5883\u53d8\u91cf LOG_OUT_PACKAGE");
        }
    }

    public static String error(Throwable e) {
        String stackTraceMessage = FriendlyErrorLog.getStackTraceMessage(e);
        log.error("\n\u5f02\u5e38\u4fe1\u606f: {}\n\u53d1\u751f\u5728: {}", (Object)e.getMessage(), (Object)stackTraceMessage);
        return stackTraceMessage;
    }

    public static String error(Throwable e, String ... param) {
        StringBuilder params = new StringBuilder();
        if (param != null) {
            for (String s : param) {
                params.append(",").append(s);
            }
        }
        String stackTraceMessage = FriendlyErrorLog.getStackTraceMessage(e);
        log.error("\n\u5f02\u5e38\u4fe1\u606f: {} \n \u53c2\u6570\uff1a[{}] \n \u53d1\u751f\u5728: {}", new Object[]{e.getMessage(), StringUtils.commaDelimitedTrimEmptyString((String)params.toString()), stackTraceMessage});
        return stackTraceMessage;
    }

    public static String warn(Throwable e) {
        String stackTraceMessage = FriendlyErrorLog.getStackTraceMessage(e);
        log.warn("\n\u8b66\u544a\u4fe1\u606f: {}\n\u53d1\u751f\u5728: {}", (Object)e.getMessage(), (Object)stackTraceMessage);
        return stackTraceMessage;
    }

    public static String warn(Throwable e, String ... param) {
        StringBuilder params = new StringBuilder();
        if (param != null) {
            for (String s : param) {
                params.append(",").append(s);
            }
        }
        String stackTraceMessage = FriendlyErrorLog.getStackTraceMessage(e);
        log.warn("\n\u8b66\u544a\u4fe1\u606f: {} \n \u53c2\u6570: [{}] \n \u53d1\u751f\u5728: {}", new Object[]{e.getMessage(), StringUtils.commaDelimitedTrimEmptyString((String)params.toString()), stackTraceMessage});
        return stackTraceMessage;
    }

    private static String getStackTraceMessage(Throwable throwable) {
        StringBuilder trace = new StringBuilder();
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        Collection<String> strings = FriendlyErrorLog.printUsefulStackTrace(set, throwable);
        strings.stream().filter(StringUtils::isNotBlank).forEach(s -> trace.append((String)s).append("\n"));
        trace.deleteCharAt(trace.length() - 1);
        return trace.toString();
    }

    private static boolean isForOutPutError(String className) {
        if (StringUtils.isBlank((String)className)) {
            return false;
        }
        String logOutPackage = System.getenv("LOG_OUT_PACKAGE");
        if (StringUtils.isBlank((String)logOutPackage)) {
            return false;
        }
        if (StringUtils.contains((CharSequence)className, (CharSequence)"gomro")) {
            return true;
        }
        return StringUtils.contains((CharSequence)className, (CharSequence)logOutPackage);
    }

    private static Collection<String> printUsefulStackTrace(Set<String> set, Throwable throwable) {
        if (throwable == null) {
            return set;
        }
        set.add(throwable.getMessage() + "(" + throwable.getClass().getSimpleName() + ")");
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        if (stackTrace != null) {
            if (stackTrace.length > 0) {
                set.add("   " + stackTrace[0].getClassName() + ":" + stackTrace[0].getLineNumber());
            }
            if (stackTrace.length > 2) {
                String line1 = stackTrace[1].getClassName();
                String line2 = stackTrace[2].getClassName();
                if (!FriendlyErrorLog.isForOutPutError(line1)) {
                    set.add("   " + line1 + ":" + stackTrace[1].getLineNumber());
                }
                if (!FriendlyErrorLog.isForOutPutError(line1)) {
                    set.add("   " + line2 + ":" + stackTrace[2].getLineNumber());
                }
            }
            Arrays.stream(stackTrace).forEach(s -> {
                String className = s.getClassName();
                boolean gomroError = FriendlyErrorLog.isForOutPutError(className);
                boolean $$ = StringUtils.contains((CharSequence)className, (CharSequence)"$$");
                if (gomroError && !$$) {
                    set.add("   " + className + ":" + s.getLineNumber());
                }
            });
        }
        if ((throwable = throwable.getCause()) != null) {
            set.add(" Cause by: ");
            return FriendlyErrorLog.printUsefulStackTrace(set, throwable.getCause());
        }
        return set;
    }
}

