/*
 * Decompiled with CFR 0.152.
 */
package cn.gomro.commons.utils;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;

public class SequenceUtil {
    private static final long Epoch = 1539754886168L;
    private static final long WorkerIdBits = 5L;
    private static final long DataCenterIdBits = 5L;
    private static final long SequenceBits = 12L;
    private static final long WorkerIdShift = 12L;
    private static final long DataCenterIdShift = 17L;
    private static final long TimestampShift = 22L;
    private static final long SequenceMask = 4095L;
    public static final long MaxWorkerId = 31L;
    public static final long MaxDataCenterId = 31L;
    private static long LastTimestamp = -1L;
    private long sequence = 0L;
    private final long workerId;
    private final long dataCenterId;

    public SequenceUtil(long dataCenterId, long workerId) {
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 31L));
        }
        if (dataCenterId > 31L || dataCenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", 31L));
        }
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < LastTimestamp) {
            throw new RuntimeException(String.format("clock moved backwards. refusing to generate id for %d milliseconds", LastTimestamp - timestamp));
        }
        if (LastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(LastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        LastTimestamp = timestamp;
        return timestamp - 1539754886168L << 22 | this.dataCenterId << 17 | this.workerId << 12 | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }

    public static long getWorkerId(long dataCenterId, long maxWorkerId) {
        StringBuffer jvmPid = new StringBuffer();
        jvmPid.append(dataCenterId);
        String name = ManagementFactory.getRuntimeMXBean().getName();
        if (!name.isEmpty()) {
            jvmPid.append(name.split("@")[0]);
        }
        return (long)(jvmPid.toString().hashCode() & 0xFFFF) % (maxWorkerId + 1L);
    }

    public static long getDataCenterId(long maxDatCenterId) throws UnknownHostException, SocketException {
        long id;
        InetAddress ip = InetAddress.getLocalHost();
        NetworkInterface network = NetworkInterface.getByInetAddress(ip);
        if (network == null) {
            id = 1L;
        } else {
            byte[] mac = network.getHardwareAddress();
            id = (0xFFL & (long)mac[mac.length - 1] | 0xFF00L & (long)mac[mac.length - 2] << 8) >> 6;
            id %= maxDatCenterId + 1L;
        }
        return id;
    }
}

