/*
 * Decompiled with CFR 0.152.
 */
package cn.gomro.commons.utils;

import cn.gomro.commons.utils.RegexUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class StringUtils {
    public static final String UTF8 = "UTF-8";
    public static final String GB2312 = "GB2312";
    public static final String GBK = "GBK";
    public static final String PatternUsername = "^[a-zA-Z0-9]{1}([a-zA-Z0-9]|[_]){2,18}[a-zA-Z0-9]{1}$";
    public static final String PatternEmail = "^^\\w+((-\\w+)|(\\.\\w+))*\\@[A-Za-z0-9]+((\\.|-)[A-Za-z0-9]+)*\\.[A-Za-z0-9]+$";
    public static final String PatternPhone = "(^(\\d{2,4}[-_\uff0d\u2014]?)?\\d{3,8}([-_\uff0d\u2014]?\\d{3,8})?([-_\uff0d\u2014]?\\d{1,7})?$)|(^0?1[35]\\d{9}$)";
    public static final String PatternMobile = "^((13[0-9])|(14[579])|(15([0-3]|[5-9]))|(16[56])|(17[0-8])|(18[0-9])|(19[1589]))\\d{8}$";
    public static final String PatternIp = "((?:(?:25[0-5]|2[0-4]\\d|[01]?\\d?\\d)\\.){3}(?:25[0-5]|2[0-4]\\d|[01]?\\d?\\d))";
    public static final String PatternUrl = "^(http|www|ftp|)?(:\\)?(\\w+(-\\w+)*)(\\.(\\w+(-\\w+)*))*((:\\d+)?)(/(\\w+(-\\w+)*))*(\\.?(\\w)*)(\\?)?(((\\w*%)*(\\w*\\?)*(\\w*:)*(\\w*\\+)*(\\w*\\.)*(\\w*&)*(\\w*-)*(\\w*=)*(\\w*%)*(\\w*\\?)*(\\w*:)*(\\w*\\+)*(\\w*\\.)*(\\w*&)*(\\w*-)*(\\w*=)*)*(\\w*)*)$";
    public static final String PatternIdCard = "((11|12|13|14|15|21|22|23|31|32|33|34|35|36|37|41|42|43|44|45|46|50|51|52|53|54|61|62|63|64|65)[0-9]{4})(([1|2][0-9]{3}[0|1][0-9][0-3][0-9][0-9]{3}[Xx0-9])|([0-9]{2}[0|1][0-9][0-3][0-9][0-9]{3}))";
    public static final String PatternAge = "^(?:[1-9][0-9]?|1[01][0-9]|120)$";
    public static final String PatternPostal = "[1-9]\\d{5}(?!\\d)";
    public static final String PatternSmsAuthCode = "^\\d{6}$";
    public static final String PatternInt = "^([+-]?)\\d*\\.?\\d+$";
    public static final String PatternIntPositive = "^[1-9]\\d*$";
    public static final String PatternIntNegative = "^-[1-9]\\d*|0$";
    public static final String PatternDouble = "^-?([1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*|0?\\.0+|0)$";
    public static final String PatternDoublePositive = "^[1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*|0?\\.0+|0$";
    public static final String PatternDoubleNegative = "^(-([1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*))|0?\\.0+|0$";
    public static final String PatternEnglish = "^[A-Za-z]+$";
    public static final String PatternEnglishNumeric = "^\\w+$";
    public static final String PatternEnglishNumericUnderline = "^\\w+$";
    public static final String PatternChinese = "^[/u0391-/uffe5]+$";
    public static final String PatternChineseEnglishNumeric = "^[a-zA-Z0-9/u4e00-/u9fa5]+$";
    public static final String PatternSpecial = "[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
    public static final String PatternDate = "[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}";
    public static final String PatternDatetime = "^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$";
    public static final String PatternScientificA = "^[-+]?(\\d+(\\.\\d*)?|\\.\\d+)([eE]([-+]?([012]?\\d{1,2}|30[0-7])|-3([01]?[4-9]|[012]?[0-3])))$";
    public static final String PatternScientificB = "^[-+]?(\\d+(\\.\\d*)?|\\.\\d+)([eE]([-+]?([012]?\\d{1,2}|30[0-7])|-3([01]?[4-9]|[012]?[0-3])))[dD]?$";
    public static final String PatternScientificC = "^[-+]?(\\d+(\\.\\d*)?|\\.\\d+)([eE]([-+]?([012]?\\d{1,2}|30[0-7])|-3([01]?[4-9]|[012]?[0-3])))?[dD]?$";
    public static final String PatternScientificD = "^[-+]?(\\d+(\\.\\d*)?|\\.\\d+)([eE]([-+]?([012]?\\d{1,2}|30[0-7])|-3([01]?[4-9]|[012]?[0-3])))?$";

    public static String lowerCase(String str) {
        return org.apache.commons.lang3.StringUtils.lowerCase((String)str);
    }

    public static boolean equalsIgnoreCase(CharSequence str1, CharSequence str2) {
        return org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)str1, (CharSequence)str2);
    }

    public static boolean isNotBlank(CharSequence cs) {
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)cs);
    }

    public static Set<String> commaDelimitedTrimEmptySet(String str) {
        Set strings = org.springframework.util.StringUtils.commaDelimitedListToSet((String)str);
        return strings.stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet());
    }

    public static LinkedHashSet<String> commaDelimitedTrimEmptyLinkedHashSet(String str) {
        String[] strings = org.springframework.util.StringUtils.commaDelimitedListToStringArray((String)str);
        List collect = Arrays.stream(strings).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        return new LinkedHashSet<String>(collect);
    }

    public static List<String> commaDelimitedTrimEmptyList(String str) {
        String[] strings = org.springframework.util.StringUtils.commaDelimitedListToStringArray((String)str);
        return Arrays.stream(strings).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    public static String[] split(String str, String delimiter) {
        return org.apache.commons.lang3.StringUtils.split((String)str, (String)delimiter);
    }

    public static List<Integer> commaDelimitedTrimEmptyListInteger(String str) {
        String id;
        if (RegexUtils.check("^[\\d,]+$", str) && StringUtils.isNotBlank(id = StringUtils.commaDelimitedTrimEmptyString(str))) {
            return Arrays.stream(id.split(",")).mapToInt(Integer::valueOf).boxed().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<Long> commaDelimitedTrimEmptyListLong(String str) {
        String id;
        if (RegexUtils.check("^[\\d,]+$", str) && StringUtils.isNotBlank(id = StringUtils.commaDelimitedTrimEmptyString(str))) {
            return Arrays.stream(id.split(",")).mapToLong(Long::valueOf).boxed().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static String commaDelimitedTrimEmptyString(String str) {
        Set strings = org.springframework.util.StringUtils.commaDelimitedListToSet((String)str);
        return StringUtils.collectionToCommaDistinctString(strings);
    }

    public static String stringToCommaDistinctString(String str) {
        Set strings = org.springframework.util.StringUtils.commaDelimitedListToSet((String)str);
        return org.springframework.util.StringUtils.collectionToDelimitedString((Collection)strings, (String)",", (String)"'", (String)"'");
    }

    public static String toSqlInString(String str) {
        if (StringUtils.isBlank(str)) {
            return "";
        }
        str = StringUtils.escapeSql(str);
        String str1 = StringUtils.commaDelimitedTrimEmptyString(str);
        return StringUtils.stringToCommaDistinctString(str1);
    }

    public static String escapeSql(String str) {
        return str == null ? null : org.apache.commons.lang3.StringUtils.replace((String)str, (String)"'", (String)"''");
    }

    public static String collectionToCommaDistinctString(Collection<?> coll) {
        if (coll == null || coll.isEmpty()) {
            return "";
        }
        coll = coll.stream().filter(c -> {
            if (c instanceof CharSequence) {
                return StringUtils.isNotBlank((CharSequence)c);
            }
            return c != null;
        }).collect(Collectors.toSet());
        return org.springframework.util.StringUtils.collectionToCommaDelimitedString((Collection)coll);
    }

    public static String collectionToCommaString(Collection<?> coll) {
        if (coll == null || coll.isEmpty()) {
            return "";
        }
        coll = coll.stream().filter(c -> {
            if (c instanceof CharSequence) {
                return StringUtils.isNotBlank((CharSequence)c);
            }
            return c != null;
        }).collect(Collectors.toList());
        return org.springframework.util.StringUtils.collectionToCommaDelimitedString((Collection)coll);
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return org.springframework.util.StringUtils.startsWithIgnoreCase((String)str, (String)prefix);
    }

    public static boolean endsWithIgnoreCase(String str, String prefix) {
        return org.springframework.util.StringUtils.endsWithIgnoreCase((String)str, (String)prefix);
    }

    public static String appendCommaAtStartAndEnd(String str) {
        boolean endWith;
        if (str == null) {
            return ",";
        }
        boolean startsWith = StringUtils.startsWithIgnoreCase(str, ",");
        if (!startsWith) {
            str = ",".concat(str);
        }
        if (!(endWith = StringUtils.endsWithIgnoreCase(str, ","))) {
            str = str.concat(",");
        }
        return str;
    }

    public static String strip(String str, String stripChars) {
        return org.apache.commons.lang3.StringUtils.strip((String)str, (String)stripChars);
    }

    public static List<Long> semicolonDelimitedTrimEmptyListLong(String str) {
        String id;
        if (StringUtils.isNotBlank(str) && StringUtils.isNotBlank(id = StringUtils.commaDelimitedTrimEmptyString(str))) {
            return Arrays.stream(id.split(";")).mapToLong(Long::valueOf).boxed().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static String underscoreName(String name) {
        StringBuilder result = new StringBuilder();
        if (name != null && name.length() > 0) {
            result.append(name.substring(0, 1).toUpperCase());
            for (int i = 1; i < name.length(); ++i) {
                String s = name.substring(i, i + 1);
                if (s.equals(s.toUpperCase()) && !Character.isDigit(s.charAt(0))) {
                    result.append("_");
                }
                result.append(s.toUpperCase());
            }
        }
        return result.toString();
    }

    public static String camelName(String name) {
        String[] camels;
        StringBuilder result = new StringBuilder();
        if (name == null || name.isEmpty()) {
            return "";
        }
        if (!name.contains("_")) {
            return name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        for (String camel : camels = name.split("_")) {
            if (camel.isEmpty()) continue;
            if (result.length() == 0) {
                result.append(camel.toLowerCase());
                continue;
            }
            result.append(camel.substring(0, 1).toUpperCase());
            result.append(camel.substring(1).toLowerCase());
        }
        return result.toString();
    }

    public static String underline2Camel(String line, boolean ... smallCamel) {
        if (line == null || "".equals(line)) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Pattern pattern = Pattern.compile("([A-Za-z\\d]+)(_)?");
        Matcher matcher = pattern.matcher(line);
        while (matcher.find()) {
            String word = matcher.group();
            if ((smallCamel.length == 0 || smallCamel[0]) && matcher.start() == 0) {
                sb.append(Character.toLowerCase(word.charAt(0)));
            } else {
                sb.append(Character.toUpperCase(word.charAt(0)));
            }
            int index = word.lastIndexOf(95);
            if (index > 0) {
                sb.append(word.substring(1, index).toLowerCase());
                continue;
            }
            sb.append(word.substring(1).toLowerCase());
        }
        return sb.toString();
    }

    public static boolean contains(CharSequence str, CharSequence searchStr) {
        return org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)str, (CharSequence)searchStr);
    }

    public static String join(Iterable<?> iterable, String s) {
        return org.apache.commons.lang3.StringUtils.join(iterable, (String)s);
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String escapeQuotes(String val) {
        return val == null ? null : org.apache.commons.lang3.StringUtils.replace((String)val, (String)"\"", (String)"\u201c");
    }

    public static int len(String val) {
        return StringUtils.isBlank(val) ? 0 : val.trim().length();
    }

    public static boolean max(String val, int len) {
        return StringUtils.len(val) > len;
    }

    public static boolean between(String val, int minLen, int maxLen) {
        return minLen <= StringUtils.len(val) && StringUtils.len(val) <= maxLen;
    }

    public static String filterSpecial(String val) {
        return Pattern.compile(PatternSpecial).matcher(val).replaceAll("").trim();
    }

    public static boolean isBlank(String val) {
        return org.apache.commons.lang3.StringUtils.isBlank((CharSequence)val);
    }

    public static boolean isNull(String val) {
        return null == val || val.trim().length() <= 0;
    }

    public static boolean notNull(String val) {
        return !StringUtils.isNull(val);
    }

    public static String nullToStr(String val) {
        return StringUtils.isNull(val) ? "" : val;
    }

    public static String nullToStr(String val, String def) {
        return StringUtils.isNull(val) ? def : val;
    }

    public static String addZeroForNum(String str, int strLength) {
        int strLen = str.length();
        if (strLen < strLength) {
            while (strLen < strLength) {
                StringBuffer sb = new StringBuffer();
                sb.append("0").append(str);
                str = sb.toString();
                strLen = str.length();
            }
        }
        return str;
    }

    public static String repeatString(String name, String s) {
        String[] str = name.split(s);
        if (str.length == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < str.length; ++i) {
            if (list.contains(str[i])) continue;
            list.add(str[i]);
            sb.append(str[i] + ",");
        }
        return sb.toString().substring(0, sb.toString().length() - 1);
    }

    public static List<Integer> stringToListInteger(String val, String s) {
        String[] arr = val.split(s);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < arr.length; ++i) {
            list.add(Integer.parseInt(arr[i]));
        }
        return list;
    }

    public static Double stringToDouble(String val, Double defaultValue) {
        if (val.isEmpty() || val == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static List<Long> stringToListLong(String val, String s) {
        String[] arr = val.split(s);
        ArrayList<Long> list = new ArrayList<Long>();
        for (int i = 0; i < arr.length; ++i) {
            list.add(Long.parseLong(arr[i]));
        }
        return list;
    }

    public static String listToString(List<Integer> ids) {
        return ids.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(","));
    }

    public static String randomStr8() {
        return String.valueOf(new Random().nextLong()).substring(1, 9);
    }

    public static boolean isLetterOrDigits(String str) {
        return str.chars().allMatch(t -> Character.isLowerCase(t) || Character.isUpperCase(t) || Character.isDigit(t));
    }

    public static boolean containsAny(Collection<String> coll1, Collection<String> coll2) {
        if (coll1.size() < coll2.size()) {
            for (String aColl1 : coll1) {
                if (!coll2.contains(StringUtils.lowerCase(aColl1))) continue;
                return true;
            }
        } else {
            for (String aColl2 : coll2) {
                if (!coll1.contains(StringUtils.lowerCase(aColl2))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAnyIgnoreCase(Collection<String> coll1, Collection<String> coll2) {
        if (coll1.size() < coll2.size()) {
            Collection coll2LowerCase = coll2.stream().map(StringUtils::lowerCase).collect(Collectors.toSet());
            for (String aColl1 : coll1) {
                if (!coll2LowerCase.contains(StringUtils.lowerCase(aColl1))) continue;
                return true;
            }
        } else {
            Collection coll1LowerCase = coll1.stream().map(StringUtils::lowerCase).collect(Collectors.toSet());
            for (String aColl2 : coll2) {
                if (!coll1LowerCase.contains(StringUtils.lowerCase(aColl2))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean verifyToSqlInString(String param) {
        return StringUtils.isNotBlank(StringUtils.toSqlInString(param));
    }

    public static boolean compareIsRepeat(String[] strs) {
        HashSet<String> set = new HashSet<String>();
        boolean result = false;
        for (int i = 0; i < strs.length; ++i) {
            for (int j = i + 1; j < strs.length; ++j) {
                if (!strs[i].equals(strs[j])) continue;
                set.add(strs[i]);
                result = true;
            }
        }
        return result;
    }

    public static enum CaseMode {
        Capitalize,
        Lower,
        Upper;

    }
}

