/*
 * Decompiled with CFR 0.152.
 */
package cn.gudqs.system.admin.web;

import cn.gudqs.base.BaseController;
import cn.gudqs.base.ResultBean;
import cn.gudqs.exception.ErrorCodes;
import cn.gudqs.system.admin.entity.SysAuthModel;
import cn.gudqs.system.admin.entity.SysMenuModel;
import cn.gudqs.system.admin.service.ISysAuthService;
import cn.gudqs.system.admin.service.ISysMenuService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/auth"})
@Api(description="\u7cfb\u7edf\u89d2\u8272\u6743\u9650\u7ba1\u7406")
public class SysAuthController
extends BaseController {
    @Resource
    private ISysAuthService sysAuthService;
    @Resource
    private ISysMenuService menuService;

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u7684\u6240\u6709\u6743\u9650")
    @PostMapping(value={"/findAll"})
    public ResultBean findAll(HttpServletRequest request) {
        Object uid = request.getAttribute("uid");
        if (uid != null) {
            Integer userId = (Integer)uid;
            return this.success(this.sysAuthService.findBySysUserId(userId));
        }
        return this.error(ErrorCodes.TOKEN_NOT_MATCH);
    }

    @PostMapping(value={"/findMenu"})
    public ResultBean<List<SysMenuModel>> findMenu(Integer sysRoleId) throws Exception {
        if (sysRoleId == null) {
            return this.success(this.menuService.findAll());
        }
        return this.success(this.menuService.findBySysRoleId(sysRoleId));
    }

    @PostMapping(value={"/addMenu"})
    public ResultBean addMenu(Integer sysRoleId, Integer sysMenuId) {
        if (sysRoleId == null) {
            return this.error("role id \u4e3a\u7a7a");
        }
        this.menuService.addMenu(sysMenuId, sysRoleId);
        return this.success();
    }

    @PostMapping(value={"/delMenu"})
    public ResultBean delMenu(Integer sysRoleId, Integer sysMenuId) {
        if (sysRoleId == null) {
            return this.error("role id \u4e3a\u7a7a");
        }
        this.menuService.delMenu(sysMenuId, sysRoleId);
        return this.success();
    }

    @PostMapping(value={"/findByRole"})
    public ResultBean<List<SysAuthModel>> findByRole(Integer sysRoleId) throws Exception {
        if (sysRoleId == null) {
            return this.success(this.sysAuthService.findAll());
        }
        return this.success(this.sysAuthService.findBySysRoleId(sysRoleId));
    }

    @PostMapping(value={"/add"})
    public ResultBean add(Integer sysRoleId, Integer sysAuthId) {
        if (sysRoleId == null) {
            return this.error("role id \u4e3a\u7a7a");
        }
        this.sysAuthService.addAuth(sysRoleId, sysAuthId);
        return this.success();
    }

    @PostMapping(value={"/delete"})
    public ResultBean delete(Integer sysRoleId, Integer sysAuthId) {
        if (sysRoleId == null) {
            return this.error("role id \u4e3a\u7a7a");
        }
        this.sysAuthService.delAuth(sysRoleId, sysAuthId);
        return this.success();
    }
}

