/*
 * Decompiled with CFR 0.152.
 */
package cn.gudqs.system.configuration;

import java.util.Properties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.stereotype.Component;

@Component
public class MailConfiguration {
    @Value(value="${mail.host}")
    private String host;
    @Value(value="${mail.port}")
    private Integer port;
    @Value(value="${mail.username}")
    private String account;
    @Value(value="${mail.password}")
    private String password;

    @Bean(name={"mailSender"})
    public JavaMailSenderImpl getMailSender() {
        JavaMailSenderImpl javaMailSender = new JavaMailSenderImpl();
        javaMailSender.setHost(this.host);
        javaMailSender.setPort(this.port.intValue());
        javaMailSender.setUsername(this.account);
        javaMailSender.setPassword(this.password);
        Properties properties = new Properties();
        properties.put("mail.smtp.auth", (Object)true);
        properties.put("mail.smtp.timeout", (Object)25000);
        properties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        javaMailSender.setJavaMailProperties(properties);
        return javaMailSender;
    }
}

