/*
 * Decompiled with CFR 0.152.
 */
package cn.gudqs.business.common.web;

import cn.gudqs.base.BaseController;
import cn.gudqs.base.FilterVo;
import cn.gudqs.base.PageEntity;
import cn.gudqs.base.ParamVo;
import cn.gudqs.base.ResultBean;
import cn.gudqs.business.common.entity.SysDictionaryModel;
import cn.gudqs.business.common.service.ISysDictionaryService;
import cn.gudqs.helper.DictionaryUtil;
import io.swagger.annotations.Api;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/sys/dictionary"})
@Api(description="\u7cfb\u7edf\u5b57\u5178\u7ba1\u7406")
public class SysDictionaryController
extends BaseController {
    @Resource
    private ISysDictionaryService sysDictionaryService;

    @PostMapping(value={"/findParent"})
    public ResultBean<List<SysDictionaryModel>> findParent(@RequestBody ParamVo paramVo) throws Exception {
        paramVo.addFilter(new FilterVo("parentId", "eq", (Object)0, "numeric"));
        paramVo.desc("displayOrder");
        return SysDictionaryController.success((PageEntity)this.sysDictionaryService.findAll(paramVo));
    }

    @PostMapping(value={"/find"})
    public ResultBean<List<SysDictionaryModel>> find(@RequestBody ParamVo paramVo, Integer parentId) throws Exception {
        paramVo.addFilter(new FilterVo("parentId", "eq", (Object)parentId, "numeric"));
        paramVo.desc("displayOrder");
        return SysDictionaryController.success((PageEntity)this.sysDictionaryService.findAll(paramVo));
    }

    @PostMapping(value={"/update"})
    public ResultBean update(SysDictionaryModel entity) throws Exception {
        this.sysDictionaryService.updateSelective(entity);
        DictionaryUtil.set(entity);
        return this.success();
    }

    @PostMapping(value={"/add"})
    public ResultBean add(SysDictionaryModel entity) throws Exception {
        this.sysDictionaryService.insertSelective(entity);
        DictionaryUtil.set(entity);
        return this.success();
    }

    @PostMapping(value={"/delete"})
    public ResultBean delete(@RequestBody Object[] ids) throws Exception {
        this.sysDictionaryService.delete(ids);
        return this.success();
    }
}

