/*
 * Decompiled with CFR 0.152.
 */
package cn.gudqs.system.admin.web;

import cn.gudqs.base.BaseController;
import cn.gudqs.base.PageEntity;
import cn.gudqs.base.ParamVo;
import cn.gudqs.base.ResultBean;
import cn.gudqs.system.admin.entity.SysUserModel;
import cn.gudqs.system.admin.service.ISysRoleService;
import cn.gudqs.system.admin.service.ISysUserService;
import cn.gudqs.util.CommonUtil;
import cn.gudqs.util.JwtUtil;
import cn.gudqs.util.crypto.MD5Util;
import io.swagger.annotations.Api;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/user"})
@Api(description="\u7cfb\u7edf\u7528\u6237\u7ba1\u7406")
public class SysUserController
extends BaseController {
    @Value(value="${project.env}")
    private String env;
    @Resource
    private ISysUserService sysUserService;
    @Resource
    private ISysRoleService sysRoleService;

    @PostMapping(value={"/login"})
    public ResultBean login(String loginName, String password) {
        boolean rightUser;
        SysUserModel sysUserModel = this.sysUserService.findByLoginName(loginName);
        if (CommonUtil.isDev((String)this.env) && sysUserModel != null) {
            return this.successUser(sysUserModel);
        }
        boolean bl = rightUser = sysUserModel != null && sysUserModel.getStatus() == 1;
        if (rightUser && MD5Util.getMD5((String)(loginName + password)).equals(sysUserModel.getPassword())) {
            return this.successUser(sysUserModel);
        }
        return this.error("\u767b\u5f55\u5931\u8d25");
    }

    private ResultBean successUser(SysUserModel sysUserModel) {
        sysUserModel.setPassword(null);
        HashMap<String, String> data = new HashMap<String, String>(2);
        data.put("uid", sysUserModel.getSysUserId() + "");
        data.put("type", "2");
        String token = JwtUtil.sign(data, 30, 5);
        return this.success(sysUserModel, token);
    }

    @PostMapping(value={"/updatePwd"})
    public ResultBean updatePwd(String loginName, String password, String newPwd) throws Exception {
        SysUserModel sysUserModel = this.sysUserService.findByLoginName(loginName);
        if (sysUserModel != null && MD5Util.getMD5((String)(loginName + password)).equals(sysUserModel.getPassword())) {
            sysUserModel.setPassword(MD5Util.getMD5((String)(loginName + newPwd)));
            this.sysUserService.updateSelective(sysUserModel);
            return this.success();
        }
        return this.error("\u6821\u9a8c\u5bc6\u7801\u5931\u8d25");
    }

    @PostMapping(value={"/find"})
    public ResultBean<List<SysUserModel>> find(@RequestBody ParamVo paramVo) throws Exception {
        return SysUserController.success((PageEntity)this.sysUserService.findAll(paramVo));
    }

    @PostMapping(value={"/update"})
    public ResultBean update(SysUserModel entity) throws Exception {
        this.sysUserService.updateSelective(entity);
        return this.success();
    }

    @PostMapping(value={"/add"})
    public ResultBean add(@RequestBody SysUserModel entity) throws Exception {
        List<String> delSysRoleIds;
        if (entity.getSysUserId() == null) {
            entity.setPassword(MD5Util.getMD5((String)(entity.getLoginName() + entity.getPassword())));
            this.sysUserService.insertSelective(entity);
        } else {
            this.update(entity);
        }
        List<String> sysRoleIds = entity.getSysRoleIds();
        if (sysRoleIds != null && sysRoleIds.size() > 0) {
            for (String sysRoleId : sysRoleIds) {
                this.sysRoleService.addRole(entity.getSysUserId(), Integer.parseInt(sysRoleId));
            }
        }
        if ((delSysRoleIds = entity.getDelSysRoleIds()) != null && delSysRoleIds.size() > 0) {
            for (String sysRoleId : delSysRoleIds) {
                this.sysRoleService.delRole(entity.getSysUserId(), Integer.parseInt(sysRoleId));
            }
        }
        return this.success();
    }

    @PostMapping(value={"/delete"})
    public ResultBean delete(@RequestBody Object[] ids) throws Exception {
        this.sysUserService.delete(ids);
        return this.success();
    }
}

