/*
 * Decompiled with CFR 0.152.
 */
package cn.gudqs.system.configuration;

import cn.gudqs.util.StringUtil;
import org.jboss.logging.Logger;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

@EnableScheduling
@Configuration
public class SchedulingConfiguration
implements SchedulingConfigurer {
    private final ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();

    SchedulingConfiguration() {
        this.taskScheduler.setErrorHandler(e -> {
            e.printStackTrace();
            if (!StringUtil.isBlank((String)e.getMessage())) {
                String message = StringUtil.ellipsis((String)e.getMessage(), (Integer)30);
                Logger.getLogger(SchedulingConfiguration.class).info((Object)("error on schedule--> msg: " + message));
            }
        });
        this.taskScheduler.setThreadNamePrefix("schedule-thread-");
        this.taskScheduler.setPoolSize(30);
        this.taskScheduler.initialize();
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.setScheduler((Object)this.taskScheduler);
    }
}

