/*
 * Decompiled with CFR 0.152.
 */
package cn.gudqs.system.configuration;

import cn.gudqs.system.handler.JsonFilterArgumentResolver;
import cn.gudqs.system.handler.JsonFilterReturnValueHandler;
import cn.gudqs.system.interceptor.AdminInterceptor;
import cn.gudqs.system.interceptor.ApiTokenInterceptor;
import cn.gudqs.util.CommonUtil;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

@Configuration
@Component
public class WebAppConfiguration
extends WebMvcConfigurationSupport {
    @Value(value="${project.env}")
    private String env;

    public void addInterceptors(InterceptorRegistry registry) {
        ArrayList<String> patterns = new ArrayList<String>();
        patterns.add("/api/user/login");
        patterns.add("/api/user/tempToken");
        patterns.add("/api/user/publicLogin");
        if (!CommonUtil.isDev((String)this.env)) {
            registry.addInterceptor((HandlerInterceptor)this.apiTokenInterceptor()).addPathPatterns(new String[]{"/webjars/**", "/swagger-ui.html"});
        }
        registry.addInterceptor((HandlerInterceptor)this.apiTokenInterceptor()).addPathPatterns(new String[]{"/api/**"}).excludePathPatterns(patterns);
        registry.addInterceptor((HandlerInterceptor)this.adminInterceptor()).addPathPatterns(new String[]{"/admin/**"}).excludePathPatterns(new String[]{"/admin/user/login", "/admin/user/updatePwd"});
        super.addInterceptors(registry);
    }

    @Bean
    public ApiTokenInterceptor apiTokenInterceptor() {
        return new ApiTokenInterceptor();
    }

    @Bean
    public AdminInterceptor adminInterceptor() {
        return new AdminInterceptor();
    }

    @Bean
    public HttpMessageConverter<String> responseBodyConverter() {
        return new StringHttpMessageConverter(Charset.forName("UTF-8"));
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        super.configureMessageConverters(converters);
        converters.add(this.responseBodyConverter());
        converters.add((HttpMessageConverter<?>)this.jackson2HttpMessageConverter());
    }

    @Bean
    public MappingJackson2HttpMessageConverter jackson2HttpMessageConverter() {
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        converter.setObjectMapper(mapper);
        return converter;
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.favorPathExtension(false);
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{"classpath:/static/"});
        registry.addResourceHandler(new String[]{"/admin/**"}).addResourceLocations(new String[]{"classpath:/static/admin/"});
        registry.addResourceHandler(new String[]{"swagger-ui.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
    }

    protected void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        super.addArgumentResolvers(argumentResolvers);
        argumentResolvers.add((HandlerMethodArgumentResolver)new JsonFilterArgumentResolver());
    }

    protected void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
        super.addReturnValueHandlers(returnValueHandlers);
        returnValueHandlers.add((HandlerMethodReturnValueHandler)new JsonFilterReturnValueHandler());
    }
}

