/*
 * Decompiled with CFR 0.152.
 */
package cn.gudqs.util.token;

import cn.gudqs.exception.CustomException;
import cn.gudqs.helper.SpringContextUtil;
import cn.gudqs.util.JsonUtils;
import cn.gudqs.util.LoggerUtil;
import cn.gudqs.util.http.HttpUtils;
import cn.gudqs.util.redis.RedisUtils;
import java.io.IOException;
import java.util.Map;

public class CommonWeChatToken {
    private static String accessTokenUrl;
    private static String tokenPrefix;
    private static String tokenTimePrefix;
    private static String tokenExpirePrefix;

    private static void getResource() {
        if (accessTokenUrl == null) {
            accessTokenUrl = SpringContextUtil.getEnvironmentProperty((String)"gzh.accessTokenUrl");
        }
    }

    public static String getAccessToken(String appKey, String appSecrete) throws Exception {
        CommonWeChatToken.getResource();
        LoggerUtil.debug((String)("getToken: " + appKey), CommonWeChatToken.class);
        String tokenKey = tokenPrefix + appKey;
        boolean existsToken = RedisUtils.hasKey((String)tokenKey);
        if (!existsToken) {
            return CommonWeChatToken.refreshToken(appKey, appSecrete);
        }
        String accessToken = RedisUtils.get((String)tokenKey);
        String time = RedisUtils.get((String)(tokenTimePrefix + appKey));
        String expire = RedisUtils.get((String)(tokenExpirePrefix + appKey));
        if (time != null && expire != null) {
            long accessTokenTime = Long.parseLong(time);
            long maxExpire = Long.parseLong(expire);
            return CommonWeChatToken.returnByTime(appKey, appSecrete, accessToken, accessTokenTime, maxExpire);
        }
        throw new CustomException("get token error, redis data null");
    }

    private static String returnByTime(String appKey, String appSecrete, String accessToken, long accessTokenTime, long maxExpire) throws IOException {
        long maxExpireMillis = maxExpire * 1000L;
        if (System.currentTimeMillis() - accessTokenTime > maxExpireMillis) {
            return CommonWeChatToken.refreshToken(appKey, appSecrete);
        }
        return accessToken;
    }

    public static String refreshToken(String appKey, String appSecrete) throws IOException {
        String result = HttpUtils.httpClientGet((String)accessTokenUrl.replaceAll("APPID", appKey).replaceAll("APPSK", appSecrete), (String)"");
        LoggerUtil.info((String)("access token refresh -->result: " + result), CommonWeChatToken.class);
        Map obj = JsonUtils.getMap((String)result);
        String accessToken = (String)obj.get("access_token");
        long accessTokenTime = System.currentTimeMillis();
        long maxExpire = Long.parseLong(obj.get("expires_in").toString());
        RedisUtils.set((String)(tokenPrefix + appKey), (String)accessToken);
        RedisUtils.set((String)(tokenTimePrefix + appKey), (String)(accessTokenTime + ""));
        RedisUtils.set((String)(tokenExpirePrefix + appKey), (String)(maxExpire + ""));
        return accessToken;
    }

    static {
        tokenPrefix = "wechat:accessToken:";
        tokenTimePrefix = "wechat:accessTokenTime:";
        tokenExpirePrefix = "wechat:maxExpire:";
    }
}

