/*
 * Decompiled with CFR 0.152.
 */
package org.gmwframework.cloud.common.enunfield;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.gmwframework.cloud.common.annotation.EnumField;
import org.gmwframework.cloud.common.enunfield.EnumFieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class EnumFieldSerializer
extends JsonSerializer<Object> {
    private final Logger logger = LoggerFactory.getLogger(EnumFieldSerializer.class);
    private static final String OBJ_SUFFIX = "Text";
    private Set<Class<?>> typeSet = new HashSet();

    public EnumFieldSerializer() {
        this.typeSet.add(Integer.TYPE);
        this.typeSet.add(Integer.class);
        this.typeSet.add(String.class);
    }

    public Set<Class<?>> getTypeSet() {
        return this.typeSet;
    }

    public void setTypeSet(Set<Class<?>> typeSet) {
        this.typeSet = typeSet;
    }

    public void serialize(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeObject(o);
        try {
            EnumField enumField;
            String filedName = jsonGenerator.getOutputContext().getCurrentName();
            Field field = ReflectionUtils.findField(jsonGenerator.getCurrentValue().getClass(), (String)filedName);
            if (field != null && (enumField = (EnumField)AnnotationUtils.findAnnotation((AnnotatedElement)field, EnumField.class)) != null) {
                if (this.checkType(field.getType())) {
                    String localeValue = EnumFieldUtils.getEnumValue(enumField, String.valueOf(o));
                    jsonGenerator.writeStringField(jsonGenerator.getOutputContext().getCurrentName() + OBJ_SUFFIX, localeValue);
                } else {
                    this.logger.warn("the type:{} of field:{} in class {} ", new Object[]{field.getType().getClass().getName(), filedName, o.getClass().getName()});
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Jackson serialize object error:", (Throwable)e);
        }
    }

    private boolean checkType(Class<?> type) {
        return this.typeSet.contains(type);
    }
}

